/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.NonNull;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.ActivityLifecycleListener;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.OneSignal;
import com.onesignal.R;
import java.util.HashMap;

public class PermissionsActivity
extends Activity {
    private static final String TAG = PermissionsActivity.class.getCanonicalName();
    private static final int DELAY_TIME_CALLBACK_CALL = 500;
    private static final int ONESIGNAL_PERMISSION_REQUEST_CODE = 2;
    private static final int REQUEST_SETTINGS = 3;
    private static boolean waiting;
    private static boolean fallbackToSettings;
    private static boolean neverAskAgainClicked;
    private static ActivityLifecycleHandler.ActivityAvailableListener activityAvailableListener;
    private static final String INTENT_EXTRA_PERMISSION_TYPE = "INTENT_EXTRA_PERMISSION_TYPE";
    private static final String INTENT_EXTRA_ANDROID_PERMISSION_STRING = "INTENT_EXTRA_ANDROID_PERMISSION_STRING";
    private static final String INTENT_EXTRA_CALLBACK_CLASS = "INTENT_EXTRA_CALLBACK_CLASS";
    private String permissionRequestType;
    private String androidPermissionString;
    private static final HashMap<String, PermissionCallback> callbackMap;

    public static void registerAsCallback(@NonNull String permissionType, @NonNull PermissionCallback callback) {
        callbackMap.put(permissionType, callback);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        OneSignal.initWithContext((Context)this);
        this.handleBundleParams(this.getIntent().getExtras());
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.handleBundleParams(intent.getExtras());
    }

    private void handleBundleParams(Bundle extras) {
        if (Build.VERSION.SDK_INT < 23) {
            this.finish();
            this.overridePendingTransition(R.anim.onesignal_fade_in, R.anim.onesignal_fade_out);
            return;
        }
        this.reregisterCallbackHandlers(extras);
        this.permissionRequestType = extras.getString(INTENT_EXTRA_PERMISSION_TYPE);
        this.androidPermissionString = extras.getString(INTENT_EXTRA_ANDROID_PERMISSION_STRING);
        this.requestPermission(this.androidPermissionString);
    }

    private void reregisterCallbackHandlers(Bundle extras) {
        String className = extras.getString(INTENT_EXTRA_CALLBACK_CLASS);
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find callback class for PermissionActivity: " + className);
        }
    }

    private void requestPermission(String androidPermissionString) {
        if (!waiting) {
            waiting = true;
            neverAskAgainClicked = !AndroidSupportV4Compat.ActivityCompat.shouldShowRequestPermissionRationale(this, androidPermissionString);
            AndroidSupportV4Compat.ActivityCompat.requestPermissions(this, new String[]{androidPermissionString}, 2);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, final @NonNull int[] grantResults) {
        ActivityLifecycleHandler activityLifecycleHandler;
        waiting = false;
        if (requestCode == 2) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    boolean granted = grantResults.length > 0 && grantResults[0] == 0;
                    PermissionCallback callback = (PermissionCallback)callbackMap.get(PermissionsActivity.this.permissionRequestType);
                    if (callback == null) {
                        throw new RuntimeException("Missing handler for permissionRequestType: " + PermissionsActivity.this.permissionRequestType);
                    }
                    if (granted) {
                        callback.onAccept();
                    } else {
                        callback.onReject(PermissionsActivity.this.shouldShowSettings());
                    }
                }
            }, 500L);
        }
        if ((activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler()) != null) {
            activityLifecycleHandler.removeActivityAvailableListener(TAG);
        }
        this.finish();
        this.overridePendingTransition(R.anim.onesignal_fade_in, R.anim.onesignal_fade_out);
    }

    private boolean shouldShowSettings() {
        return fallbackToSettings && neverAskAgainClicked && !AndroidSupportV4Compat.ActivityCompat.shouldShowRequestPermissionRationale(this, this.androidPermissionString);
    }

    static void startPrompt(boolean fallbackCondition, final String permissionRequestType, final String androidPermissionString, final Class<?> callbackClass) {
        if (waiting) {
            return;
        }
        fallbackToSettings = fallbackCondition;
        activityAvailableListener = new ActivityLifecycleHandler.ActivityAvailableListener(){

            @Override
            public void available(@NonNull Activity activity) {
                if (!activity.getClass().equals(PermissionsActivity.class)) {
                    Intent intent = new Intent((Context)activity, PermissionsActivity.class);
                    intent.setFlags(131072);
                    intent.putExtra(PermissionsActivity.INTENT_EXTRA_PERMISSION_TYPE, permissionRequestType).putExtra(PermissionsActivity.INTENT_EXTRA_ANDROID_PERMISSION_STRING, androidPermissionString).putExtra(PermissionsActivity.INTENT_EXTRA_CALLBACK_CLASS, callbackClass.getName());
                    activity.startActivity(intent);
                    activity.overridePendingTransition(R.anim.onesignal_fade_in, R.anim.onesignal_fade_out);
                }
            }
        };
        ActivityLifecycleHandler activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler();
        if (activityLifecycleHandler != null) {
            activityLifecycleHandler.addActivityAvailableListener(TAG, activityAvailableListener);
        }
    }

    static {
        callbackMap = new HashMap();
    }

    static interface PermissionCallback {
        public void onAccept();

        public void onReject(boolean var1);
    }
}

