/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.location.Location;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.onesignal.GoogleApiClientCompatProxy;
import com.onesignal.LocationController;
import com.onesignal.OneSignal;

class GMSLocationController
extends LocationController {
    static final int API_FALLBACK_TIME = 30000;
    private static GoogleApiClientCompatProxy googleApiClient;
    static LocationUpdateListener locationUpdateListener;

    GMSLocationController() {
    }

    static void startGetLocation() {
        GMSLocationController.initGoogleLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initGoogleLocation() {
        if (fallbackFailThread != null) {
            return;
        }
        Object object = syncLock;
        synchronized (object) {
            GMSLocationController.startFallBackThread();
            if (googleApiClient == null || lastLocation == null) {
                GoogleApiClientListener googleApiClientListener = new GoogleApiClientListener();
                GoogleApiClient googleApiClient = new GoogleApiClient.Builder(classContext).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)googleApiClientListener).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)googleApiClientListener).setHandler(GMSLocationController.getLocationHandlerThread().mHandler).build();
                GMSLocationController.googleApiClient = new GoogleApiClientCompatProxy(googleApiClient);
                GMSLocationController.googleApiClient.connect();
            } else {
                GMSLocationController.fireCompleteForLocation(lastLocation);
            }
        }
    }

    private static int getApiFallbackWait() {
        return 30000;
    }

    private static void startFallBackThread() {
        fallbackFailThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(GMSLocationController.getApiFallbackWait());
                    OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Location permission exists but GoogleApiClient timed out. Maybe related to mismatch google-play aar versions.");
                    LocationController.fireFailedComplete();
                    LocationController.scheduleUpdate(LocationController.classContext);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "OS_GMS_LOCATION_FALLBACK");
        fallbackFailThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireFailedComplete() {
        Object object = syncLock;
        synchronized (object) {
            if (googleApiClient != null) {
                googleApiClient.disconnect();
            }
            googleApiClient = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onFocusChange() {
        Object object = syncLock;
        synchronized (object) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "GMSLocationController onFocusChange!");
            if (googleApiClient == null || !googleApiClient.realInstance().isConnected()) {
                return;
            }
            if (googleApiClient != null) {
                GoogleApiClient googleApiClient = GMSLocationController.googleApiClient.realInstance();
                if (locationUpdateListener != null) {
                    LocationServices.FusedLocationApi.removeLocationUpdates(googleApiClient, (LocationListener)locationUpdateListener);
                }
                locationUpdateListener = new LocationUpdateListener(googleApiClient);
            }
        }
    }

    private static class GoogleApiClientListener
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private GoogleApiClientListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnected(Bundle bundle) {
            Object object = LocationController.syncLock;
            synchronized (object) {
                if (googleApiClient == null || googleApiClient.realInstance() == null) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "GMSLocationController GoogleApiClientListener onConnected googleApiClient not available, returning");
                    return;
                }
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "GMSLocationController GoogleApiClientListener onConnected lastLocation: " + LocationController.lastLocation);
                if (LocationController.lastLocation == null) {
                    LocationController.lastLocation = FusedLocationApiWrapper.getLastLocation(googleApiClient.realInstance());
                    OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "GMSLocationController GoogleApiClientListener lastLocation: " + LocationController.lastLocation);
                    if (LocationController.lastLocation != null) {
                        LocationController.fireCompleteForLocation(LocationController.lastLocation);
                    }
                }
                locationUpdateListener = new LocationUpdateListener(googleApiClient.realInstance());
            }
        }

        public void onConnectionSuspended(int i) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "GMSLocationController GoogleApiClientListener onConnectionSuspended i: " + i);
            GMSLocationController.fireFailedComplete();
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "GMSLocationController GoogleApiClientListener onConnectionSuspended connectionResult: " + connectionResult);
            GMSLocationController.fireFailedComplete();
        }
    }

    static class LocationUpdateListener
    implements LocationListener {
        private GoogleApiClient googleApiClient;

        LocationUpdateListener(GoogleApiClient googleApiClient) {
            this.googleApiClient = googleApiClient;
            this.init();
        }

        private void init() {
            long updateInterval = 570000L;
            if (OneSignal.isInForeground()) {
                updateInterval = 270000L;
            }
            if (this.googleApiClient != null) {
                LocationRequest locationRequest = LocationRequest.create().setFastestInterval(updateInterval).setInterval(updateInterval).setMaxWaitTime((long)((double)updateInterval * 1.5)).setPriority(102);
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "GMSLocationController GoogleApiClient requestLocationUpdates!");
                FusedLocationApiWrapper.requestLocationUpdates(this.googleApiClient, locationRequest, this);
            }
        }

        public void onLocationChanged(Location location) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "GMSLocationController onLocationChanged: " + location);
            LocationController.lastLocation = location;
        }
    }

    static class FusedLocationApiWrapper {
        FusedLocationApiWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void requestLocationUpdates(GoogleApiClient googleApiClient, LocationRequest locationRequest, LocationListener locationListener) {
            try {
                Object object = syncLock;
                synchronized (object) {
                    if (Looper.myLooper() == null) {
                        Looper.prepare();
                    }
                    if (googleApiClient.isConnected()) {
                        LocationServices.FusedLocationApi.requestLocationUpdates(googleApiClient, locationRequest, locationListener);
                    }
                }
            }
            catch (Throwable t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "FusedLocationApi.requestLocationUpdates failed!", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Location getLastLocation(GoogleApiClient googleApiClient) {
            Object object = syncLock;
            synchronized (object) {
                if (googleApiClient.isConnected()) {
                    return LocationServices.FusedLocationApi.getLastLocation(googleApiClient);
                }
            }
            return null;
        }
    }
}

