/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.GMSLocationController;
import com.onesignal.GetPackageInfoResult;
import com.onesignal.HMSLocationController;
import com.onesignal.LocationPermissionController;
import com.onesignal.OSSyncService;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import com.onesignal.PackageInfoHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

class LocationController {
    private static final long TIME_FOREGROUND_SEC = 300L;
    private static final long TIME_BACKGROUND_SEC = 600L;
    static final long FOREGROUND_UPDATE_TIME_MS = 270000L;
    static final long BACKGROUND_UPDATE_TIME_MS = 570000L;
    private static final List<LocationPromptCompletionHandler> promptHandlers = new ArrayList<LocationPromptCompletionHandler>();
    private static ConcurrentHashMap<PermissionType, LocationHandler> locationHandlers = new ConcurrentHashMap();
    private static boolean locationCoarse;
    static final Object syncLock;
    private static LocationHandlerThread locationHandlerThread;
    static Thread fallbackFailThread;
    static Context classContext;
    static Location lastLocation;
    static String requestPermission;

    LocationController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LocationHandlerThread getLocationHandlerThread() {
        if (locationHandlerThread == null) {
            Object object = syncLock;
            synchronized (object) {
                if (locationHandlerThread == null) {
                    locationHandlerThread = new LocationHandlerThread();
                }
            }
        }
        return locationHandlerThread;
    }

    static boolean scheduleUpdate(Context context) {
        if (!LocationController.hasLocationPermission(context)) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "LocationController scheduleUpdate not possible, location permission not enabled");
            return false;
        }
        if (!OneSignal.isLocationShared()) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "LocationController scheduleUpdate not possible, location shared not enabled");
            return false;
        }
        long lastTime = OneSignal.getTime().getCurrentTimeMillis() - LocationController.getLastLocationTime();
        long minTime = 1000L * (OneSignal.isInForeground() ? 300L : 600L);
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "LocationController scheduleUpdate lastTime: " + lastTime + " minTime: " + minTime);
        long scheduleTime = minTime - lastTime;
        OSSyncService.getInstance().scheduleLocationUpdateTask(context, scheduleTime);
        return true;
    }

    private static void setLastLocationTime(long time) {
        OneSignalPrefs.saveLong(OneSignalPrefs.PREFS_ONESIGNAL, "OS_LAST_LOCATION_TIME", time);
    }

    private static long getLastLocationTime() {
        return OneSignalPrefs.getLong(OneSignalPrefs.PREFS_ONESIGNAL, "OS_LAST_LOCATION_TIME", -600000L);
    }

    private static boolean hasLocationPermission(Context context) {
        return AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION") == 0 || AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION") == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPromptHandlerIfAvailable(LocationHandler handler) {
        if (handler instanceof LocationPromptCompletionHandler) {
            List<LocationPromptCompletionHandler> list = promptHandlers;
            synchronized (list) {
                promptHandlers.add((LocationPromptCompletionHandler)handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendAndClearPromptHandlers(boolean promptLocation, OneSignal.PromptActionResult result) {
        if (!promptLocation) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "LocationController sendAndClearPromptHandlers from non prompt flow");
            return;
        }
        List<LocationPromptCompletionHandler> list = promptHandlers;
        synchronized (list) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "LocationController calling prompt handlers");
            for (LocationPromptCompletionHandler promptHandler : promptHandlers) {
                promptHandler.onAnswered(result);
            }
            promptHandlers.clear();
        }
    }

    static void getLocation(Context context, boolean promptLocation, boolean fallbackToSettings, LocationHandler handler) {
        LocationController.addPromptHandlerIfAvailable(handler);
        classContext = context;
        locationHandlers.put(handler.getType(), handler);
        if (!OneSignal.isLocationShared()) {
            LocationController.sendAndClearPromptHandlers(promptLocation, OneSignal.PromptActionResult.ERROR);
            LocationController.fireFailedComplete();
            return;
        }
        int locationBackgroundPermission = -1;
        int locationCoarsePermission = -1;
        int locationFinePermission = AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION");
        if (locationFinePermission == -1) {
            locationCoarsePermission = AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
            locationCoarse = true;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            locationBackgroundPermission = AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_BACKGROUND_LOCATION");
        }
        if (Build.VERSION.SDK_INT < 23) {
            if (locationFinePermission != 0 && locationCoarsePermission != 0) {
                LocationController.sendAndClearPromptHandlers(promptLocation, OneSignal.PromptActionResult.LOCATION_PERMISSIONS_MISSING_MANIFEST);
                handler.onComplete(null);
                return;
            }
            LocationController.sendAndClearPromptHandlers(promptLocation, OneSignal.PromptActionResult.PERMISSION_GRANTED);
            LocationController.startGetLocation();
        } else if (locationFinePermission != 0) {
            GetPackageInfoResult packageResult = PackageInfoHelper.Companion.getInfo(context, context.getPackageName(), 4096);
            if (!packageResult.getSuccessful() || packageResult.getPackageInfo() == null) {
                LocationController.sendAndClearPromptHandlers(promptLocation, OneSignal.PromptActionResult.ERROR);
                return;
            }
            List<String> permissionList = Arrays.asList(packageResult.getPackageInfo().requestedPermissions);
            OneSignal.PromptActionResult result = OneSignal.PromptActionResult.PERMISSION_DENIED;
            if (permissionList.contains("android.permission.ACCESS_FINE_LOCATION")) {
                requestPermission = "android.permission.ACCESS_FINE_LOCATION";
            } else if (permissionList.contains("android.permission.ACCESS_COARSE_LOCATION")) {
                if (locationCoarsePermission != 0) {
                    requestPermission = "android.permission.ACCESS_COARSE_LOCATION";
                } else if (Build.VERSION.SDK_INT >= 29 && permissionList.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
                    requestPermission = "android.permission.ACCESS_BACKGROUND_LOCATION";
                }
            } else {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.INFO, "Location permissions not added on AndroidManifest file");
                result = OneSignal.PromptActionResult.LOCATION_PERMISSIONS_MISSING_MANIFEST;
            }
            if (requestPermission != null && promptLocation) {
                LocationPermissionController.INSTANCE.prompt(fallbackToSettings, requestPermission);
            } else if (locationCoarsePermission == 0) {
                LocationController.sendAndClearPromptHandlers(promptLocation, OneSignal.PromptActionResult.PERMISSION_GRANTED);
                LocationController.startGetLocation();
            } else {
                LocationController.sendAndClearPromptHandlers(promptLocation, result);
                LocationController.fireFailedComplete();
            }
        } else if (Build.VERSION.SDK_INT >= 29 && locationBackgroundPermission != 0) {
            LocationController.backgroundLocationPermissionLogic(context, promptLocation, fallbackToSettings);
        } else {
            LocationController.sendAndClearPromptHandlers(promptLocation, OneSignal.PromptActionResult.PERMISSION_GRANTED);
            LocationController.startGetLocation();
        }
    }

    private static void backgroundLocationPermissionLogic(Context context, boolean promptLocation, boolean fallbackToSettings) {
        GetPackageInfoResult result = PackageInfoHelper.Companion.getInfo(context, context.getPackageName(), 4096);
        if (!result.getSuccessful() || result.getPackageInfo() == null) {
            LocationController.sendAndClearPromptHandlers(promptLocation, OneSignal.PromptActionResult.ERROR);
            return;
        }
        List<String> permissionList = Arrays.asList(result.getPackageInfo().requestedPermissions);
        if (permissionList.contains("android.permission.ACCESS_BACKGROUND_LOCATION")) {
            requestPermission = "android.permission.ACCESS_BACKGROUND_LOCATION";
        }
        if (requestPermission != null && promptLocation) {
            LocationPermissionController.INSTANCE.prompt(fallbackToSettings, requestPermission);
        } else {
            LocationController.sendAndClearPromptHandlers(promptLocation, OneSignal.PromptActionResult.PERMISSION_GRANTED);
            LocationController.startGetLocation();
        }
    }

    static void startGetLocation() {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "LocationController startGetLocation with lastLocation: " + lastLocation);
        try {
            if (LocationController.isGooglePlayServicesAvailable()) {
                GMSLocationController.startGetLocation();
            } else if (LocationController.isHMSAvailable()) {
                HMSLocationController.startGetLocation();
            } else {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "LocationController startGetLocation not possible, no location dependency found");
                LocationController.fireFailedComplete();
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Location permission exists but there was an error initializing: ", t);
            LocationController.fireFailedComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onFocusChange() {
        Object object = syncLock;
        synchronized (object) {
            if (LocationController.isGooglePlayServicesAvailable()) {
                GMSLocationController.onFocusChange();
                return;
            }
            if (LocationController.isHMSAvailable()) {
                HMSLocationController.onFocusChange();
            }
        }
    }

    static boolean isGooglePlayServicesAvailable() {
        return OSUtils.isAndroidDeviceType() && OSUtils.hasGMSLocationLibrary();
    }

    static boolean isHMSAvailable() {
        return OSUtils.isHuaweiDeviceType() && OSUtils.hasHMSLocationLibrary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireFailedComplete() {
        Object object = syncLock;
        synchronized (object) {
            if (LocationController.isGooglePlayServicesAvailable()) {
                GMSLocationController.fireFailedComplete();
            } else if (LocationController.isHMSAvailable()) {
                HMSLocationController.fireFailedComplete();
            }
        }
        LocationController.fireComplete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void fireComplete(LocationPoint point) {
        HashMap<PermissionType, LocationHandler> _locationHandlers = new HashMap<PermissionType, LocationHandler>();
        Class<LocationController> clazz = LocationController.class;
        // MONITORENTER : com.onesignal.LocationController.class
        _locationHandlers.putAll(locationHandlers);
        locationHandlers.clear();
        Thread _fallbackFailThread = fallbackFailThread;
        // MONITOREXIT : clazz
        for (PermissionType type : _locationHandlers.keySet()) {
            ((LocationHandler)_locationHandlers.get((Object)type)).onComplete(point);
        }
        if (_fallbackFailThread != null && !Thread.currentThread().equals(_fallbackFailThread)) {
            _fallbackFailThread.interrupt();
        }
        if (_fallbackFailThread == fallbackFailThread) {
            clazz = LocationController.class;
            // MONITORENTER : com.onesignal.LocationController.class
            if (_fallbackFailThread == fallbackFailThread) {
                fallbackFailThread = null;
            }
            // MONITOREXIT : clazz
        }
        LocationController.setLastLocationTime(OneSignal.getTime().getCurrentTimeMillis());
    }

    protected static void fireCompleteForLocation(Location location) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "LocationController fireCompleteForLocation with location: " + location);
        LocationPoint point = new LocationPoint();
        point.accuracy = Float.valueOf(location.getAccuracy());
        point.bg = !OneSignal.isInForeground();
        point.type = locationCoarse ? 0 : 1;
        point.timeStamp = location.getTime();
        if (locationCoarse) {
            point.lat = new BigDecimal(location.getLatitude()).setScale(7, RoundingMode.HALF_UP).doubleValue();
            point.log = new BigDecimal(location.getLongitude()).setScale(7, RoundingMode.HALF_UP).doubleValue();
        } else {
            point.lat = location.getLatitude();
            point.log = location.getLongitude();
        }
        LocationController.fireComplete(point);
        LocationController.scheduleUpdate(classContext);
    }

    static {
        syncLock = new Object(){};
    }

    protected static class LocationHandlerThread
    extends HandlerThread {
        Handler mHandler;

        LocationHandlerThread() {
            super("OSH_LocationHandlerThread");
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }
    }

    static abstract class LocationPromptCompletionHandler
    implements LocationHandler {
        LocationPromptCompletionHandler() {
        }

        void onAnswered(OneSignal.PromptActionResult result) {
        }
    }

    static interface LocationHandler {
        public PermissionType getType();

        public void onComplete(LocationPoint var1);
    }

    static enum PermissionType {
        STARTUP,
        PROMPT_LOCATION,
        SYNC_SERVICE;

    }

    static class LocationPoint {
        Double lat;
        Double log;
        Float accuracy;
        Integer type;
        Boolean bg;
        Long timeStamp;

        LocationPoint() {
        }

        public String toString() {
            return "LocationPoint{lat=" + this.lat + ", log=" + this.log + ", accuracy=" + this.accuracy + ", type=" + this.type + ", bg=" + this.bg + ", timeStamp=" + this.timeStamp + '}';
        }
    }
}

