/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.content.Context;
import com.onesignal.AlertDialogPrepromptForAndroidSettings;
import com.onesignal.LocationController;
import com.onesignal.NavigateToAndroidSettingsForLocation;
import com.onesignal.OneSignal;
import com.onesignal.PermissionsActivity;
import com.onesignal.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004J\b\u0010\u000f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/onesignal/LocationPermissionController;", "Lcom/onesignal/PermissionsActivity$PermissionCallback;", "()V", "PERMISSION_TYPE", "", "onAccept", "", "onReject", "fallbackToSettings", "", "onResponse", "result", "Lcom/onesignal/OneSignal$PromptActionResult;", "prompt", "androidPermissionString", "showFallbackAlertDialog", "onesignal_release"})
public final class LocationPermissionController
implements PermissionsActivity.PermissionCallback {
    @NotNull
    public static final LocationPermissionController INSTANCE = new LocationPermissionController();
    @NotNull
    private static final String PERMISSION_TYPE = "LOCATION";

    private LocationPermissionController() {
    }

    public final void prompt(boolean fallbackToSettings, @NotNull String androidPermissionString) {
        Intrinsics.checkNotNullParameter((Object)androidPermissionString, (String)"androidPermissionString");
        PermissionsActivity.startPrompt(fallbackToSettings, PERMISSION_TYPE, androidPermissionString, this.getClass());
    }

    private final void onResponse(OneSignal.PromptActionResult result) {
        LocationController.sendAndClearPromptHandlers(true, result);
    }

    @Override
    public void onAccept() {
        this.onResponse(OneSignal.PromptActionResult.PERMISSION_GRANTED);
        LocationController.startGetLocation();
    }

    @Override
    public void onReject(boolean fallbackToSettings) {
        this.onResponse(OneSignal.PromptActionResult.PERMISSION_DENIED);
        if (fallbackToSettings) {
            this.showFallbackAlertDialog();
        }
        LocationController.fireFailedComplete();
    }

    private final void showFallbackAlertDialog() {
        Object object;
        Activity activity = OneSignal.getCurrentActivity();
        if (activity == null) {
            return;
        }
        Activity activity2 = object = activity;
        object = activity2.getString(R.string.location_permission_name_for_title);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"activity.getString(R.str\u2026ermission_name_for_title)");
        Object object2 = object;
        object = activity2.getString(R.string.location_permission_settings_message);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"activity.getString(R.str\u2026mission_settings_message)");
        AlertDialogPrepromptForAndroidSettings.INSTANCE.show(activity2, (String)object2, (String)object, new AlertDialogPrepromptForAndroidSettings.Callback(activity2){
            final /* synthetic */ Activity $activity;
            {
                this.$activity = $activity;
            }

            public void onAccept() {
                NavigateToAndroidSettingsForLocation.INSTANCE.show((Context)this.$activity);
                LocationController.sendAndClearPromptHandlers(true, OneSignal.PromptActionResult.PERMISSION_DENIED);
            }

            public void onDecline() {
                LocationController.sendAndClearPromptHandlers(true, OneSignal.PromptActionResult.PERMISSION_DENIED);
            }
        });
    }

    static {
        PermissionsActivity.registerAsCallback(PERMISSION_TYPE, INSTANCE);
    }
}

