/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.onesignal.BackgroundRunnable;
import com.onesignal.CallbackThreadManager;
import com.onesignal.OSBackgroundManager;
import com.onesignal.OSDynamicTriggerController;
import com.onesignal.OSInAppMessageAction;
import com.onesignal.OSInAppMessageContent;
import com.onesignal.OSInAppMessageInternal;
import com.onesignal.OSInAppMessageLifecycleHandler;
import com.onesignal.OSInAppMessageOutcome;
import com.onesignal.OSInAppMessagePage;
import com.onesignal.OSInAppMessagePrompt;
import com.onesignal.OSInAppMessageRepository;
import com.onesignal.OSInAppMessageTag;
import com.onesignal.OSLogger;
import com.onesignal.OSSharedPreferences;
import com.onesignal.OSSystemConditionController;
import com.onesignal.OSTaskController;
import com.onesignal.OSTriggerController;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalChromeTab;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.R;
import com.onesignal.WebViewManager;
import com.onesignal.language.LanguageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSInAppMessageController
extends OSBackgroundManager
implements OSDynamicTriggerController.OSDynamicTriggerControllerObserver,
OSSystemConditionController.OSSystemConditionObserver {
    private static final Object LOCK = new Object();
    private static final String OS_IAM_DB_ACCESS = "OS_IAM_DB_ACCESS";
    public static final String IN_APP_MESSAGES_JSON_KEY = "in_app_messages";
    private static final String LIQUID_TAG_SCRIPT = "\n\n<script>\n    setPlayerTags(%s);\n</script>";
    private static ArrayList<String> PREFERRED_VARIANT_ORDER = new ArrayList<String>(){
        {
            this.add("android");
            this.add("app");
            this.add("all");
        }
    };
    private final OSLogger logger;
    private final OSTaskController taskController;
    private final LanguageContext languageContext;
    private OSSystemConditionController systemConditionController;
    private OSInAppMessageRepository inAppMessageRepository;
    private OSInAppMessageLifecycleHandler inAppMessageLifecycleHandler;
    OSTriggerController triggerController;
    @NonNull
    private ArrayList<OSInAppMessageInternal> messages;
    @NonNull
    private final Set<String> dismissedMessages;
    @NonNull
    private final Set<String> impressionedMessages;
    @NonNull
    private final Set<String> viewedPageIds;
    @NonNull
    private final Set<String> clickedClickIds;
    @NonNull
    private final ArrayList<OSInAppMessageInternal> messageDisplayQueue;
    @Nullable
    private List<OSInAppMessageInternal> redisplayedInAppMessages = null;
    private OSInAppMessagePrompt currentPrompt = null;
    private boolean inAppMessagingEnabled = true;
    private boolean inAppMessageShowing = false;
    @Nullable
    private String userTagsString = "";
    @Nullable
    private OSInAppMessageContent pendingMessageContent = null;
    private boolean waitForTags = false;
    @Nullable
    Date lastTimeInAppDismissed = null;

    protected OSInAppMessageController(OneSignalDbHelper dbHelper, OSTaskController controller, OSLogger logger, OSSharedPreferences sharedPreferences, LanguageContext languageContext) {
        Date tempLastTimeInAppDismissed;
        Set<String> tempClickedMessageIdsSet;
        Set<String> tempPageImpressionsSet;
        Set<String> tempImpressionsSet;
        this.taskController = controller;
        this.messages = new ArrayList();
        this.dismissedMessages = OSUtils.newConcurrentSet();
        this.messageDisplayQueue = new ArrayList();
        this.impressionedMessages = OSUtils.newConcurrentSet();
        this.viewedPageIds = OSUtils.newConcurrentSet();
        this.clickedClickIds = OSUtils.newConcurrentSet();
        this.triggerController = new OSTriggerController(this);
        this.systemConditionController = new OSSystemConditionController(this);
        this.languageContext = languageContext;
        this.logger = logger;
        this.inAppMessageRepository = this.getInAppMessageRepository(dbHelper, logger, sharedPreferences);
        Set<String> tempDismissedSet = this.inAppMessageRepository.getDismissedMessagesId();
        if (tempDismissedSet != null) {
            this.dismissedMessages.addAll(tempDismissedSet);
        }
        if ((tempImpressionsSet = this.inAppMessageRepository.getImpressionesMessagesId()) != null) {
            this.impressionedMessages.addAll(tempImpressionsSet);
        }
        if ((tempPageImpressionsSet = this.inAppMessageRepository.getViewPageImpressionedIds()) != null) {
            this.viewedPageIds.addAll(tempPageImpressionsSet);
        }
        if ((tempClickedMessageIdsSet = this.inAppMessageRepository.getClickedMessagesId()) != null) {
            this.clickedClickIds.addAll(tempClickedMessageIdsSet);
        }
        if ((tempLastTimeInAppDismissed = this.inAppMessageRepository.getLastTimeInAppDismissed()) != null) {
            this.lastTimeInAppDismissed = tempLastTimeInAppDismissed;
        }
        this.initRedisplayData();
    }

    OSInAppMessageRepository getInAppMessageRepository(OneSignalDbHelper dbHelper, OSLogger logger, OSSharedPreferences sharedPreferences) {
        if (this.inAppMessageRepository == null) {
            this.inAppMessageRepository = new OSInAppMessageRepository(dbHelper, logger, sharedPreferences);
        }
        return this.inAppMessageRepository;
    }

    protected void initRedisplayData() {
        BackgroundRunnable getCachedIAMRunnable = new BackgroundRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                super.run();
                Object object = LOCK;
                synchronized (object) {
                    OSInAppMessageController.this.redisplayedInAppMessages = OSInAppMessageController.this.inAppMessageRepository.getCachedInAppMessages();
                    OSInAppMessageController.this.logger.debug("Retrieved IAMs from DB redisplayedInAppMessages: " + OSInAppMessageController.this.redisplayedInAppMessages.toString());
                }
            }
        };
        this.taskController.addTaskToQueue(getCachedIAMRunnable);
        this.taskController.startPendingTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldRunTaskThroughQueue() {
        Object object = LOCK;
        synchronized (object) {
            return this.redisplayedInAppMessages == null && this.taskController.shouldRunTaskThroughQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeRedisplayIAMDataDependantTask(Runnable task) {
        Object object = LOCK;
        synchronized (object) {
            if (this.shouldRunTaskThroughQueue()) {
                this.logger.debug("Delaying task due to redisplay data not retrieved yet");
                this.taskController.addTaskToQueue(task);
            } else {
                task.run();
            }
        }
    }

    void resetSessionLaunchTime() {
        OSDynamicTriggerController.resetSessionLaunchTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initWithCachedInAppMessages() {
        if (!this.messages.isEmpty()) {
            this.logger.debug("initWithCachedInAppMessages with already in memory messages: " + this.messages);
            return;
        }
        String cachedInAppMessageString = this.inAppMessageRepository.getSavedIAMs();
        this.logger.debug("initWithCachedInAppMessages: " + cachedInAppMessageString);
        if (cachedInAppMessageString == null || cachedInAppMessageString.isEmpty()) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            try {
                if (!this.messages.isEmpty()) {
                    return;
                }
                this.processInAppMessageJson(new JSONArray(cachedInAppMessageString));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    void receivedInAppMessageJson(final @NonNull JSONArray json) throws JSONException {
        this.inAppMessageRepository.saveIAMs(json.toString());
        this.executeRedisplayIAMDataDependantTask(new Runnable(){

            @Override
            public void run() {
                OSInAppMessageController.this.resetRedisplayMessagesBySession();
                try {
                    OSInAppMessageController.this.processInAppMessageJson(json);
                }
                catch (JSONException e) {
                    OSInAppMessageController.this.logger.error("ERROR processing InAppMessageJson JSON Response.", e);
                }
            }
        });
    }

    private void resetRedisplayMessagesBySession() {
        for (OSInAppMessageInternal redisplayInAppMessage : this.redisplayedInAppMessages) {
            redisplayInAppMessage.setDisplayedInSession(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInAppMessageJson(@NonNull JSONArray json) throws JSONException {
        Object object = LOCK;
        synchronized (object) {
            ArrayList<OSInAppMessageInternal> newMessages = new ArrayList<OSInAppMessageInternal>();
            for (int i = 0; i < json.length(); ++i) {
                JSONObject messageJson = json.getJSONObject(i);
                OSInAppMessageInternal message = new OSInAppMessageInternal(messageJson);
                if (message.messageId == null) continue;
                newMessages.add(message);
            }
            this.messages = newMessages;
        }
        this.evaluateInAppMessages();
    }

    private void evaluateInAppMessages() {
        this.logger.debug("Starting evaluateInAppMessages");
        if (this.shouldRunTaskThroughQueue()) {
            this.taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    OSInAppMessageController.this.logger.debug("Delaying evaluateInAppMessages due to redisplay data not retrieved yet");
                    OSInAppMessageController.this.evaluateInAppMessages();
                }
            });
            return;
        }
        for (OSInAppMessageInternal message : this.messages) {
            if (!this.triggerController.evaluateMessageTriggers(message)) continue;
            this.setDataForRedisplay(message);
            if (this.dismissedMessages.contains(message.messageId) || message.isFinished()) continue;
            this.queueMessageForDisplay(message);
        }
    }

    @Nullable
    private String variantIdForMessage(@NonNull OSInAppMessageInternal message) {
        String language = this.languageContext.getLanguage();
        for (String variant : PREFERRED_VARIANT_ORDER) {
            if (!message.variants.containsKey(variant)) continue;
            HashMap<String, String> variantMap = message.variants.get(variant);
            if (variantMap.containsKey(language)) {
                return variantMap.get(language);
            }
            return variantMap.get("default");
        }
        return null;
    }

    void onMessageWasShown(final @NonNull OSInAppMessageInternal message) {
        this.onMessageDidDisplay(message);
        if (message.isPreview) {
            return;
        }
        if (this.impressionedMessages.contains(message.messageId)) {
            return;
        }
        this.impressionedMessages.add(message.messageId);
        String variantId = this.variantIdForMessage(message);
        if (variantId == null) {
            return;
        }
        this.inAppMessageRepository.sendIAMImpression(OneSignal.appId, OneSignal.getUserId(), variantId, new OSUtils().getDeviceType(), message.messageId, this.impressionedMessages, new OSInAppMessageRepository.OSInAppMessageRequestResponse(){

            @Override
            public void onSuccess(String response) {
            }

            @Override
            public void onFailure(String response) {
                OSInAppMessageController.this.impressionedMessages.remove(message.messageId);
            }
        });
    }

    void onPageChanged(@NonNull OSInAppMessageInternal message, @NonNull JSONObject eventJson) {
        OSInAppMessagePage newPage = new OSInAppMessagePage(eventJson);
        if (message.isPreview) {
            return;
        }
        this.fireRESTCallForPageChange(message, newPage);
    }

    void onMessageActionOccurredOnMessage(@NonNull OSInAppMessageInternal message, @NonNull JSONObject actionJson) throws JSONException {
        OSInAppMessageAction action = new OSInAppMessageAction(actionJson);
        action.setFirstClick(message.takeActionAsUnique());
        this.firePublicClickHandler(message.messageId, action);
        this.beginProcessingPrompts(message, action.getPrompts());
        this.fireClickAction(action);
        this.fireRESTCallForClick(message, action);
        this.fireTagCallForClick(action);
        this.fireOutcomesForClick(message.messageId, action.getOutcomes());
    }

    void onMessageActionOccurredOnPreview(@NonNull OSInAppMessageInternal message, @NonNull JSONObject actionJson) throws JSONException {
        OSInAppMessageAction action = new OSInAppMessageAction(actionJson);
        action.setFirstClick(message.takeActionAsUnique());
        this.firePublicClickHandler(message.messageId, action);
        this.beginProcessingPrompts(message, action.getPrompts());
        this.fireClickAction(action);
        this.logInAppMessagePreviewActions(action);
    }

    void setInAppMessageLifecycleHandler(@Nullable OSInAppMessageLifecycleHandler handler) {
        this.inAppMessageLifecycleHandler = handler;
    }

    void onMessageWillDisplay(@NonNull OSInAppMessageInternal message) {
        if (this.inAppMessageLifecycleHandler == null) {
            this.logger.verbose("OSInAppMessageController onMessageWillDisplay: inAppMessageLifecycleHandler is null");
            return;
        }
        this.inAppMessageLifecycleHandler.onWillDisplayInAppMessage(message);
    }

    void onMessageDidDisplay(@NonNull OSInAppMessageInternal message) {
        if (this.inAppMessageLifecycleHandler == null) {
            this.logger.verbose("OSInAppMessageController onMessageDidDisplay: inAppMessageLifecycleHandler is null");
            return;
        }
        this.inAppMessageLifecycleHandler.onDidDisplayInAppMessage(message);
    }

    void onMessageWillDismiss(@NonNull OSInAppMessageInternal message) {
        if (this.inAppMessageLifecycleHandler == null) {
            this.logger.verbose("OSInAppMessageController onMessageWillDismiss: inAppMessageLifecycleHandler is null");
            return;
        }
        this.inAppMessageLifecycleHandler.onWillDismissInAppMessage(message);
    }

    void onMessageDidDismiss(@NonNull OSInAppMessageInternal message) {
        if (this.inAppMessageLifecycleHandler == null) {
            this.logger.verbose("OSInAppMessageController onMessageDidDismiss: inAppMessageLifecycleHandler is null");
            return;
        }
        this.inAppMessageLifecycleHandler.onDidDismissInAppMessage(message);
    }

    private void logInAppMessagePreviewActions(OSInAppMessageAction action) {
        if (action.getTags() != null) {
            this.logger.debug("Tags detected inside of the action click payload, ignoring because action came from IAM preview:: " + action.getTags().toString());
        }
        if (action.getOutcomes().size() > 0) {
            this.logger.debug("Outcomes detected inside of the action click payload, ignoring because action came from IAM preview: " + action.getOutcomes().toString());
        }
    }

    private void beginProcessingPrompts(OSInAppMessageInternal message, List<OSInAppMessagePrompt> prompts) {
        if (prompts.size() > 0) {
            this.logger.debug("IAM showing prompts from IAM: " + message.toString());
            WebViewManager.dismissCurrentInAppMessage();
            this.showMultiplePrompts(message, prompts);
        }
    }

    private void showMultiplePrompts(final OSInAppMessageInternal inAppMessage, final List<OSInAppMessagePrompt> prompts) {
        for (OSInAppMessagePrompt prompt : prompts) {
            if (prompt.hasPrompted()) continue;
            this.currentPrompt = prompt;
            break;
        }
        if (this.currentPrompt != null) {
            this.logger.debug("IAM prompt to handle: " + this.currentPrompt.toString());
            this.currentPrompt.setPrompted(true);
            this.currentPrompt.handlePrompt(new OneSignal.OSPromptActionCompletionCallback(){

                @Override
                public void onCompleted(OneSignal.PromptActionResult result) {
                    OSInAppMessageController.this.currentPrompt = null;
                    OSInAppMessageController.this.logger.debug("IAM prompt to handle finished with result: " + (Object)((Object)result));
                    if (inAppMessage.isPreview && result == OneSignal.PromptActionResult.LOCATION_PERMISSIONS_MISSING_MANIFEST) {
                        OSInAppMessageController.this.showAlertDialogMessage(inAppMessage, prompts);
                    } else {
                        OSInAppMessageController.this.showMultiplePrompts(inAppMessage, prompts);
                    }
                }
            });
        } else {
            this.logger.debug("No IAM prompt to handle, dismiss message: " + inAppMessage.messageId);
            this.messageWasDismissed(inAppMessage);
        }
    }

    private void showAlertDialogMessage(final OSInAppMessageInternal inAppMessage, final List<OSInAppMessagePrompt> prompts) {
        String messageTitle = OneSignal.appContext.getString(R.string.location_permission_missing_title);
        String message = OneSignal.appContext.getString(R.string.location_permission_missing_message);
        new AlertDialog.Builder((Context)OneSignal.getCurrentActivity()).setTitle((CharSequence)messageTitle).setMessage((CharSequence)message).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                OSInAppMessageController.this.showMultiplePrompts(inAppMessage, prompts);
            }
        }).show();
    }

    private void fireOutcomesForClick(String messageId, @NonNull List<OSInAppMessageOutcome> outcomes) {
        OneSignal.getSessionManager().onDirectInfluenceFromIAMClick(messageId);
        OneSignal.sendClickActionOutcomes(outcomes);
    }

    private void fireTagCallForClick(@NonNull OSInAppMessageAction action) {
        if (action.getTags() != null) {
            OSInAppMessageTag tags = action.getTags();
            if (tags.getTagsToAdd() != null) {
                OneSignal.sendTags(tags.getTagsToAdd());
            }
            if (tags.getTagsToRemove() != null) {
                OneSignal.deleteTags(tags.getTagsToRemove(), null);
            }
        }
    }

    private void firePublicClickHandler(final @NonNull String messageId, final @NonNull OSInAppMessageAction action) {
        if (OneSignal.inAppMessageClickHandler == null) {
            return;
        }
        CallbackThreadManager.Companion.runOnPreferred(new Runnable(){

            @Override
            public void run() {
                OneSignal.getSessionManager().onDirectInfluenceFromIAMClick(messageId);
                OneSignal.inAppMessageClickHandler.inAppMessageClicked(action);
            }
        });
    }

    private void fireClickAction(@NonNull OSInAppMessageAction action) {
        if (action.getClickUrl() != null && !action.getClickUrl().isEmpty()) {
            if (action.getUrlTarget() == OSInAppMessageAction.OSInAppMessageActionUrlType.BROWSER) {
                OSUtils.openURLInBrowser(action.getClickUrl());
            } else if (action.getUrlTarget() == OSInAppMessageAction.OSInAppMessageActionUrlType.IN_APP_WEBVIEW) {
                OneSignalChromeTab.open(action.getClickUrl(), true);
            }
        }
    }

    private void fireRESTCallForPageChange(@NonNull OSInAppMessageInternal message, @NonNull OSInAppMessagePage page) {
        String variantId = this.variantIdForMessage(message);
        if (variantId == null) {
            return;
        }
        String pageId = page.getPageId();
        final String messagePrefixedPageId = message.messageId + pageId;
        if (this.viewedPageIds.contains(messagePrefixedPageId)) {
            this.logger.verbose("Already sent page impression for id: " + pageId);
            return;
        }
        this.viewedPageIds.add(messagePrefixedPageId);
        this.inAppMessageRepository.sendIAMPageImpression(OneSignal.appId, OneSignal.getUserId(), variantId, new OSUtils().getDeviceType(), message.messageId, pageId, this.viewedPageIds, new OSInAppMessageRepository.OSInAppMessageRequestResponse(){

            @Override
            public void onSuccess(String response) {
            }

            @Override
            public void onFailure(String response) {
                OSInAppMessageController.this.viewedPageIds.remove(messagePrefixedPageId);
            }
        });
    }

    private void fireRESTCallForClick(final @NonNull OSInAppMessageInternal message, @NonNull OSInAppMessageAction action) {
        boolean clickAvailableByRedisplay;
        String variantId = this.variantIdForMessage(message);
        if (variantId == null) {
            return;
        }
        final String clickId = action.getClickId();
        boolean bl = clickAvailableByRedisplay = message.getRedisplayStats().isRedisplayEnabled() && message.isClickAvailable(clickId);
        if (!clickAvailableByRedisplay && this.clickedClickIds.contains(clickId)) {
            return;
        }
        this.clickedClickIds.add(clickId);
        message.addClickId(clickId);
        this.inAppMessageRepository.sendIAMClick(OneSignal.appId, OneSignal.getUserId(), variantId, new OSUtils().getDeviceType(), message.messageId, clickId, action.isFirstClick(), this.clickedClickIds, new OSInAppMessageRepository.OSInAppMessageRequestResponse(){

            @Override
            public void onSuccess(String response) {
            }

            @Override
            public void onFailure(String response) {
                OSInAppMessageController.this.clickedClickIds.remove(clickId);
                message.removeClickId(clickId);
            }
        });
    }

    private void setDataForRedisplay(OSInAppMessageInternal message) {
        boolean messageDismissed = this.dismissedMessages.contains(message.messageId);
        int index = this.redisplayedInAppMessages.indexOf(message);
        if (messageDismissed && index != -1) {
            OSInAppMessageInternal savedIAM = this.redisplayedInAppMessages.get(index);
            message.getRedisplayStats().setDisplayStats(savedIAM.getRedisplayStats());
            message.setDisplayedInSession(savedIAM.isDisplayedInSession());
            boolean triggerHasChanged = this.hasMessageTriggerChanged(message);
            this.logger.debug("setDataForRedisplay: " + message.toString() + " triggerHasChanged: " + triggerHasChanged);
            if (triggerHasChanged && message.getRedisplayStats().isDelayTimeSatisfied() && message.getRedisplayStats().shouldDisplayAgain()) {
                this.logger.debug("setDataForRedisplay message available for redisplay: " + message.messageId);
                this.dismissedMessages.remove(message.messageId);
                this.impressionedMessages.remove(message.messageId);
                this.viewedPageIds.clear();
                this.inAppMessageRepository.saveViewPageImpressionedIds(this.viewedPageIds);
                message.clearClickIds();
            }
        }
    }

    private boolean hasMessageTriggerChanged(OSInAppMessageInternal message) {
        boolean messageHasOnlyDynamicTrigger = this.triggerController.messageHasOnlyDynamicTriggers(message);
        if (messageHasOnlyDynamicTrigger) {
            return !message.isDisplayedInSession();
        }
        boolean shouldMessageDisplayInSession = !message.isDisplayedInSession() && message.triggers.isEmpty();
        return message.isTriggerChanged() || shouldMessageDisplayInSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueMessageForDisplay(@NonNull OSInAppMessageInternal message) {
        ArrayList<OSInAppMessageInternal> arrayList = this.messageDisplayQueue;
        synchronized (arrayList) {
            if (!this.messageDisplayQueue.contains(message)) {
                this.messageDisplayQueue.add(message);
                this.logger.debug("In app message with id: " + message.messageId + ", added to the queue");
            }
            this.attemptToShowInAppMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptToShowInAppMessage() {
        ArrayList<OSInAppMessageInternal> arrayList = this.messageDisplayQueue;
        synchronized (arrayList) {
            if (!this.systemConditionController.systemConditionsAvailable()) {
                this.logger.warning("In app message not showing due to system condition not correct");
                return;
            }
            this.logger.debug("displayFirstIAMOnQueue: " + this.messageDisplayQueue);
            if (this.messageDisplayQueue.size() > 0 && !this.isInAppMessageShowing()) {
                this.logger.debug("No IAM showing currently, showing first item in the queue!");
                this.displayMessage(this.messageDisplayQueue.get(0));
                return;
            }
            this.logger.debug("In app message is currently showing or there are no IAMs left in the queue! isInAppMessageShowing: " + this.isInAppMessageShowing());
        }
    }

    boolean isInAppMessageShowing() {
        return this.inAppMessageShowing;
    }

    @Nullable
    OSInAppMessageInternal getCurrentDisplayedInAppMessage() {
        return this.inAppMessageShowing ? this.messageDisplayQueue.get(0) : null;
    }

    void messageWasDismissed(@NonNull OSInAppMessageInternal message) {
        this.messageWasDismissed(message, false);
    }

    void messageWasDismissed(@NonNull OSInAppMessageInternal message, boolean failed) {
        if (!message.isPreview) {
            this.dismissedMessages.add(message.messageId);
            if (!failed) {
                this.inAppMessageRepository.saveDismissedMessagesId(this.dismissedMessages);
                this.lastTimeInAppDismissed = new Date();
                this.persistInAppMessage(message);
            }
            this.logger.debug("OSInAppMessageController messageWasDismissed dismissedMessages: " + this.dismissedMessages.toString());
        }
        if (!this.shouldWaitForPromptsBeforeDismiss()) {
            this.onMessageDidDismiss(message);
        }
        this.dismissCurrentMessage(message);
    }

    private boolean shouldWaitForPromptsBeforeDismiss() {
        return this.currentPrompt != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dismissCurrentMessage(@Nullable OSInAppMessageInternal message) {
        OneSignal.getSessionManager().onDirectInfluenceFromIAMClickFinished();
        if (this.shouldWaitForPromptsBeforeDismiss()) {
            this.logger.debug("Stop evaluateMessageDisplayQueue because prompt is currently displayed");
            return;
        }
        this.inAppMessageShowing = false;
        ArrayList<OSInAppMessageInternal> arrayList = this.messageDisplayQueue;
        synchronized (arrayList) {
            if (message != null && !message.isPreview && this.messageDisplayQueue.size() > 0) {
                if (!this.messageDisplayQueue.contains(message)) {
                    this.logger.debug("Message already removed from the queue!");
                    return;
                }
                String removedMessageId = this.messageDisplayQueue.remove((int)0).messageId;
                this.logger.debug("In app message with id: " + removedMessageId + ", dismissed (removed) from the queue!");
            }
            if (this.messageDisplayQueue.size() > 0) {
                this.logger.debug("In app message on queue available: " + this.messageDisplayQueue.get((int)0).messageId);
                this.displayMessage(this.messageDisplayQueue.get(0));
            } else {
                this.logger.debug("In app message dismissed evaluating messages");
                this.evaluateInAppMessages();
            }
        }
    }

    private void persistInAppMessage(final OSInAppMessageInternal message) {
        long displayTimeSeconds = OneSignal.getTime().getCurrentTimeMillis() / 1000L;
        message.getRedisplayStats().setLastDisplayTime(displayTimeSeconds);
        message.getRedisplayStats().incrementDisplayQuantity();
        message.setTriggerChanged(false);
        message.setDisplayedInSession(true);
        BackgroundRunnable saveIAMOnDBRunnable = new BackgroundRunnable(){

            @Override
            public void run() {
                super.run();
                OSInAppMessageController.this.inAppMessageRepository.saveInAppMessage(message);
                OSInAppMessageController.this.inAppMessageRepository.saveLastTimeInAppDismissed(OSInAppMessageController.this.lastTimeInAppDismissed);
            }
        };
        this.runRunnableOnThread(saveIAMOnDBRunnable, OS_IAM_DB_ACCESS);
        int index = this.redisplayedInAppMessages.indexOf(message);
        if (index != -1) {
            this.redisplayedInAppMessages.set(index, message);
        } else {
            this.redisplayedInAppMessages.add(message);
        }
        this.logger.debug("persistInAppMessageForRedisplay: " + message.toString() + " with msg array data: " + this.redisplayedInAppMessages.toString());
    }

    private void getTagsForLiquidTemplating(final @NonNull OSInAppMessageInternal message, final boolean isPreview) {
        this.waitForTags = false;
        if (isPreview || message.getHasLiquid()) {
            this.waitForTags = true;
            OneSignal.getTags(new OneSignal.OSGetTagsHandler(){

                @Override
                public void tagsAvailable(JSONObject tags) {
                    OSInAppMessageController.this.waitForTags = false;
                    if (tags != null) {
                        OSInAppMessageController.this.userTagsString = tags.toString();
                    }
                    if (OSInAppMessageController.this.pendingMessageContent != null) {
                        if (!isPreview) {
                            OneSignal.getSessionManager().onInAppMessageReceived(message.messageId);
                        }
                        OSInAppMessageController.this.pendingMessageContent.setContentHtml(OSInAppMessageController.this.taggedHTMLString(OSInAppMessageController.this.pendingMessageContent.getContentHtml()));
                        WebViewManager.showMessageContent(message, OSInAppMessageController.this.pendingMessageContent);
                        OSInAppMessageController.this.pendingMessageContent = null;
                    }
                }
            });
        }
    }

    private OSInAppMessageContent parseMessageContentData(JSONObject data, OSInAppMessageInternal message) {
        OSInAppMessageContent content = new OSInAppMessageContent(data);
        message.setDisplayDuration(content.getDisplayDuration());
        return content;
    }

    private void displayMessage(final @NonNull OSInAppMessageInternal message) {
        if (!this.inAppMessagingEnabled) {
            this.logger.verbose("In app messaging is currently paused, in app messages will not be shown!");
            return;
        }
        this.inAppMessageShowing = true;
        this.getTagsForLiquidTemplating(message, false);
        this.inAppMessageRepository.getIAMData(OneSignal.appId, message.messageId, this.variantIdForMessage(message), new OSInAppMessageRepository.OSInAppMessageRequestResponse(){

            @Override
            public void onSuccess(String response) {
                try {
                    JSONObject jsonResponse = new JSONObject(response);
                    OSInAppMessageContent content = OSInAppMessageController.this.parseMessageContentData(jsonResponse, message);
                    if (content.getContentHtml() == null) {
                        OSInAppMessageController.this.logger.debug("displayMessage:OnSuccess: No HTML retrieved from loadMessageContent");
                        return;
                    }
                    if (OSInAppMessageController.this.waitForTags) {
                        OSInAppMessageController.this.pendingMessageContent = content;
                        return;
                    }
                    OneSignal.getSessionManager().onInAppMessageReceived(message.messageId);
                    OSInAppMessageController.this.onMessageWillDisplay(message);
                    content.setContentHtml(OSInAppMessageController.this.taggedHTMLString(content.getContentHtml()));
                    WebViewManager.showMessageContent(message, content);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFailure(String response) {
                OSInAppMessageController.this.inAppMessageShowing = false;
                try {
                    JSONObject jsonResponse = new JSONObject(response);
                    boolean retry = jsonResponse.getBoolean("retry");
                    if (retry) {
                        OSInAppMessageController.this.queueMessageForDisplay(message);
                    } else {
                        OSInAppMessageController.this.messageWasDismissed(message, true);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @NonNull
    String taggedHTMLString(@NonNull String untaggedString) {
        String tagsDict = this.userTagsString;
        String tagScript = LIQUID_TAG_SCRIPT;
        return untaggedString + String.format(tagScript, tagsDict);
    }

    void displayPreviewMessage(@NonNull String previewUUID) {
        this.inAppMessageShowing = true;
        final OSInAppMessageInternal message = new OSInAppMessageInternal(true);
        this.getTagsForLiquidTemplating(message, true);
        this.inAppMessageRepository.getIAMPreviewData(OneSignal.appId, previewUUID, new OSInAppMessageRepository.OSInAppMessageRequestResponse(){

            @Override
            public void onSuccess(String response) {
                try {
                    JSONObject jsonResponse = new JSONObject(response);
                    OSInAppMessageContent content = OSInAppMessageController.this.parseMessageContentData(jsonResponse, message);
                    if (content.getContentHtml() == null) {
                        OSInAppMessageController.this.logger.debug("displayPreviewMessage:OnSuccess: No HTML retrieved from loadMessageContent");
                        return;
                    }
                    if (OSInAppMessageController.this.waitForTags) {
                        OSInAppMessageController.this.pendingMessageContent = content;
                        return;
                    }
                    OSInAppMessageController.this.onMessageWillDisplay(message);
                    content.setContentHtml(OSInAppMessageController.this.taggedHTMLString(content.getContentHtml()));
                    WebViewManager.showMessageContent(message, content);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFailure(String response) {
                OSInAppMessageController.this.dismissCurrentMessage(null);
            }
        });
    }

    void cleanCachedInAppMessages() {
        BackgroundRunnable cleanCachedIAMRunnable = new BackgroundRunnable(){

            @Override
            public void run() {
                super.run();
                OSInAppMessageController.this.inAppMessageRepository.cleanCachedInAppMessages();
            }
        };
        this.runRunnableOnThread(cleanCachedIAMRunnable, OS_IAM_DB_ACCESS);
    }

    @Override
    public void messageDynamicTriggerCompleted(String triggerId) {
        this.logger.debug("messageDynamicTriggerCompleted called with triggerId: " + triggerId);
        HashSet<String> triggerIds = new HashSet<String>();
        triggerIds.add(triggerId);
        this.makeRedisplayMessagesAvailableWithTriggers(triggerIds);
    }

    @Override
    public void messageTriggerConditionChanged() {
        this.logger.debug("messageTriggerConditionChanged called");
        this.evaluateInAppMessages();
    }

    @Override
    public void systemConditionChanged() {
        this.attemptToShowInAppMessage();
    }

    private void makeRedisplayMessagesAvailableWithTriggers(Collection<String> newTriggersKeys) {
        for (OSInAppMessageInternal message : this.messages) {
            if (message.isTriggerChanged() || !this.redisplayedInAppMessages.contains(message) || !this.triggerController.isTriggerOnMessage(message, newTriggersKeys)) continue;
            this.logger.debug("Trigger changed for message: " + message.toString());
            message.setTriggerChanged(true);
        }
    }

    private void checkRedisplayMessagesAndEvaluate(Collection<String> newTriggersKeys) {
        this.makeRedisplayMessagesAvailableWithTriggers(newTriggersKeys);
        this.evaluateInAppMessages();
    }

    void addTriggers(final @NonNull Map<String, Object> newTriggers) {
        this.logger.debug("Triggers added: " + newTriggers.toString());
        this.triggerController.addTriggers(newTriggers);
        if (this.shouldRunTaskThroughQueue()) {
            this.taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    OSInAppMessageController.this.logger.debug("Delaying addTriggers due to redisplay data not retrieved yet");
                    OSInAppMessageController.this.checkRedisplayMessagesAndEvaluate(newTriggers.keySet());
                }
            });
        } else {
            this.checkRedisplayMessagesAndEvaluate(newTriggers.keySet());
        }
    }

    void removeTriggersForKeys(final Collection<String> keys) {
        this.logger.debug("Triggers key to remove: " + keys.toString());
        this.triggerController.removeTriggersForKeys(keys);
        if (this.shouldRunTaskThroughQueue()) {
            this.taskController.addTaskToQueue(new Runnable(){

                @Override
                public void run() {
                    OSInAppMessageController.this.logger.debug("Delaying removeTriggersForKeys due to redisplay data not retrieved yet");
                    OSInAppMessageController.this.checkRedisplayMessagesAndEvaluate(keys);
                }
            });
        } else {
            this.checkRedisplayMessagesAndEvaluate(keys);
        }
    }

    Map<String, Object> getTriggers() {
        return new HashMap<String, Object>(this.triggerController.getTriggers());
    }

    boolean inAppMessagingEnabled() {
        return this.inAppMessagingEnabled;
    }

    void setInAppMessagingEnabled(boolean enabled) {
        this.inAppMessagingEnabled = enabled;
        if (enabled) {
            this.evaluateInAppMessages();
        }
    }

    @Nullable
    Object getTriggerValue(String key) {
        return this.triggerController.getTriggerValue(key);
    }

    @NonNull
    public ArrayList<OSInAppMessageInternal> getInAppMessageDisplayQueue() {
        return this.messageDisplayQueue;
    }

    @NonNull
    public List<OSInAppMessageInternal> getRedisplayedInAppMessages() {
        return this.redisplayedInAppMessages;
    }
}

