/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.Nullable;
import com.onesignal.CallbackThreadManager;
import com.onesignal.LocationController;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import com.onesignal.UserStateEmailSynchronizer;
import com.onesignal.UserStatePushSynchronizer;
import com.onesignal.UserStateSMSSynchronizer;
import com.onesignal.UserStateSynchronizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

class OneSignalStateSynchronizer {
    private static final Object LOCK = new Object();
    private static HashMap<UserStateSynchronizerType, UserStateSynchronizer> userStateSynchronizers = new HashMap();

    OneSignalStateSynchronizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UserStatePushSynchronizer getPushStateSynchronizer() {
        if (!userStateSynchronizers.containsKey((Object)UserStateSynchronizerType.PUSH) || userStateSynchronizers.get((Object)UserStateSynchronizerType.PUSH) == null) {
            Object object = LOCK;
            synchronized (object) {
                if (userStateSynchronizers.get((Object)UserStateSynchronizerType.PUSH) == null) {
                    userStateSynchronizers.put(UserStateSynchronizerType.PUSH, new UserStatePushSynchronizer());
                }
            }
        }
        return (UserStatePushSynchronizer)userStateSynchronizers.get((Object)UserStateSynchronizerType.PUSH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UserStateEmailSynchronizer getEmailStateSynchronizer() {
        if (!userStateSynchronizers.containsKey((Object)UserStateSynchronizerType.EMAIL) || userStateSynchronizers.get((Object)UserStateSynchronizerType.EMAIL) == null) {
            Object object = LOCK;
            synchronized (object) {
                if (userStateSynchronizers.get((Object)UserStateSynchronizerType.EMAIL) == null) {
                    userStateSynchronizers.put(UserStateSynchronizerType.EMAIL, new UserStateEmailSynchronizer());
                }
            }
        }
        return (UserStateEmailSynchronizer)userStateSynchronizers.get((Object)UserStateSynchronizerType.EMAIL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UserStateSMSSynchronizer getSMSStateSynchronizer() {
        if (!userStateSynchronizers.containsKey((Object)UserStateSynchronizerType.SMS) || userStateSynchronizers.get((Object)UserStateSynchronizerType.SMS) == null) {
            Object object = LOCK;
            synchronized (object) {
                if (userStateSynchronizers.get((Object)UserStateSynchronizerType.SMS) == null) {
                    userStateSynchronizers.put(UserStateSynchronizerType.SMS, new UserStateSMSSynchronizer());
                }
            }
        }
        return (UserStateSMSSynchronizer)userStateSynchronizers.get((Object)UserStateSynchronizerType.SMS);
    }

    static List<UserStateSynchronizer> getUserStateSynchronizers() {
        ArrayList<UserStateSynchronizer> userStateSynchronizers = new ArrayList<UserStateSynchronizer>();
        userStateSynchronizers.add(OneSignalStateSynchronizer.getPushStateSynchronizer());
        if (OneSignal.hasEmailId()) {
            userStateSynchronizers.add(OneSignalStateSynchronizer.getEmailStateSynchronizer());
        }
        if (OneSignal.hasSMSlId()) {
            userStateSynchronizers.add(OneSignalStateSynchronizer.getSMSStateSynchronizer());
        }
        return userStateSynchronizers;
    }

    static boolean persist() {
        boolean pushPersisted = OneSignalStateSynchronizer.getPushStateSynchronizer().persist();
        boolean emailPersisted = OneSignalStateSynchronizer.getEmailStateSynchronizer().persist();
        boolean smsPersisted = OneSignalStateSynchronizer.getSMSStateSynchronizer().persist();
        if (emailPersisted) {
            boolean bl = emailPersisted = OneSignalStateSynchronizer.getEmailStateSynchronizer().getRegistrationId() != null;
        }
        if (smsPersisted) {
            smsPersisted = OneSignalStateSynchronizer.getSMSStateSynchronizer().getRegistrationId() != null;
        }
        return pushPersisted || emailPersisted || smsPersisted;
    }

    static void clearLocation() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().clearLocation();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().clearLocation();
        OneSignalStateSynchronizer.getSMSStateSynchronizer().clearLocation();
    }

    static void initUserState() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().initUserState();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().initUserState();
        OneSignalStateSynchronizer.getSMSStateSynchronizer().initUserState();
    }

    static void syncUserState(boolean fromSyncService) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().syncUserState(fromSyncService);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().syncUserState(fromSyncService);
        OneSignalStateSynchronizer.getSMSStateSynchronizer().syncUserState(fromSyncService);
    }

    static void sendTags(JSONObject newTags, @Nullable OneSignal.ChangeTagsUpdateHandler handler) {
        try {
            JSONObject jsonField = new JSONObject().put("tags", (Object)newTags);
            OneSignalStateSynchronizer.getPushStateSynchronizer().sendTags(jsonField, handler);
            OneSignalStateSynchronizer.getEmailStateSynchronizer().sendTags(jsonField, handler);
            OneSignalStateSynchronizer.getSMSStateSynchronizer().sendTags(jsonField, handler);
        }
        catch (JSONException e) {
            if (handler != null) {
                handler.onFailure(new OneSignal.SendTagsError(-1, "Encountered an error attempting to serialize your tags into JSON: " + e.getMessage() + "\n" + e.getStackTrace()));
            }
            e.printStackTrace();
        }
    }

    static void setSMSNumber(String smsNumber, String smsAuthHash) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setSMSNumber(smsNumber, smsAuthHash);
        OneSignalStateSynchronizer.getSMSStateSynchronizer().setChannelId(smsNumber, smsAuthHash);
    }

    static void setEmail(String email, String emailAuthHash) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setEmail(email, emailAuthHash);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().setChannelId(email, emailAuthHash);
    }

    static void setSubscription(boolean enable) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setSubscription(enable);
    }

    static boolean getUserSubscribePreference() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getUserSubscribePreference();
    }

    static String getLanguage() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getLanguage();
    }

    static void setPermission(boolean enable) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setPermission(enable);
    }

    static void updateLocation(LocationController.LocationPoint point) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().updateLocation(point);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().updateLocation(point);
        OneSignalStateSynchronizer.getSMSStateSynchronizer().updateLocation(point);
    }

    static boolean getSubscribed() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getSubscribed();
    }

    static String getRegistrationId() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getRegistrationId();
    }

    static UserStateSynchronizer.GetTagsResult getTags(boolean fromServer) {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getTags(fromServer);
    }

    static void resetCurrentState() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().resetCurrentState();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().resetCurrentState();
        OneSignalStateSynchronizer.getSMSStateSynchronizer().resetCurrentState();
        OneSignalStateSynchronizer.getPushStateSynchronizer().saveChannelId(null);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().saveChannelId(null);
        OneSignalStateSynchronizer.getSMSStateSynchronizer().saveChannelId(null);
        OneSignal.setLastSessionTime(-3660L);
    }

    static void updateDeviceInfo(JSONObject deviceInfo, OSDeviceInfoCompletionHandler handler) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().updateDeviceInfo(deviceInfo, handler);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().updateDeviceInfo(deviceInfo, handler);
        OneSignalStateSynchronizer.getSMSStateSynchronizer().updateDeviceInfo(deviceInfo, handler);
    }

    static void updatePushState(JSONObject pushState) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().updateState(pushState);
    }

    static void refreshSecondaryChannelState() {
        OneSignalStateSynchronizer.getEmailStateSynchronizer().refresh();
        OneSignalStateSynchronizer.getSMSStateSynchronizer().refresh();
    }

    static void setNewSession() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setNewSession();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().setNewSession();
        OneSignalStateSynchronizer.getSMSStateSynchronizer().setNewSession();
    }

    static boolean getSyncAsNewSession() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getSyncAsNewSession() || OneSignalStateSynchronizer.getEmailStateSynchronizer().getSyncAsNewSession() || OneSignalStateSynchronizer.getSMSStateSynchronizer().getSyncAsNewSession();
    }

    static void setNewSessionForEmail() {
        OneSignalStateSynchronizer.getEmailStateSynchronizer().setNewSession();
    }

    static void logoutEmail() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().logoutEmail();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().logoutChannel();
    }

    static void logoutSMS() {
        OneSignalStateSynchronizer.getSMSStateSynchronizer().logoutChannel();
        OneSignalStateSynchronizer.getPushStateSynchronizer().logoutSMS();
    }

    static void setExternalUserId(String externalId, String externalIdAuthHash, final OneSignal.OSExternalUserIdUpdateCompletionHandler completionHandler) throws JSONException {
        final JSONObject responses = new JSONObject();
        OneSignal.OSInternalExternalUserIdUpdateCompletionHandler handler = new OneSignal.OSInternalExternalUserIdUpdateCompletionHandler(){

            @Override
            public void onComplete(String channel, boolean success) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.VERBOSE, "Completed request to update external user id for channel: " + channel + " and success: " + success);
                try {
                    responses.put(channel, (Object)new JSONObject().put("success", success));
                }
                catch (JSONException e) {
                    OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Error while adding the success status of external id for channel: " + channel);
                    e.printStackTrace();
                }
                for (UserStateSynchronizer userStateSynchronizer : userStateSynchronizers.values()) {
                    if (!userStateSynchronizer.hasQueuedHandlers()) continue;
                    OneSignal.onesignalLog(OneSignal.LOG_LEVEL.VERBOSE, "External user id handlers are still being processed for channel: " + userStateSynchronizer.getChannelString() + " , wait until finished before proceeding");
                    return;
                }
                CallbackThreadManager.Companion.runOnPreferred(new Runnable(){

                    @Override
                    public void run() {
                        if (completionHandler != null) {
                            completionHandler.onSuccess(responses);
                        }
                    }
                });
            }
        };
        List<UserStateSynchronizer> userStateSynchronizers = OneSignalStateSynchronizer.getUserStateSynchronizers();
        for (UserStateSynchronizer userStateSynchronizer : userStateSynchronizers) {
            userStateSynchronizer.setExternalUserId(externalId, externalIdAuthHash, handler);
        }
    }

    static void sendPurchases(JSONObject jsonBody, OneSignalRestClient.ResponseHandler responseHandler) {
        List<UserStateSynchronizer> userStateSynchronizers = OneSignalStateSynchronizer.getUserStateSynchronizers();
        for (UserStateSynchronizer userStateSynchronizer : userStateSynchronizers) {
            userStateSynchronizer.sendPurchases(jsonBody, responseHandler);
        }
    }

    static void readyToUpdate(boolean canMakeUpdates) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().readyToUpdate(canMakeUpdates);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().readyToUpdate(canMakeUpdates);
        OneSignalStateSynchronizer.getSMSStateSynchronizer().readyToUpdate(canMakeUpdates);
    }

    static enum UserStateSynchronizerType {
        PUSH,
        EMAIL,
        SMS;


        public boolean isPush() {
            return this.equals((Object)PUSH);
        }

        public boolean isEmail() {
            return this.equals((Object)EMAIL);
        }

        public boolean isSMS() {
            return this.equals((Object)SMS);
        }
    }

    static interface OSDeviceInfoCompletionHandler {
        public void onSuccess(String var1);

        public void onFailure(OSDeviceInfoError var1);
    }

    static class OSDeviceInfoError {
        public int errorCode;
        public String message;

        OSDeviceInfoError(int errorCode, String message) {
            this.errorCode = errorCode;
            this.message = message;
        }

        public int getCode() {
            return this.errorCode;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

