/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.onesignal.OSNotificationGenerationJob;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalNotificationManager;
import com.onesignal.language.LanguageContext;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class NotificationChannelManager {
    private static final String DEFAULT_CHANNEL_ID = "fcm_fallback_notification_channel";
    private static final String RESTORE_CHANNEL_ID = "restored_OS_notifications";
    private static final String CHANNEL_PREFIX = "OS_";
    private static final Pattern hexPattern = Pattern.compile("^([A-Fa-f0-9]{8})$");

    NotificationChannelManager() {
    }

    static String createNotificationChannel(OSNotificationGenerationJob notificationJob) {
        String otherChannel;
        if (Build.VERSION.SDK_INT < 26) {
            return DEFAULT_CHANNEL_ID;
        }
        Context context = notificationJob.getContext();
        JSONObject jsonPayload = notificationJob.getJsonPayload();
        NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(context);
        if (notificationJob.isRestoring()) {
            return NotificationChannelManager.createRestoreChannel(notificationManager);
        }
        if (jsonPayload.has("oth_chnl") && notificationManager.getNotificationChannel(otherChannel = jsonPayload.optString("oth_chnl")) != null) {
            return otherChannel;
        }
        if (!jsonPayload.has("chnl")) {
            return NotificationChannelManager.createDefaultChannel(notificationManager);
        }
        try {
            return NotificationChannelManager.createChannel(context, notificationManager, jsonPayload);
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Could not create notification channel due to JSON payload error!", e);
            return DEFAULT_CHANNEL_ID;
        }
    }

    @RequiresApi(api=26)
    private static String createChannel(Context context, NotificationManager notificationManager, JSONObject payload) throws JSONException {
        long[] vibrationPattern;
        String language;
        JSONObject langList;
        Object objChannelPayload = payload.opt("chnl");
        JSONObject channelPayload = null;
        channelPayload = objChannelPayload instanceof String ? new JSONObject((String)objChannelPayload) : (JSONObject)objChannelPayload;
        String channel_id = channelPayload.optString("id", DEFAULT_CHANNEL_ID);
        if (channel_id.equals("miscellaneous")) {
            channel_id = DEFAULT_CHANNEL_ID;
        }
        JSONObject payloadWithText = channelPayload;
        if (channelPayload.has("langs") && (langList = channelPayload.getJSONObject("langs")).has(language = LanguageContext.getInstance().getLanguage())) {
            payloadWithText = langList.optJSONObject(language);
        }
        String channel_name = payloadWithText.optString("nm", "Miscellaneous");
        int importance = NotificationChannelManager.priorityToImportance(payload.optInt("pri", 6));
        NotificationChannel channel = new NotificationChannel(channel_id, (CharSequence)channel_name, importance);
        channel.setDescription(payloadWithText.optString("dscr", null));
        if (channelPayload.has("grp_id")) {
            String group_id = channelPayload.optString("grp_id");
            String group_name = payloadWithText.optString("grp_nm");
            notificationManager.createNotificationChannelGroup(new NotificationChannelGroup(group_id, (CharSequence)group_name));
            channel.setGroup(group_id);
        }
        if (payload.has("ledc")) {
            String ledc = payload.optString("ledc");
            Matcher matcher = hexPattern.matcher(ledc);
            if (!matcher.matches()) {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "OneSignal LED Color Settings: ARGB Hex value incorrect format (E.g: FF9900FF)");
                ledc = "FFFFFFFF";
            }
            try {
                BigInteger ledColor = new BigInteger(ledc, 16);
                channel.setLightColor(ledColor.intValue());
            }
            catch (Throwable t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Couldn't convert ARGB Hex value to BigInteger:", t);
            }
        }
        channel.enableLights(payload.optInt("led", 1) == 1);
        if (payload.has("vib_pt") && (vibrationPattern = OSUtils.parseVibrationPattern(payload)) != null) {
            channel.setVibrationPattern(vibrationPattern);
        }
        channel.enableVibration(payload.optInt("vib", 1) == 1);
        if (payload.has("sound")) {
            String sound = payload.optString("sound", null);
            Uri uri = OSUtils.getSoundUri(context, sound);
            if (uri != null) {
                channel.setSound(uri, null);
            } else if ("null".equals(sound) || "nil".equals(sound)) {
                channel.setSound(null, null);
            }
        }
        channel.setLockscreenVisibility(payload.optInt("vis", 0));
        channel.setShowBadge(payload.optInt("bdg", 1) == 1);
        channel.setBypassDnd(payload.optInt("bdnd", 0) == 1);
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.VERBOSE, "Creating notification channel with channel:\n" + channel.toString());
        try {
            notificationManager.createNotificationChannel(channel);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return channel_id;
    }

    @RequiresApi(api=26)
    private static String createDefaultChannel(NotificationManager notificationManager) {
        NotificationChannel channel = new NotificationChannel(DEFAULT_CHANNEL_ID, (CharSequence)"Miscellaneous", 3);
        channel.enableLights(true);
        channel.enableVibration(true);
        notificationManager.createNotificationChannel(channel);
        return DEFAULT_CHANNEL_ID;
    }

    @RequiresApi(api=26)
    private static String createRestoreChannel(NotificationManager notificationManager) {
        NotificationChannel channel = new NotificationChannel(RESTORE_CHANNEL_ID, (CharSequence)"Restored", 2);
        notificationManager.createNotificationChannel(channel);
        return RESTORE_CHANNEL_ID;
    }

    static void processChannelList(@NonNull Context context, @Nullable JSONArray list) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        if (list == null || list.length() == 0) {
            return;
        }
        NotificationManager notificationManager = OneSignalNotificationManager.getNotificationManager(context);
        HashSet<String> syncedChannelSet = new HashSet<String>();
        int jsonArraySize = list.length();
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                syncedChannelSet.add(NotificationChannelManager.createChannel(context, notificationManager, list.getJSONObject(i)));
                continue;
            }
            catch (JSONException e) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Could not create notification channel due to JSON payload error!", e);
            }
        }
        if (syncedChannelSet.isEmpty()) {
            return;
        }
        List existingChannels = new ArrayList();
        try {
            existingChannels = notificationManager.getNotificationChannels();
        }
        catch (NullPointerException e) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Error when trying to delete notification channel: " + e.getMessage());
        }
        for (NotificationChannel existingChannel : existingChannels) {
            String id2 = existingChannel.getId();
            if (!id2.startsWith(CHANNEL_PREFIX) || syncedChannelSet.contains(id2)) continue;
            notificationManager.deleteNotificationChannel(id2);
        }
    }

    private static int priorityToImportance(int priority) {
        if (priority > 9) {
            return 5;
        }
        if (priority > 7) {
            return 4;
        }
        if (priority > 5) {
            return 3;
        }
        if (priority > 3) {
            return 2;
        }
        if (priority > 1) {
            return 1;
        }
        return 0;
    }
}

