/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import com.amazon.device.iap.PurchasingListener;
import com.amazon.device.iap.PurchasingService;
import com.amazon.device.iap.model.Product;
import com.amazon.device.iap.model.ProductDataResponse;
import com.amazon.device.iap.model.PurchaseResponse;
import com.amazon.device.iap.model.PurchaseUpdatesResponse;
import com.amazon.device.iap.model.RequestId;
import com.amazon.device.iap.model.UserDataResponse;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class TrackAmazonPurchase {
    private Context context;
    private boolean canTrack = false;
    private OSPurchasingListener osPurchasingListener;
    private boolean registerListenerOnMainThread = false;
    private Object listenerHandlerObject;
    private Field listenerHandlerField;

    TrackAmazonPurchase(Context context) {
        this.context = context;
        try {
            Class<?> listenerHandlerClass = Class.forName("com.amazon.device.iap.internal.d");
            try {
                this.listenerHandlerObject = listenerHandlerClass.getMethod("d", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NullPointerException e) {
                this.listenerHandlerObject = listenerHandlerClass.getMethod("e", new Class[0]).invoke(null, new Object[0]);
                this.registerListenerOnMainThread = true;
            }
            this.listenerHandlerField = listenerHandlerClass.getDeclaredField("f");
            this.listenerHandlerField.setAccessible(true);
            this.osPurchasingListener = new OSPurchasingListener();
            this.osPurchasingListener.orgPurchasingListener = (PurchasingListener)this.listenerHandlerField.get(this.listenerHandlerObject);
            this.canTrack = true;
            this.setListener();
        }
        catch (ClassNotFoundException e) {
            TrackAmazonPurchase.logAmazonIAPListenerError(e);
        }
        catch (IllegalAccessException e) {
            TrackAmazonPurchase.logAmazonIAPListenerError(e);
        }
        catch (InvocationTargetException e) {
            TrackAmazonPurchase.logAmazonIAPListenerError(e);
        }
        catch (NoSuchMethodException e) {
            TrackAmazonPurchase.logAmazonIAPListenerError(e);
        }
        catch (NoSuchFieldException e) {
            TrackAmazonPurchase.logAmazonIAPListenerError(e);
        }
        catch (ClassCastException e) {
            TrackAmazonPurchase.logAmazonIAPListenerError(e);
        }
    }

    private static void logAmazonIAPListenerError(Exception e) {
        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error adding Amazon IAP listener.", e);
        e.printStackTrace();
    }

    private void setListener() {
        if (this.registerListenerOnMainThread) {
            OSUtils.runOnMainUIThread(new Runnable(){

                @Override
                public void run() {
                    PurchasingService.registerListener((Context)TrackAmazonPurchase.this.context, (PurchasingListener)TrackAmazonPurchase.this.osPurchasingListener);
                }
            });
        } else {
            PurchasingService.registerListener((Context)this.context, (PurchasingListener)this.osPurchasingListener);
        }
    }

    void checkListener() {
        if (!this.canTrack) {
            return;
        }
        try {
            PurchasingListener curPurchasingListener = (PurchasingListener)this.listenerHandlerField.get(this.listenerHandlerObject);
            if (curPurchasingListener != this.osPurchasingListener) {
                this.osPurchasingListener.orgPurchasingListener = curPurchasingListener;
                this.setListener();
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private class OSPurchasingListener
    implements PurchasingListener {
        PurchasingListener orgPurchasingListener;
        private RequestId lastRequestId;
        private String currentMarket;

        private OSPurchasingListener() {
        }

        private String marketToCurrencyCode(String market) {
            switch (market) {
                case "US": {
                    return "USD";
                }
                case "GB": {
                    return "GBP";
                }
                case "DE": 
                case "FR": 
                case "ES": 
                case "IT": {
                    return "EUR";
                }
                case "JP": {
                    return "JPY";
                }
                case "CA": {
                    return "CDN";
                }
                case "BR": {
                    return "BRL";
                }
                case "AU": {
                    return "AUD";
                }
            }
            return "";
        }

        public void onProductDataResponse(ProductDataResponse response) {
            if (this.lastRequestId != null && this.lastRequestId.toString().equals(response.getRequestId().toString())) {
                try {
                    switch (response.getRequestStatus()) {
                        case SUCCESSFUL: {
                            JSONArray purchasesToReport = new JSONArray();
                            Map products = response.getProductData();
                            for (String key : products.keySet()) {
                                Product product = (Product)products.get(key);
                                JSONObject jsonItem = new JSONObject();
                                jsonItem.put("sku", (Object)product.getSku());
                                jsonItem.put("iso", (Object)this.marketToCurrencyCode(this.currentMarket));
                                String price = product.getPrice();
                                if (!price.matches("^[0-9]")) {
                                    price = price.substring(1);
                                }
                                jsonItem.put("amount", (Object)price);
                                purchasesToReport.put((Object)jsonItem);
                            }
                            OneSignal.sendPurchases(purchasesToReport, false, null);
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onProductDataResponse(response);
            }
        }

        public void onPurchaseResponse(PurchaseResponse response) {
            PurchaseResponse.RequestStatus status = response.getRequestStatus();
            if (status == PurchaseResponse.RequestStatus.SUCCESSFUL) {
                this.currentMarket = response.getUserData().getMarketplace();
                HashSet<String> productSkus = new HashSet<String>();
                productSkus.add(response.getReceipt().getSku());
                this.lastRequestId = PurchasingService.getProductData(productSkus);
            }
            if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onPurchaseResponse(response);
            }
        }

        public void onPurchaseUpdatesResponse(PurchaseUpdatesResponse response) {
            if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onPurchaseUpdatesResponse(response);
            }
        }

        public void onUserDataResponse(UserDataResponse response) {
            if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onUserDataResponse(response);
            }
        }
    }
}

