/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.database.Cursor;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.StatusBarNotification;
import androidx.annotation.RequiresApi;
import com.onesignal.ApplicationInfoHelper;
import com.onesignal.NotificationLimitManager;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDb;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalNotificationManager;
import com.onesignal.shortcutbadger.ShortcutBadgeException;
import com.onesignal.shortcutbadger.ShortcutBadger;

class BadgeCountUpdater {
    private static int badgesEnabled = -1;

    BadgeCountUpdater() {
    }

    private static boolean areBadgeSettingsEnabled(Context context) {
        String defaultStr;
        if (badgesEnabled != -1) {
            return badgesEnabled == 1;
        }
        ApplicationInfo ai = ApplicationInfoHelper.Companion.getInfo(context);
        if (ai == null) {
            badgesEnabled = 0;
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error reading meta-data tag 'com.onesignal.BadgeCount'. Disabling badge setting.");
            return false;
        }
        Bundle bundle = ai.metaData;
        badgesEnabled = bundle != null ? ("DISABLE".equals(defaultStr = bundle.getString("com.onesignal.BadgeCount")) ? 0 : 1) : 1;
        return badgesEnabled == 1;
    }

    private static boolean areBadgesEnabled(Context context) {
        return BadgeCountUpdater.areBadgeSettingsEnabled(context) && OSUtils.areNotificationsEnabled(context);
    }

    static void update(OneSignalDb db, Context context) {
        if (!BadgeCountUpdater.areBadgesEnabled(context)) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            BadgeCountUpdater.updateStandard(context);
        } else {
            BadgeCountUpdater.updateFallback(db, context);
        }
    }

    @RequiresApi(api=23)
    private static void updateStandard(Context context) {
        StatusBarNotification[] activeNotifs = OneSignalNotificationManager.getActiveNotifications(context);
        int runningCount = 0;
        for (StatusBarNotification activeNotif : activeNotifs) {
            if (NotificationLimitManager.isGroupSummary(activeNotif)) continue;
            ++runningCount;
        }
        BadgeCountUpdater.updateCount(runningCount, context);
    }

    private static void updateFallback(OneSignalDb db, Context context) {
        Cursor cursor = db.query("notification", null, OneSignalDbHelper.recentUninteractedWithNotificationsWhere().toString(), null, null, null, null, NotificationLimitManager.MAX_NUMBER_OF_NOTIFICATIONS_STR);
        int notificationCount = cursor.getCount();
        cursor.close();
        BadgeCountUpdater.updateCount(notificationCount, context);
    }

    static void updateCount(int count, Context context) {
        if (!BadgeCountUpdater.areBadgeSettingsEnabled(context)) {
            return;
        }
        try {
            ShortcutBadger.applyCountOrThrow(context, count);
        }
        catch (ShortcutBadgeException shortcutBadgeException) {
            // empty catch block
        }
    }
}

