/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence.data;

import com.onesignal.OSLogger;
import com.onesignal.OSTime;
import com.onesignal.influence.data.OSChannelTracker;
import com.onesignal.influence.data.OSInfluenceDataRepository;
import com.onesignal.influence.domain.OSInfluence;
import com.onesignal.influence.domain.OSInfluenceChannel;
import com.onesignal.influence.domain.OSInfluenceType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\u0012\u0010\"\u001a\u00020\u00182\b\u0010#\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010$\u001a\u00020\u001cH\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0018H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/onesignal/influence/data/OSInAppMessageTracker;", "Lcom/onesignal/influence/data/OSChannelTracker;", "dataRepository", "Lcom/onesignal/influence/data/OSInfluenceDataRepository;", "logger", "Lcom/onesignal/OSLogger;", "timeProvider", "Lcom/onesignal/OSTime;", "(Lcom/onesignal/influence/data/OSInfluenceDataRepository;Lcom/onesignal/OSLogger;Lcom/onesignal/OSTime;)V", "channelLimit", "", "getChannelLimit", "()I", "channelType", "Lcom/onesignal/influence/domain/OSInfluenceChannel;", "getChannelType", "()Lcom/onesignal/influence/domain/OSInfluenceChannel;", "idTag", "", "getIdTag", "()Ljava/lang/String;", "indirectAttributionWindow", "getIndirectAttributionWindow", "lastChannelObjects", "Lorg/json/JSONArray;", "getLastChannelObjects", "()Lorg/json/JSONArray;", "addSessionData", "", "jsonObject", "Lorg/json/JSONObject;", "influence", "Lcom/onesignal/influence/domain/OSInfluence;", "cacheState", "getLastChannelObjectsReceivedByNewId", "id", "initInfluencedTypeFromCache", "saveChannelObjects", "channelObjects", "onesignal_release"})
public final class OSInAppMessageTracker
extends OSChannelTracker {
    public OSInAppMessageTracker(@NotNull OSInfluenceDataRepository dataRepository, @NotNull OSLogger logger, @NotNull OSTime timeProvider) {
        Intrinsics.checkNotNullParameter((Object)dataRepository, (String)"dataRepository");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        super(dataRepository, logger, timeProvider);
    }

    @Override
    @NotNull
    public String getIdTag() {
        return "iam_id";
    }

    @Override
    @NotNull
    public OSInfluenceChannel getChannelType() {
        return OSInfluenceChannel.IAM;
    }

    @Override
    @NotNull
    public JSONArray getLastChannelObjectsReceivedByNewId(@Nullable String id2) {
        JSONArray jSONArray;
        JSONArray lastChannelObjectReceived = null;
        try {
            jSONArray = this.getLastChannelObjects();
        }
        catch (JSONException exception) {
            this.getLogger().error("Generating IAM tracker getLastChannelObjects JSONObject ", exception);
            return new JSONArray();
        }
        lastChannelObjectReceived = jSONArray;
        try {
            JSONArray auxLastChannelObjectReceived = new JSONArray();
            int n = 0;
            int n2 = lastChannelObjectReceived.length();
            if (n < n2) {
                do {
                    int i;
                    String objectId;
                    if (Intrinsics.areEqual((Object)id2, (Object)(objectId = lastChannelObjectReceived.getJSONObject(i = n++).getString(this.getIdTag())))) continue;
                    auxLastChannelObjectReceived.put((Object)lastChannelObjectReceived.getJSONObject(i));
                } while (n < n2);
            }
            lastChannelObjectReceived = auxLastChannelObjectReceived;
        }
        catch (JSONException exception) {
            this.getLogger().error("Generating tracker lastChannelObjectReceived get JSONObject ", exception);
        }
        return lastChannelObjectReceived;
    }

    @Override
    @NotNull
    public JSONArray getLastChannelObjects() throws JSONException {
        return this.getDataRepository().getLastIAMsReceivedData();
    }

    @Override
    public int getChannelLimit() {
        return this.getDataRepository().getIamLimit();
    }

    @Override
    public int getIndirectAttributionWindow() {
        return this.getDataRepository().getIamIndirectAttributionWindow();
    }

    @Override
    public void saveChannelObjects(@NotNull JSONArray channelObjects) {
        Intrinsics.checkNotNullParameter((Object)channelObjects, (String)"channelObjects");
        this.getDataRepository().saveIAMs(channelObjects);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initInfluencedTypeFromCache() {
        void it;
        OSInfluenceType oSInfluenceType = this.getDataRepository().getIamCachedInfluenceType();
        boolean bl = false;
        boolean bl2 = false;
        OSInfluenceType oSInfluenceType2 = oSInfluenceType;
        OSInAppMessageTracker oSInAppMessageTracker = this;
        boolean bl3 = false;
        if (it.isIndirect()) {
            this.setIndirectIds(this.getLastReceivedIds());
        }
        Unit unit = Unit.INSTANCE;
        oSInAppMessageTracker.setInfluenceType(oSInfluenceType);
        this.getLogger().debug(Intrinsics.stringPlus((String)"OneSignal InAppMessageTracker initInfluencedTypeFromCache: ", (Object)this));
    }

    @Override
    public void addSessionData(@NotNull JSONObject jsonObject, @NotNull OSInfluence influence) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter((Object)influence, (String)"influence");
    }

    @Override
    public void cacheState() {
        OSInfluenceType oSInfluenceType = this.getInfluenceType();
        OSInfluenceType influenceTypeToCache = oSInfluenceType == null ? OSInfluenceType.UNATTRIBUTED : oSInfluenceType;
        this.getDataRepository().cacheIAMInfluenceType(influenceTypeToCache == OSInfluenceType.DIRECT ? OSInfluenceType.INDIRECT : influenceTypeToCache);
    }
}

