/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common.modeling;

import com.onesignal.common.events.EventProducer;
import com.onesignal.common.modeling.IModelStore;
import com.onesignal.common.modeling.IModelStoreChangeHandler;
import com.onesignal.common.modeling.ISingletonModelStore;
import com.onesignal.common.modeling.ISingletonModelStoreChangeHandler;
import com.onesignal.common.modeling.Model;
import com.onesignal.common.modeling.ModelChangedArgs;
import com.onesignal.common.modeling.ModelStore;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00132\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u001d\u0010\u001a\u001a\u00020\u00132\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u001b\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u0016\u0010\u001d\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/onesignal/common/modeling/SingletonModelStore;", "TModel", "Lcom/onesignal/common/modeling/Model;", "Lcom/onesignal/common/modeling/ISingletonModelStore;", "Lcom/onesignal/common/modeling/IModelStoreChangeHandler;", "store", "Lcom/onesignal/common/modeling/ModelStore;", "(Lcom/onesignal/common/modeling/ModelStore;)V", "_changeSubscription", "Lcom/onesignal/common/events/EventProducer;", "Lcom/onesignal/common/modeling/ISingletonModelStoreChangeHandler;", "_singletonId", "", "model", "getModel", "()Lcom/onesignal/common/modeling/Model;", "getStore", "()Lcom/onesignal/common/modeling/ModelStore;", "onModelAdded", "", "tag", "(Lcom/onesignal/common/modeling/Model;Ljava/lang/String;)V", "onModelRemoved", "onModelUpdated", "args", "Lcom/onesignal/common/modeling/ModelChangedArgs;", "replace", "subscribe", "handler", "unsubscribe", "core_release"})
public class SingletonModelStore<TModel extends Model>
implements ISingletonModelStore<TModel>,
IModelStoreChangeHandler<TModel> {
    @NotNull
    private final ModelStore<TModel> store;
    @NotNull
    private final EventProducer<ISingletonModelStoreChangeHandler<TModel>> _changeSubscription;
    @NotNull
    private final String _singletonId;

    public SingletonModelStore(@NotNull ModelStore<TModel> store) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        this.store = store;
        this._changeSubscription = new EventProducer();
        this._singletonId = "-singleton-";
        this.store.subscribe(this);
    }

    @NotNull
    public final ModelStore<TModel> getStore() {
        return this.store;
    }

    @Override
    @NotNull
    public TModel getModel() {
        TModel model = this.store.get(this._singletonId);
        if (model != null) {
            return model;
        }
        Model createdModel = IModelStore.DefaultImpls.create$default(this.store, null, 1, null);
        createdModel.setId(this._singletonId);
        IModelStore.DefaultImpls.add$default(this.store, createdModel, null, 2, null);
        return (TModel)createdModel;
    }

    @Override
    public void replace(@NotNull TModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        TModel existingModel = this.getModel();
        ((Model)existingModel).initializeFromModel(this._singletonId, (Model)model);
        this.store.persist();
        this._changeSubscription.fire((Function1)new Function1<ISingletonModelStoreChangeHandler<TModel>, Unit>(existingModel, tag){
            final /* synthetic */ TModel $existingModel;
            final /* synthetic */ String $tag;
            {
                this.$existingModel = $existingModel;
                this.$tag = $tag;
                super(1);
            }

            public final void invoke(@NotNull ISingletonModelStoreChangeHandler<TModel> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.onModelReplaced(this.$existingModel, this.$tag);
            }
        });
    }

    @Override
    public void subscribe(@NotNull ISingletonModelStoreChangeHandler<TModel> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this._changeSubscription.subscribe(handler);
    }

    @Override
    public void unsubscribe(@NotNull ISingletonModelStoreChangeHandler<TModel> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this._changeSubscription.unsubscribe(handler);
    }

    @Override
    public void onModelAdded(@NotNull TModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }

    @Override
    public void onModelUpdated(@NotNull ModelChangedArgs args, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this._changeSubscription.fire((Function1)new Function1<ISingletonModelStoreChangeHandler<TModel>, Unit>(args, tag){
            final /* synthetic */ ModelChangedArgs $args;
            final /* synthetic */ String $tag;
            {
                this.$args = $args;
                this.$tag = $tag;
                super(1);
            }

            public final void invoke(@NotNull ISingletonModelStoreChangeHandler<TModel> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.onModelUpdated(this.$args, this.$tag);
            }
        });
    }

    @Override
    public void onModelRemoved(@NotNull TModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }
}

