/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.user.internal;

import com.onesignal.common.IDManager;
import com.onesignal.common.events.EventProducer;
import com.onesignal.user.internal.subscriptions.SubscriptionModel;
import com.onesignal.user.subscriptions.ISubscription;
import com.onesignal.user.subscriptions.ISubscriptionChangedHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/onesignal/user/internal/Subscription;", "Lcom/onesignal/user/subscriptions/ISubscription;", "model", "Lcom/onesignal/user/internal/subscriptions/SubscriptionModel;", "(Lcom/onesignal/user/internal/subscriptions/SubscriptionModel;)V", "changeHandlersNotifier", "Lcom/onesignal/common/events/EventProducer;", "Lcom/onesignal/user/subscriptions/ISubscriptionChangedHandler;", "getChangeHandlersNotifier", "()Lcom/onesignal/common/events/EventProducer;", "id", "", "getId", "()Ljava/lang/String;", "getModel", "()Lcom/onesignal/user/internal/subscriptions/SubscriptionModel;", "addChangeHandler", "", "handler", "removeChangeHandler", "core_release"})
public abstract class Subscription
implements ISubscription {
    @NotNull
    private final SubscriptionModel model;
    @NotNull
    private final EventProducer<ISubscriptionChangedHandler> changeHandlersNotifier;

    public Subscription(@NotNull SubscriptionModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
        this.changeHandlersNotifier = new EventProducer();
    }

    @NotNull
    public final SubscriptionModel getModel() {
        return this.model;
    }

    @NotNull
    public final EventProducer<ISubscriptionChangedHandler> getChangeHandlersNotifier() {
        return this.changeHandlersNotifier;
    }

    @Override
    @NotNull
    public String getId() {
        return IDManager.INSTANCE.isLocalId(this.model.getId()) ? "" : this.model.getId();
    }

    @Override
    public void addChangeHandler(@NotNull ISubscriptionChangedHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.changeHandlersNotifier.subscribe(handler);
    }

    @Override
    public void removeChangeHandler(@NotNull ISubscriptionChangedHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.changeHandlersNotifier.unsubscribe(handler);
    }
}

