/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.user.internal.operations.impl.listeners;

import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.operations.IOperationRepo;
import com.onesignal.core.internal.operations.Operation;
import com.onesignal.core.internal.operations.listeners.ModelStoreListener;
import com.onesignal.user.internal.identity.IdentityModel;
import com.onesignal.user.internal.identity.IdentityModelStore;
import com.onesignal.user.internal.operations.CreateSubscriptionOperation;
import com.onesignal.user.internal.operations.DeleteSubscriptionOperation;
import com.onesignal.user.internal.operations.UpdateSubscriptionOperation;
import com.onesignal.user.internal.subscriptions.SubscriptionModel;
import com.onesignal.user.internal.subscriptions.SubscriptionModelStore;
import com.onesignal.user.internal.subscriptions.SubscriptionStatus;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J4\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/onesignal/user/internal/operations/impl/listeners/SubscriptionModelStoreListener;", "Lcom/onesignal/core/internal/operations/listeners/ModelStoreListener;", "Lcom/onesignal/user/internal/subscriptions/SubscriptionModel;", "store", "Lcom/onesignal/user/internal/subscriptions/SubscriptionModelStore;", "opRepo", "Lcom/onesignal/core/internal/operations/IOperationRepo;", "_identityModelStore", "Lcom/onesignal/user/internal/identity/IdentityModelStore;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "(Lcom/onesignal/user/internal/subscriptions/SubscriptionModelStore;Lcom/onesignal/core/internal/operations/IOperationRepo;Lcom/onesignal/user/internal/identity/IdentityModelStore;Lcom/onesignal/core/internal/config/ConfigModelStore;)V", "getAddOperation", "Lcom/onesignal/core/internal/operations/Operation;", "model", "getRemoveOperation", "getUpdateOperation", "path", "", "property", "oldValue", "", "newValue", "Companion", "core_release"})
public final class SubscriptionModelStoreListener
extends ModelStoreListener<SubscriptionModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdentityModelStore _identityModelStore;
    @NotNull
    private final ConfigModelStore _configModelStore;

    public SubscriptionModelStoreListener(@NotNull SubscriptionModelStore store, @NotNull IOperationRepo opRepo, @NotNull IdentityModelStore _identityModelStore, @NotNull ConfigModelStore _configModelStore) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)opRepo, (String)"opRepo");
        Intrinsics.checkNotNullParameter((Object)_identityModelStore, (String)"_identityModelStore");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        super(store, opRepo);
        this._identityModelStore = _identityModelStore;
        this._configModelStore = _configModelStore;
    }

    @Override
    @NotNull
    public Operation getAddOperation(@NotNull SubscriptionModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Pair<Boolean, SubscriptionStatus> enabledAndStatus = Companion.getSubscriptionEnabledAndStatus(model);
        return new CreateSubscriptionOperation(((ConfigModel)this._configModelStore.getModel()).getAppId(), ((IdentityModel)this._identityModelStore.getModel()).getOnesignalId(), model.getId(), model.getType(), (Boolean)enabledAndStatus.getFirst(), model.getAddress(), (SubscriptionStatus)((Object)enabledAndStatus.getSecond()));
    }

    @Override
    @NotNull
    public Operation getRemoveOperation(@NotNull SubscriptionModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return new DeleteSubscriptionOperation(((ConfigModel)this._configModelStore.getModel()).getAppId(), ((IdentityModel)this._identityModelStore.getModel()).getOnesignalId(), model.getId());
    }

    @Override
    @NotNull
    public Operation getUpdateOperation(@NotNull SubscriptionModel model, @NotNull String path, @NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Pair<Boolean, SubscriptionStatus> enabledAndStatus = Companion.getSubscriptionEnabledAndStatus(model);
        return new UpdateSubscriptionOperation(((ConfigModel)this._configModelStore.getModel()).getAppId(), ((IdentityModel)this._identityModelStore.getModel()).getOnesignalId(), model.getId(), model.getType(), (Boolean)enabledAndStatus.getFirst(), model.getAddress(), (SubscriptionStatus)((Object)enabledAndStatus.getSecond()));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/onesignal/user/internal/operations/impl/listeners/SubscriptionModelStoreListener$Companion;", "", "()V", "getSubscriptionEnabledAndStatus", "Lkotlin/Pair;", "", "Lcom/onesignal/user/internal/subscriptions/SubscriptionStatus;", "model", "Lcom/onesignal/user/internal/subscriptions/SubscriptionModel;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<Boolean, SubscriptionStatus> getSubscriptionEnabledAndStatus(@NotNull SubscriptionModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            SubscriptionStatus status = null;
            boolean enabled = false;
            if (model.getOptedIn() && model.getStatus() == SubscriptionStatus.SUBSCRIBED && ((CharSequence)model.getAddress()).length() > 0) {
                enabled = true;
                status = SubscriptionStatus.SUBSCRIBED;
            } else {
                enabled = false;
                status = !model.getOptedIn() ? SubscriptionStatus.UNSUBSCRIBE : model.getStatus();
            }
            return new Pair((Object)enabled, (Object)status);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

