/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.background.impl;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.onesignal.common.AndroidSupportV4Compat;
import com.onesignal.core.internal.application.IApplicationLifecycleHandler;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.background.IBackgroundManager;
import com.onesignal.core.internal.background.IBackgroundService;
import com.onesignal.core.internal.startup.IStartableService;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.core.services.SyncJobService;
import com.onesignal.core.services.SyncService;
import com.onesignal.debug.internal.logging.Logging;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 /2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001/B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0002J\b\u0010 \u001a\u00020\u0013H\u0003J\b\u0010!\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016J\u0011\u0010#\u001a\u00020\u001cH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u001cH\u0002J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u000fH\u0003J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u000fH\u0002J\b\u0010+\u001a\u00020\u001cH\u0016J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00198\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00060"}, d2={"Lcom/onesignal/core/internal/background/impl/BackgroundManager;", "Lcom/onesignal/core/internal/application/IApplicationLifecycleHandler;", "Lcom/onesignal/core/internal/background/IBackgroundManager;", "Lcom/onesignal/core/internal/startup/IStartableService;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_time", "Lcom/onesignal/core/internal/time/ITime;", "_backgroundServices", "", "Lcom/onesignal/core/internal/background/IBackgroundService;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/time/ITime;Ljava/util/List;)V", "_lock", "", "_nextScheduledSyncTimeMs", "", "backgroundSyncJob", "Lkotlinx/coroutines/Job;", "needsJobReschedule", "", "getNeedsJobReschedule", "()Z", "setNeedsJobReschedule", "(Z)V", "syncServiceJobClass", "Ljava/lang/Class;", "syncServicePendingIntentClass", "cancelBackgroundSyncTask", "", "cancelRunBackgroundServices", "cancelSyncTask", "hasBootPermission", "isJobIdRunning", "onFocus", "onUnfocused", "runBackgroundServices", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scheduleBackground", "scheduleBackgroundSyncTask", "delayMs", "scheduleSyncServiceAsAlarm", "scheduleSyncServiceAsJob", "scheduleSyncTask", "start", "syncServicePendingIntent", "Landroid/app/PendingIntent;", "useJob", "Companion", "com.onesignal.core"})
public final class BackgroundManager
implements IApplicationLifecycleHandler,
IBackgroundManager,
IStartableService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final ITime _time;
    @NotNull
    private final List<IBackgroundService> _backgroundServices;
    private boolean needsJobReschedule;
    @NotNull
    private final Object _lock;
    private long _nextScheduledSyncTimeMs;
    @Nullable
    private Job backgroundSyncJob;
    @SuppressLint(value={"NewApi"})
    @NotNull
    private final Class<?> syncServiceJobClass;
    @NotNull
    private final Class<?> syncServicePendingIntentClass;
    private static final int SYNC_TASK_ID = 2071862118;

    public BackgroundManager(@NotNull IApplicationService _applicationService, @NotNull ITime _time, @NotNull List<? extends IBackgroundService> _backgroundServices) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_time, (String)"_time");
        Intrinsics.checkNotNullParameter(_backgroundServices, (String)"_backgroundServices");
        this._applicationService = _applicationService;
        this._time = _time;
        this._backgroundServices = _backgroundServices;
        this._lock = new Object();
        this.syncServiceJobClass = SyncJobService.class;
        this.syncServicePendingIntentClass = SyncService.class;
    }

    @Override
    public boolean getNeedsJobReschedule() {
        return this.needsJobReschedule;
    }

    @Override
    public void setNeedsJobReschedule(boolean bl) {
        this.needsJobReschedule = bl;
    }

    @Override
    public void start() {
        this._applicationService.addApplicationLifecycleHandler(this);
    }

    @Override
    public void onFocus() {
        this.cancelSyncTask();
    }

    @Override
    public void onUnfocused() {
        this.scheduleBackground();
    }

    private final void scheduleBackground() {
        Long minDelay = null;
        for (IBackgroundService backgroundService : this._backgroundServices) {
            Long scheduleIn = backgroundService.getScheduleBackgroundRunIn();
            if (scheduleIn == null || minDelay != null && scheduleIn >= minDelay) continue;
            minDelay = scheduleIn;
        }
        if (minDelay != null) {
            this.scheduleSyncTask(minDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancelSyncTask() {
        Object object = this._lock;
        synchronized (object) {
            boolean bl = false;
            this._nextScheduledSyncTimeMs = 0L;
            this.cancelBackgroundSyncTask();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @Nullable
    public Object runBackgroundServices(@NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ BackgroundManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        Logging.debug$default("OSBackground sync, calling initWithContext", null, 2, null);
                        BackgroundManager.access$setBackgroundSyncJob$p(this.this$0, BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ BackgroundManager this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        var2_3 = BackgroundManager.access$get_lock$p(this.this$0);
                                        var3_4 = this.this$0;
                                        var4_5 = var2_3;
                                        synchronized (var4_5) {
                                            $i$a$-synchronized-BackgroundManager$runBackgroundServices$2$1$1 = false;
                                            BackgroundManager.access$set_nextScheduledSyncTimeMs$p(var3_4, 0L);
                                            var5_7 = Unit.INSTANCE;
                                        }
                                        var2_3 = BackgroundManager.access$get_backgroundServices$p(this.this$0).iterator();
lbl18:
                                        // 3 sources

                                        while (var2_3.hasNext()) {
                                            backgroundService = (IBackgroundService)var2_3.next();
                                            this.L$0 = var2_3;
                                            this.label = 1;
                                            v0 = backgroundService.backgroundRun((Continuation<? super Unit>)((Continuation)this));
                                            if (v0 != var6_2) continue;
                                            return var6_2;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        var2_3 = (Iterator)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        ** GOTO lbl18
                                    }
                                }
                                BackgroundManager.access$scheduleBackground(this.this$0);
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public boolean cancelRunBackgroundServices() {
        if (this.backgroundSyncJob == null) {
            return false;
        }
        Job job2 = this.backgroundSyncJob;
        Intrinsics.checkNotNull((Object)job2);
        if (!job2.isActive()) {
            return false;
        }
        Job job3 = this.backgroundSyncJob;
        Intrinsics.checkNotNull((Object)job3);
        Job.DefaultImpls.cancel$default((Job)job3, null, (int)1, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleSyncTask(long delayMs) {
        long delayMs2 = 0L;
        delayMs2 = delayMs;
        Object object = this._lock;
        synchronized (object) {
            boolean bl = false;
            if (this._nextScheduledSyncTimeMs != 0L && this._time.getCurrentTimeMillis() + delayMs2 > this._nextScheduledSyncTimeMs) {
                Logging.debug$default("OSSyncService scheduleSyncTask already update scheduled nextScheduledSyncTimeMs: " + this._nextScheduledSyncTimeMs, null, 2, null);
                return;
            }
            if (delayMs2 < 5000L) {
                delayMs2 = 5000L;
            }
            this.scheduleBackgroundSyncTask(delayMs2);
            this._nextScheduledSyncTimeMs = this._time.getCurrentTimeMillis() + delayMs2;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleBackgroundSyncTask(long delayMs) {
        Object object = this._lock;
        synchronized (object) {
            boolean bl = false;
            if (this.useJob()) {
                this.scheduleSyncServiceAsJob(delayMs);
            } else {
                this.scheduleSyncServiceAsAlarm(delayMs);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean hasBootPermission() {
        return AndroidSupportV4Compat.ContextCompat.INSTANCE.checkSelfPermission(this._applicationService.getAppContext(), "android.permission.RECEIVE_BOOT_COMPLETED") == 0;
    }

    @RequiresApi(api=21)
    private final boolean isJobIdRunning() {
        Object object = this._applicationService.getAppContext().getSystemService("jobscheduler");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.job.JobScheduler");
        JobScheduler jobScheduler = (JobScheduler)object;
        for (JobInfo jobInfo : jobScheduler.getAllPendingJobs()) {
            if (jobInfo.getId() != 2071862118 || this.backgroundSyncJob == null) continue;
            Job job2 = this.backgroundSyncJob;
            Intrinsics.checkNotNull((Object)job2);
            if (!job2.isActive()) continue;
            return true;
        }
        return false;
    }

    @RequiresApi(value=21)
    private final void scheduleSyncServiceAsJob(long delayMs) {
        Logging.debug$default("OSBackgroundSync scheduleSyncServiceAsJob:atTime: " + delayMs, null, 2, null);
        if (this.isJobIdRunning()) {
            Logging.verbose$default("OSBackgroundSync scheduleSyncServiceAsJob Scheduler already running!", null, 2, null);
            this.setNeedsJobReschedule(true);
            return;
        }
        Context context = this._applicationService.getAppContext();
        Intrinsics.checkNotNull((Object)context);
        Class<?> clazz = this.syncServiceJobClass;
        Intrinsics.checkNotNull(clazz);
        JobInfo.Builder jobBuilder = new JobInfo.Builder(2071862118, new ComponentName(context, clazz));
        jobBuilder.setMinimumLatency(delayMs).setRequiredNetworkType(1);
        if (this.hasBootPermission()) {
            jobBuilder.setPersisted(true);
        }
        Context context2 = this._applicationService.getAppContext();
        Intrinsics.checkNotNull((Object)context2);
        Object object = context2.getSystemService("jobscheduler");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.job.JobScheduler");
        JobScheduler jobScheduler = (JobScheduler)object;
        try {
            int result = jobScheduler.schedule(jobBuilder.build());
            Logging.info$default("OSBackgroundSync scheduleSyncServiceAsJob:result: " + result, null, 2, null);
        }
        catch (NullPointerException e) {
            Logging.error("scheduleSyncServiceAsJob called JobScheduler.jobScheduler which triggered an internal null Android error. Skipping job.", e);
        }
    }

    private final void scheduleSyncServiceAsAlarm(long delayMs) {
        Logging.verbose$default(this.getClass().getSimpleName() + " scheduleServiceSyncTask:atTime: " + delayMs, null, 2, null);
        PendingIntent pendingIntent = this.syncServicePendingIntent();
        Object object = this._applicationService.getAppContext().getSystemService("alarm");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.AlarmManager");
        AlarmManager alarm = (AlarmManager)object;
        long triggerAtMs = this._time.getCurrentTimeMillis() + delayMs;
        alarm.set(0, triggerAtMs, pendingIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancelBackgroundSyncTask() {
        Logging.debug$default(this.getClass().getSimpleName() + " cancel background sync", null, 2, null);
        Object object = this._lock;
        synchronized (object) {
            boolean bl = false;
            if (this.useJob()) {
                Object object2 = this._applicationService.getAppContext().getSystemService("jobscheduler");
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.app.job.JobScheduler");
                JobScheduler jobScheduler = (JobScheduler)object2;
                jobScheduler.cancel(2071862118);
            } else {
                Object object3 = this._applicationService.getAppContext().getSystemService("alarm");
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type android.app.AlarmManager");
                AlarmManager alarmManager = (AlarmManager)object3;
                alarmManager.cancel(this.syncServicePendingIntent());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final PendingIntent syncServicePendingIntent() {
        PendingIntent pendingIntent = PendingIntent.getService((Context)this._applicationService.getAppContext(), (int)2071862118, (Intent)new Intent(this._applicationService.getAppContext(), this.syncServicePendingIntentClass), (int)0xC000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getService(\n            \u2026FLAG_IMMUTABLE,\n        )");
        return pendingIntent;
    }

    private final boolean useJob() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static final /* synthetic */ void access$setBackgroundSyncJob$p(BackgroundManager $this, Job job2) {
        $this.backgroundSyncJob = job2;
    }

    public static final /* synthetic */ Object access$get_lock$p(BackgroundManager $this) {
        return $this._lock;
    }

    public static final /* synthetic */ List access$get_backgroundServices$p(BackgroundManager $this) {
        return $this._backgroundServices;
    }

    public static final /* synthetic */ void access$scheduleBackground(BackgroundManager $this) {
        $this.scheduleBackground();
    }

    public static final /* synthetic */ void access$set_nextScheduledSyncTimeMs$p(BackgroundManager $this, long l) {
        $this._nextScheduledSyncTimeMs = l;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/onesignal/core/internal/background/impl/BackgroundManager$Companion;", "", "()V", "SYNC_TASK_ID", "", "com.onesignal.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

