/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.http.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\fH\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019R\u001a\u0010\u0002\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0003\u00a8\u0006\u001b"}, d2={"Lcom/onesignal/core/internal/http/impl/TLS12SocketFactory;", "Ljavax/net/ssl/SSLSocketFactory;", "sslSocketFactory", "(Ljavax/net/ssl/SSLSocketFactory;)V", "getSslSocketFactory", "()Ljavax/net/ssl/SSLSocketFactory;", "setSslSocketFactory", "createSocket", "Ljava/net/Socket;", "host", "Ljava/net/InetAddress;", "port", "", "address", "localAddress", "localPort", "s", "", "autoClose", "", "localHost", "enableTLS", "socket", "getDefaultCipherSuites", "", "()[Ljava/lang/String;", "getSupportedCipherSuites", "com.onesignal.core"})
public final class TLS12SocketFactory
extends SSLSocketFactory {
    @NotNull
    private SSLSocketFactory sslSocketFactory;

    public TLS12SocketFactory(@NotNull SSLSocketFactory sslSocketFactory) {
        Intrinsics.checkNotNullParameter((Object)sslSocketFactory, (String)"sslSocketFactory");
        this.sslSocketFactory = sslSocketFactory;
    }

    @NotNull
    public final SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public final void setSslSocketFactory(@NotNull SSLSocketFactory sSLSocketFactory) {
        Intrinsics.checkNotNullParameter((Object)sSLSocketFactory, (String)"<set-?>");
        this.sslSocketFactory = sSLSocketFactory;
    }

    @Override
    @NotNull
    public String[] getDefaultCipherSuites() {
        String[] stringArray = this.sslSocketFactory.getDefaultCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"sslSocketFactory.defaultCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.sslSocketFactory.getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"sslSocketFactory.supportedCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public Socket createSocket() throws IOException {
        Socket socket = this.sslSocketFactory.createSocket();
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"sslSocketFactory.createSocket()");
        return this.enableTLS(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull Socket s, @NotNull String host, int port, boolean autoClose) throws IOException {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Socket socket = this.sslSocketFactory.createSocket(s, host, port, autoClose);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"sslSocketFactory.createS\u2026s, host, port, autoClose)");
        return this.enableTLS(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port) throws IOException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Socket socket = this.sslSocketFactory.createSocket(host, port);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"sslSocketFactory.createSocket(host, port)");
        return this.enableTLS(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port, @NotNull InetAddress localHost, int localPort) throws IOException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Socket socket = this.sslSocketFactory.createSocket(host, port, localHost, localPort);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"sslSocketFactory.createS\u2026rt, localHost, localPort)");
        return this.enableTLS(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress host, int port) throws IOException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Socket socket = this.sslSocketFactory.createSocket(host, port);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"sslSocketFactory.createSocket(host, port)");
        return this.enableTLS(socket);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull InetAddress address, int port, @NotNull InetAddress localAddress, int localPort) throws IOException {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        Socket socket = this.sslSocketFactory.createSocket(address, port, localAddress, localPort);
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"sslSocketFactory.createS\u2026 localAddress, localPort)");
        return this.enableTLS(socket);
    }

    private final Socket enableTLS(Socket socket) {
        if (socket instanceof SSLSocket) {
            String[] stringArray = new String[]{"TLSv1.2"};
            ((SSLSocket)socket).setEnabledProtocols(stringArray);
        }
        return socket;
    }
}

