/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import androidx.core.app.ActivityCompat;
import com.onesignal.OneSignal;
import com.onesignal.core.R;
import com.onesignal.core.internal.permissions.IRequestPermissionService;
import com.onesignal.core.internal.permissions.impl.RequestPermissionService;
import com.onesignal.core.internal.preferences.IPreferencesService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J+\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0012\u0010\u001c\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/onesignal/core/activities/PermissionsActivity;", "Landroid/app/Activity;", "()V", "permissionRequestType", "", "preferenceService", "Lcom/onesignal/core/internal/preferences/IPreferencesService;", "requestPermissionService", "Lcom/onesignal/core/internal/permissions/impl/RequestPermissionService;", "handleBundleParams", "", "extras", "Landroid/os/Bundle;", "onCreate", "savedInstanceState", "onNewIntent", "intent", "Landroid/content/Intent;", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "requestPermission", "androidPermissionString", "reregisterCallbackHandlers", "shouldShowSettings", "", "permission", "Companion", "com.onesignal.core"})
public final class PermissionsActivity
extends Activity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private RequestPermissionService requestPermissionService;
    @Nullable
    private IPreferencesService preferenceService;
    @Nullable
    private String permissionRequestType;
    public static final int DELAY_TIME_CALLBACK_CALL = 500;
    public static final int ONESIGNAL_PERMISSION_REQUEST_CODE = 2;
    @NotNull
    public static final String INTENT_EXTRA_PERMISSION_TYPE = "INTENT_EXTRA_PERMISSION_TYPE";
    @NotNull
    public static final String INTENT_EXTRA_ANDROID_PERMISSION_STRING = "INTENT_EXTRA_ANDROID_PERMISSION_STRING";
    @NotNull
    public static final String INTENT_EXTRA_CALLBACK_CLASS = "INTENT_EXTRA_CALLBACK_CLASS";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!OneSignal.initWithContext((Context)this)) {
            return;
        }
        OneSignal this_$iv = OneSignal.INSTANCE;
        boolean $i$f$getService = false;
        this.requestPermissionService = this_$iv.getServices().getService(RequestPermissionService.class);
        this_$iv = OneSignal.INSTANCE;
        $i$f$getService = false;
        this.preferenceService = this_$iv.getServices().getService(IPreferencesService.class);
        this.handleBundleParams(this.getIntent().getExtras());
    }

    protected void onNewIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        super.onNewIntent(intent);
        this.handleBundleParams(intent.getExtras());
    }

    private final void handleBundleParams(Bundle extras) {
        String androidPermissionString;
        if (Build.VERSION.SDK_INT < 23) {
            this.finish();
            this.overridePendingTransition(R.anim.onesignal_fade_in, R.anim.onesignal_fade_out);
            return;
        }
        this.reregisterCallbackHandlers(extras);
        Bundle bundle = extras;
        Intrinsics.checkNotNull((Object)bundle);
        this.permissionRequestType = bundle.getString(INTENT_EXTRA_PERMISSION_TYPE);
        String string = androidPermissionString = extras.getString(INTENT_EXTRA_ANDROID_PERMISSION_STRING);
        Intrinsics.checkNotNull((Object)string);
        this.requestPermission(string);
    }

    private final void reregisterCallbackHandlers(Bundle extras) {
        Bundle bundle = extras;
        Intrinsics.checkNotNull((Object)bundle);
        String className = bundle.getString(INTENT_EXTRA_CALLBACK_CLASS);
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find callback class for PermissionActivity: " + className);
        }
    }

    private final void requestPermission(String androidPermissionString) {
        RequestPermissionService requestPermissionService = this.requestPermissionService;
        Intrinsics.checkNotNull((Object)requestPermissionService);
        if (!requestPermissionService.getWaiting()) {
            RequestPermissionService requestPermissionService2 = this.requestPermissionService;
            Intrinsics.checkNotNull((Object)requestPermissionService2);
            requestPermissionService2.setWaiting(true);
            RequestPermissionService requestPermissionService3 = this.requestPermissionService;
            Intrinsics.checkNotNull((Object)requestPermissionService3);
            requestPermissionService3.setShouldShowRequestPermissionRationaleBeforeRequest(ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)androidPermissionString));
            String[] stringArray = new String[]{androidPermissionString};
            ActivityCompat.requestPermissions((Activity)this, (String[])stringArray, (int)2);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        RequestPermissionService requestPermissionService = this.requestPermissionService;
        Intrinsics.checkNotNull((Object)requestPermissionService);
        requestPermissionService.setWaiting(false);
        if (requestCode == 2) {
            new Handler().postDelayed(() -> PermissionsActivity.onRequestPermissionsResult$lambda-0(this, permissions, grantResults), 500L);
        }
        this.finish();
        this.overridePendingTransition(R.anim.onesignal_fade_in, R.anim.onesignal_fade_out);
    }

    private final boolean shouldShowSettings(String permission) {
        RequestPermissionService requestPermissionService = this.requestPermissionService;
        Intrinsics.checkNotNull((Object)requestPermissionService);
        if (!requestPermissionService.getFallbackToSettings()) {
            return false;
        }
        RequestPermissionService requestPermissionService2 = this.requestPermissionService;
        Intrinsics.checkNotNull((Object)requestPermissionService2);
        if (requestPermissionService2.getShouldShowRequestPermissionRationaleBeforeRequest() && !ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permission)) {
            IPreferencesService iPreferencesService = this.preferenceService;
            Intrinsics.checkNotNull((Object)iPreferencesService);
            iPreferencesService.saveBool("OneSignal", "USER_RESOLVED_PERMISSION_" + permission, true);
            return false;
        }
        IPreferencesService iPreferencesService = this.preferenceService;
        Intrinsics.checkNotNull((Object)iPreferencesService);
        Boolean bl = iPreferencesService.getBool("OneSignal", "USER_RESOLVED_PERMISSION_" + permission, false);
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    private static final void onRequestPermissionsResult$lambda-0(PermissionsActivity this$0, String[] $permissions, int[] $grantResults) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$permissions, (String)"$permissions");
        Intrinsics.checkNotNullParameter((Object)$grantResults, (String)"$grantResults");
        RequestPermissionService requestPermissionService = this$0.requestPermissionService;
        Intrinsics.checkNotNull((Object)requestPermissionService);
        String string = this$0.permissionRequestType;
        Intrinsics.checkNotNull((Object)string);
        IRequestPermissionService.PermissionCallback permissionCallback = requestPermissionService.getCallback(string);
        if (permissionCallback == null) {
            throw new RuntimeException("Missing handler for permissionRequestType: " + this$0.permissionRequestType);
        }
        IRequestPermissionService.PermissionCallback callback = permissionCallback;
        boolean defaultFallbackSetting = false;
        if ($permissions.length == 0) {
            callback.onReject(defaultFallbackSetting);
        } else {
            boolean granted;
            String permission = $permissions[0];
            boolean bl = granted = $grantResults.length > 0 && $grantResults[0] == 0;
            if (granted) {
                callback.onAccept();
                IPreferencesService iPreferencesService = this$0.preferenceService;
                Intrinsics.checkNotNull((Object)iPreferencesService);
                iPreferencesService.saveBool("OneSignal", "USER_RESOLVED_PERMISSION_" + permission, true);
            } else {
                callback.onReject(this$0.shouldShowSettings(permission));
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/onesignal/core/activities/PermissionsActivity$Companion;", "", "()V", "DELAY_TIME_CALLBACK_CALL", "", "INTENT_EXTRA_ANDROID_PERMISSION_STRING", "", "INTENT_EXTRA_CALLBACK_CLASS", "INTENT_EXTRA_PERMISSION_TYPE", "ONESIGNAL_PERMISSION_REQUEST_CODE", "com.onesignal.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

