/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common.modeling;

import com.onesignal.common.events.EventProducer;
import com.onesignal.common.modeling.IModelStore;
import com.onesignal.common.modeling.IModelStoreChangeHandler;
import com.onesignal.common.modeling.ISingletonModelStore;
import com.onesignal.common.modeling.ISingletonModelStoreChangeHandler;
import com.onesignal.common.modeling.Model;
import com.onesignal.common.modeling.ModelChangedArgs;
import com.onesignal.common.modeling.ModelStore;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u001d\u0010 \u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010!\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u0016\u0010#\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/onesignal/common/modeling/SingletonModelStore;", "TModel", "Lcom/onesignal/common/modeling/Model;", "Lcom/onesignal/common/modeling/ISingletonModelStore;", "Lcom/onesignal/common/modeling/IModelStoreChangeHandler;", "store", "Lcom/onesignal/common/modeling/ModelStore;", "(Lcom/onesignal/common/modeling/ModelStore;)V", "changeSubscription", "Lcom/onesignal/common/events/EventProducer;", "Lcom/onesignal/common/modeling/ISingletonModelStoreChangeHandler;", "hasSubscribers", "", "getHasSubscribers", "()Z", "model", "getModel", "()Lcom/onesignal/common/modeling/Model;", "replaceLock", "", "singletonId", "", "getStore", "()Lcom/onesignal/common/modeling/ModelStore;", "onModelAdded", "", "tag", "(Lcom/onesignal/common/modeling/Model;Ljava/lang/String;)V", "onModelRemoved", "onModelUpdated", "args", "Lcom/onesignal/common/modeling/ModelChangedArgs;", "replace", "subscribe", "handler", "unsubscribe", "com.onesignal.core"})
public class SingletonModelStore<TModel extends Model>
implements ISingletonModelStore<TModel>,
IModelStoreChangeHandler<TModel> {
    @NotNull
    private final ModelStore<TModel> store;
    @NotNull
    private final EventProducer<ISingletonModelStoreChangeHandler<TModel>> changeSubscription;
    @NotNull
    private final String singletonId;
    @NotNull
    private final Object replaceLock;

    public SingletonModelStore(@NotNull ModelStore<TModel> store) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        this.store = store;
        this.changeSubscription = new EventProducer();
        this.singletonId = "-singleton-";
        this.replaceLock = new Object();
        this.store.subscribe(this);
    }

    @NotNull
    public final ModelStore<TModel> getStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TModel getModel() {
        SingletonModelStore singletonModelStore = this;
        synchronized (singletonModelStore) {
            block5: {
                boolean bl = false;
                TModel model = this.store.get(this.singletonId);
                if (model == null) break block5;
                TModel TModel = model;
                return TModel;
            }
            Model model = IModelStore.DefaultImpls.create$default(this.store, null, 1, null);
            if (model == null) {
                throw new Exception("Unable to initialize model from store " + this.store);
            }
            Model createdModel = model;
            createdModel.setId(this.singletonId);
            IModelStore.DefaultImpls.add$default(this.store, createdModel, null, 2, null);
            Model model2 = createdModel;
            return (TModel)model2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(@NotNull TModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object object = this.replaceLock;
        synchronized (object) {
            boolean bl = false;
            TModel existingModel = this.getModel();
            ((Model)existingModel).initializeFromModel(this.singletonId, (Model)model);
            this.store.persist();
            this.changeSubscription.fire((Function1)new Function1<ISingletonModelStoreChangeHandler<TModel>, Unit>(existingModel, tag){
                final /* synthetic */ TModel $existingModel;
                final /* synthetic */ String $tag;
                {
                    this.$existingModel = $existingModel;
                    this.$tag = $tag;
                    super(1);
                }

                public final void invoke(@NotNull ISingletonModelStoreChangeHandler<TModel> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    it.onModelReplaced(this.$existingModel, this.$tag);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void subscribe(@NotNull ISingletonModelStoreChangeHandler<TModel> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.changeSubscription.subscribe(handler);
    }

    @Override
    public void unsubscribe(@NotNull ISingletonModelStoreChangeHandler<TModel> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.changeSubscription.unsubscribe(handler);
    }

    @Override
    public boolean getHasSubscribers() {
        return this.changeSubscription.getHasSubscribers();
    }

    @Override
    public void onModelAdded(@NotNull TModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }

    @Override
    public void onModelUpdated(@NotNull ModelChangedArgs args, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.changeSubscription.fire((Function1)new Function1<ISingletonModelStoreChangeHandler<TModel>, Unit>(args, tag){
            final /* synthetic */ ModelChangedArgs $args;
            final /* synthetic */ String $tag;
            {
                this.$args = $args;
                this.$tag = $tag;
                super(1);
            }

            public final void invoke(@NotNull ISingletonModelStoreChangeHandler<TModel> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.onModelUpdated(this.$args, this.$tag);
            }
        });
    }

    @Override
    public void onModelRemoved(@NotNull TModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }
}

