/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.inAppMessages.internal;

import com.onesignal.inAppMessages.IInAppMessageAction;
import com.onesignal.inAppMessages.InAppMessageActionUrlType;
import com.onesignal.inAppMessages.internal.InAppMessageOutcome;
import com.onesignal.inAppMessages.internal.InAppMessageTag;
import com.onesignal.inAppMessages.internal.prompt.IInAppMessagePromptFactory;
import com.onesignal.inAppMessages.internal.prompt.impl.InAppMessagePrompt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 02\u00020\u0001:\u00010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010.\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010/\u001a\u00020\u0003R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0016\u0010\r\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0012\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\nR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u00061"}, d2={"Lcom/onesignal/inAppMessages/internal/InAppMessageAction;", "Lcom/onesignal/inAppMessages/IInAppMessageAction;", "json", "Lorg/json/JSONObject;", "promptFactory", "Lcom/onesignal/inAppMessages/internal/prompt/IInAppMessagePromptFactory;", "(Lorg/json/JSONObject;Lcom/onesignal/inAppMessages/internal/prompt/IInAppMessagePromptFactory;)V", "clickId", "", "getClickId", "()Ljava/lang/String;", "clickName", "getClickName", "clickUrl", "getClickUrl", "closesMessage", "", "getClosesMessage", "()Z", "isFirstClick", "setFirstClick", "(Z)V", "outcomes", "", "Lcom/onesignal/inAppMessages/internal/InAppMessageOutcome;", "getOutcomes", "()Ljava/util/List;", "pageId", "getPageId", "prompts", "Lcom/onesignal/inAppMessages/internal/prompt/impl/InAppMessagePrompt;", "getPrompts", "tags", "Lcom/onesignal/inAppMessages/internal/InAppMessageTag;", "getTags", "()Lcom/onesignal/inAppMessages/internal/InAppMessageTag;", "setTags", "(Lcom/onesignal/inAppMessages/internal/InAppMessageTag;)V", "urlTarget", "Lcom/onesignal/inAppMessages/InAppMessageActionUrlType;", "getUrlTarget", "()Lcom/onesignal/inAppMessages/InAppMessageActionUrlType;", "setUrlTarget", "(Lcom/onesignal/inAppMessages/InAppMessageActionUrlType;)V", "parseOutcomes", "", "parsePrompts", "toJSONObject", "Companion", "in-app-messages_release"})
public final class InAppMessageAction
implements IInAppMessageAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String clickId;
    @Nullable
    private final String clickName;
    @Nullable
    private InAppMessageActionUrlType urlTarget;
    @Nullable
    private final String clickUrl;
    @Nullable
    private final String pageId;
    @NotNull
    private final List<InAppMessageOutcome> outcomes;
    @NotNull
    private final List<InAppMessagePrompt> prompts;
    @Nullable
    private InAppMessageTag tags;
    private boolean isFirstClick;
    private final boolean closesMessage;
    @NotNull
    private static final String ID = "id";
    @NotNull
    private static final String NAME = "name";
    @NotNull
    private static final String URL = "url";
    @NotNull
    private static final String PAGE_ID = "pageId";
    @NotNull
    private static final String URL_TARGET = "url_target";
    @NotNull
    private static final String CLOSE = "close";
    @NotNull
    private static final String CLICK_NAME = "click_name";
    @NotNull
    private static final String CLICK_URL = "click_url";
    @NotNull
    private static final String FIRST_CLICK = "first_click";
    @NotNull
    private static final String CLOSES_MESSAGE = "closes_message";
    @NotNull
    private static final String OUTCOMES = "outcomes";
    @NotNull
    private static final String TAGS = "tags";
    @NotNull
    private static final String PROMPTS = "prompts";

    public InAppMessageAction(@NotNull JSONObject json2, @NotNull IInAppMessagePromptFactory promptFactory) {
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)promptFactory, (String)"promptFactory");
        this.outcomes = new ArrayList();
        this.prompts = new ArrayList();
        this.clickId = json2.optString(ID, null);
        this.clickName = json2.optString(NAME, null);
        this.clickUrl = json2.optString(URL, null);
        this.pageId = json2.optString(PAGE_ID, null);
        this.setUrlTarget(InAppMessageActionUrlType.Companion.fromString(json2.optString(URL_TARGET, null)));
        if (this.getUrlTarget() == null) {
            this.setUrlTarget(InAppMessageActionUrlType.IN_APP_WEBVIEW);
        }
        this.closesMessage = json2.optBoolean(CLOSE, true);
        if (json2.has(OUTCOMES)) {
            this.parseOutcomes(json2);
        }
        if (json2.has(TAGS)) {
            JSONObject jSONObject = json2.getJSONObject(TAGS);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"json.getJSONObject(TAGS)");
            this.tags = new InAppMessageTag(jSONObject);
        }
        if (json2.has(PROMPTS)) {
            this.parsePrompts(json2, promptFactory);
        }
    }

    @Nullable
    public final String getClickId() {
        return this.clickId;
    }

    @Nullable
    public String getClickName() {
        return this.clickName;
    }

    @Nullable
    public InAppMessageActionUrlType getUrlTarget() {
        return this.urlTarget;
    }

    public void setUrlTarget(@Nullable InAppMessageActionUrlType inAppMessageActionUrlType) {
        this.urlTarget = inAppMessageActionUrlType;
    }

    @Nullable
    public String getClickUrl() {
        return this.clickUrl;
    }

    @Nullable
    public final String getPageId() {
        return this.pageId;
    }

    @NotNull
    public final List<InAppMessageOutcome> getOutcomes() {
        return this.outcomes;
    }

    @NotNull
    public final List<InAppMessagePrompt> getPrompts() {
        return this.prompts;
    }

    @Nullable
    public final InAppMessageTag getTags() {
        return this.tags;
    }

    public final void setTags(@Nullable InAppMessageTag inAppMessageTag) {
        this.tags = inAppMessageTag;
    }

    public boolean isFirstClick() {
        return this.isFirstClick;
    }

    public void setFirstClick(boolean bl) {
        this.isFirstClick = bl;
    }

    public boolean getClosesMessage() {
        return this.closesMessage;
    }

    private final void parseOutcomes(JSONObject json2) throws JSONException {
        JSONArray outcomesJsonArray = json2.getJSONArray(OUTCOMES);
        int n = outcomesJsonArray.length();
        for (int i = 0; i < n; ++i) {
            Object object = outcomesJsonArray.get(i);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.JSONObject");
            this.outcomes.add(new InAppMessageOutcome((JSONObject)object));
        }
    }

    private final void parsePrompts(JSONObject json2, IInAppMessagePromptFactory promptFactory) throws JSONException {
        JSONArray promptsJsonArray = json2.getJSONArray(PROMPTS);
        int n = promptsJsonArray.length();
        for (int i = 0; i < n; ++i) {
            String promptType = promptsJsonArray.getString(i);
            Intrinsics.checkNotNullExpressionValue((Object)promptType, (String)"promptType");
            InAppMessagePrompt prompt = promptFactory.createPrompt(promptType);
            if (prompt == null) continue;
            this.prompts.add(prompt);
        }
    }

    @NotNull
    public final JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put(CLICK_NAME, (Object)this.getClickName());
            mainObj.put(CLICK_URL, (Object)this.getClickUrl());
            mainObj.put(FIRST_CLICK, this.isFirstClick());
            mainObj.put(CLOSES_MESSAGE, this.getClosesMessage());
            JSONArray outcomesJson = new JSONArray();
            for (InAppMessageOutcome outcome : this.outcomes) {
                outcomesJson.put((Object)outcome.toJSONObject());
            }
            mainObj.put(OUTCOMES, (Object)outcomesJson);
            if (this.tags != null) {
                InAppMessageTag inAppMessageTag = this.tags;
                Intrinsics.checkNotNull((Object)inAppMessageTag);
                mainObj.put(TAGS, (Object)inAppMessageTag.toJSONObject());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mainObj;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/onesignal/inAppMessages/internal/InAppMessageAction$Companion;", "", "()V", "CLICK_NAME", "", "CLICK_URL", "CLOSE", "CLOSES_MESSAGE", "FIRST_CLICK", "ID", "NAME", "OUTCOMES", "PAGE_ID", "PROMPTS", "TAGS", "URL", "URL_TARGET", "in-app-messages_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

