/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.inAppMessages.internal.triggers.impl;

import com.onesignal.common.modeling.IModelStoreChangeHandler;
import com.onesignal.common.modeling.Model;
import com.onesignal.common.modeling.ModelChangedArgs;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.inAppMessages.internal.InAppMessage;
import com.onesignal.inAppMessages.internal.Trigger;
import com.onesignal.inAppMessages.internal.triggers.ITriggerController;
import com.onesignal.inAppMessages.internal.triggers.ITriggerHandler;
import com.onesignal.inAppMessages.internal.triggers.TriggerModel;
import com.onesignal.inAppMessages.internal.triggers.TriggerModelStore;
import com.onesignal.inAppMessages.internal.triggers.impl.DynamicTriggerController;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u001e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u000bH\u0016J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u000bH\u0016J\u0018\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020\u000bH\u0016J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0016J\"\u0010,\u001a\u00020\u00142\b\u0010-\u001a\u0004\u0018\u00010\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0002J \u00101\u001a\u00020\u00142\u0006\u0010-\u001a\u0002022\u0006\u0010.\u001a\u0002022\u0006\u0010/\u001a\u000200H\u0002J \u00103\u001a\u00020\u00142\u0006\u0010-\u001a\u0002022\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u000200H\u0002J \u00104\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00105\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00066"}, d2={"Lcom/onesignal/inAppMessages/internal/triggers/impl/TriggerController;", "Lcom/onesignal/inAppMessages/internal/triggers/ITriggerController;", "Lcom/onesignal/common/modeling/IModelStoreChangeHandler;", "Lcom/onesignal/inAppMessages/internal/triggers/TriggerModel;", "triggerModelStore", "Lcom/onesignal/inAppMessages/internal/triggers/TriggerModelStore;", "_dynamicTriggerController", "Lcom/onesignal/inAppMessages/internal/triggers/impl/DynamicTriggerController;", "(Lcom/onesignal/inAppMessages/internal/triggers/TriggerModelStore;Lcom/onesignal/inAppMessages/internal/triggers/impl/DynamicTriggerController;)V", "triggers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getTriggers", "()Ljava/util/concurrent/ConcurrentHashMap;", "addTriggers", "", "key", "value", "evaluateAndTriggers", "", "andConditions", "", "Lcom/onesignal/inAppMessages/internal/Trigger;", "evaluateMessageTriggers", "message", "Lcom/onesignal/inAppMessages/internal/InAppMessage;", "evaluateTrigger", "trigger", "isTriggerOnMessage", "triggersKeys", "", "messageHasOnlyDynamicTriggers", "onModelAdded", "model", "tag", "onModelRemoved", "onModelUpdated", "args", "Lcom/onesignal/common/modeling/ModelChangedArgs;", "removeTriggersForKeys", "subscribe", "handler", "Lcom/onesignal/inAppMessages/internal/triggers/ITriggerHandler;", "triggerMatchesFlex", "triggerValue", "deviceValue", "operator", "Lcom/onesignal/inAppMessages/internal/Trigger$OSTriggerOperator;", "triggerMatchesNumericValue", "", "triggerMatchesNumericValueFlex", "triggerMatchesStringValue", "unsubscribe", "in-app-messages_release"})
public final class TriggerController
implements ITriggerController,
IModelStoreChangeHandler<TriggerModel> {
    @NotNull
    private DynamicTriggerController _dynamicTriggerController;
    @NotNull
    private final ConcurrentHashMap<String, Object> triggers;

    public TriggerController(@NotNull TriggerModelStore triggerModelStore, @NotNull DynamicTriggerController _dynamicTriggerController) {
        Intrinsics.checkNotNullParameter((Object)((Object)triggerModelStore), (String)"triggerModelStore");
        Intrinsics.checkNotNullParameter((Object)_dynamicTriggerController, (String)"_dynamicTriggerController");
        this._dynamicTriggerController = _dynamicTriggerController;
        this.triggers = new ConcurrentHashMap();
        triggerModelStore.subscribe(this);
    }

    @NotNull
    public final ConcurrentHashMap<String, Object> getTriggers() {
        return this.triggers;
    }

    @Override
    public boolean evaluateMessageTriggers(@NotNull InAppMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message.getTriggers().isEmpty()) {
            return true;
        }
        for (List<Trigger> andConditions : message.getTriggers()) {
            if (!this.evaluateAndTriggers(andConditions)) continue;
            return true;
        }
        return false;
    }

    private final boolean evaluateAndTriggers(List<Trigger> andConditions) {
        for (Trigger trigger : andConditions) {
            if (this.evaluateTrigger(trigger)) continue;
            return false;
        }
        return true;
    }

    private final boolean evaluateTrigger(Trigger trigger) {
        if (trigger.getKind() == Trigger.OSTriggerKind.UNKNOWN) {
            return false;
        }
        if (trigger.getKind() != Trigger.OSTriggerKind.CUSTOM) {
            return this._dynamicTriggerController.dynamicTriggerShouldFire(trigger);
        }
        Trigger.OSTriggerOperator operatorType = trigger.getOperatorType();
        Object v = ((Map)this.triggers).get(trigger.getProperty());
        if (v == null) {
            return operatorType == Trigger.OSTriggerOperator.NOT_EXISTS ? true : operatorType == Trigger.OSTriggerOperator.NOT_EQUAL_TO && trigger.getValue() != null;
        }
        Object deviceValue = v;
        if (operatorType == Trigger.OSTriggerOperator.EXISTS) {
            return true;
        }
        if (operatorType == Trigger.OSTriggerOperator.NOT_EXISTS) {
            return false;
        }
        if (operatorType == Trigger.OSTriggerOperator.CONTAINS) {
            return deviceValue instanceof Collection && ((Collection)deviceValue).contains(trigger.getValue());
        }
        if (deviceValue instanceof String && trigger.getValue() instanceof String) {
            String string2 = (String)trigger.getValue();
            Intrinsics.checkNotNull((Object)string2);
            if (this.triggerMatchesStringValue(string2, (String)deviceValue, operatorType)) {
                return true;
            }
        }
        if (trigger.getValue() instanceof Number && deviceValue instanceof Number) {
            Number number = (Number)trigger.getValue();
            Intrinsics.checkNotNull((Object)number);
            if (this.triggerMatchesNumericValue(number, (Number)deviceValue, operatorType)) {
                return true;
            }
        }
        return this.triggerMatchesFlex(trigger.getValue(), deviceValue, operatorType);
    }

    private final boolean triggerMatchesStringValue(String triggerValue, String deviceValue, Trigger.OSTriggerOperator operator) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual((Object)triggerValue, (Object)deviceValue);
                break;
            }
            case 2: {
                if (!Intrinsics.areEqual((Object)triggerValue, (Object)deviceValue)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                Logging.error$default((String)("Attempted to use an invalid operator for a string trigger comparison: " + (Object)((Object)operator)), null, (int)2, null);
                bl = false;
            }
        }
        return bl;
    }

    private final boolean triggerMatchesFlex(Object triggerValue, Object deviceValue, Trigger.OSTriggerOperator operator) {
        if (triggerValue == null) {
            return false;
        }
        if (operator.checksEquality()) {
            String triggerValueString = triggerValue.toString();
            String deviceValueString = deviceValue.toString();
            if (deviceValue instanceof Number) {
                DecimalFormat format = new DecimalFormat("0.#");
                String string2 = format.format(deviceValue);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.format(deviceValue)");
                deviceValueString = string2;
            }
            return this.triggerMatchesStringValue(triggerValueString, deviceValueString, operator);
        }
        return deviceValue instanceof String && triggerValue instanceof Number ? this.triggerMatchesNumericValueFlex((Number)triggerValue, (String)deviceValue, operator) : false;
    }

    private final boolean triggerMatchesNumericValueFlex(Number triggerValue, String deviceValue, Trigger.OSTriggerOperator operator) {
        double d;
        try {
            d = Double.parseDouble(deviceValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        double deviceDoubleValue = d;
        return this.triggerMatchesNumericValue(triggerValue.doubleValue(), deviceDoubleValue, operator);
    }

    private final boolean triggerMatchesNumericValue(Number triggerValue, Number deviceValue, Trigger.OSTriggerOperator operator) {
        boolean bl;
        double triggerDoubleValue = triggerValue.doubleValue();
        double deviceDoubleValue = deviceValue.doubleValue();
        switch (WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                Logging.error$default((String)("Attempted to use an invalid operator with a numeric value: " + (Object)((Object)operator)), null, (int)2, null);
                bl = false;
                break;
            }
            case 1: {
                if (deviceDoubleValue == triggerDoubleValue) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (!(deviceDoubleValue == triggerDoubleValue)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 6: {
                if (deviceDoubleValue < triggerDoubleValue) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 7: {
                if (deviceDoubleValue > triggerDoubleValue) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 8: {
                if (deviceDoubleValue < triggerDoubleValue || deviceDoubleValue == triggerDoubleValue) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 9: {
                if (deviceDoubleValue > triggerDoubleValue || deviceDoubleValue == triggerDoubleValue) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Override
    public boolean isTriggerOnMessage(@NotNull InAppMessage message, @NotNull Collection<String> triggersKeys) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(triggersKeys, (String)"triggersKeys");
        if (message.getTriggers() == null) {
            return false;
        }
        for (String triggerKey : triggersKeys) {
            for (List<Trigger> andConditions : message.getTriggers()) {
                for (Trigger trigger : andConditions) {
                    if (!Intrinsics.areEqual((Object)triggerKey, (Object)trigger.getProperty()) && !Intrinsics.areEqual((Object)triggerKey, (Object)trigger.getTriggerId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean messageHasOnlyDynamicTriggers(@NotNull InAppMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message.getTriggers() == null || message.getTriggers().isEmpty()) {
            return false;
        }
        for (List<Trigger> andConditions : message.getTriggers()) {
            for (Trigger trigger : andConditions) {
                if (trigger.getKind() != Trigger.OSTriggerKind.CUSTOM && trigger.getKind() != Trigger.OSTriggerKind.UNKNOWN) continue;
                return false;
            }
        }
        return true;
    }

    public void onModelAdded(@NotNull TriggerModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.addTriggers(model.getKey(), model.getValue());
        this._dynamicTriggerController.getEvents().fire((Function1)new Function1<ITriggerHandler, Unit>(model){
            final /* synthetic */ TriggerModel $model;
            {
                this.$model = $model;
                super(1);
            }

            public final void invoke(@NotNull ITriggerHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onTriggerChanged(this.$model.getKey());
            }
        });
    }

    public void onModelUpdated(@NotNull ModelChangedArgs args, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Model model = args.getModel();
        Intrinsics.checkNotNull((Object)model, (String)"null cannot be cast to non-null type com.onesignal.inAppMessages.internal.triggers.TriggerModel");
        TriggerModel model2 = (TriggerModel)model;
        this.addTriggers(model2.getKey(), model2.getValue());
        this._dynamicTriggerController.getEvents().fire((Function1)new Function1<ITriggerHandler, Unit>(model2){
            final /* synthetic */ TriggerModel $model;
            {
                this.$model = $model;
                super(1);
            }

            public final void invoke(@NotNull ITriggerHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onTriggerChanged(this.$model.getKey());
            }
        });
    }

    public void onModelRemoved(@NotNull TriggerModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.removeTriggersForKeys(model.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addTriggers(String key2, Object value2) {
        ConcurrentHashMap<String, Object> concurrentHashMap = this.triggers;
        synchronized (concurrentHashMap) {
            boolean bl = false;
            ((Map)this.triggers).put(key2, value2);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeTriggersForKeys(String key2) {
        ConcurrentHashMap<String, Object> concurrentHashMap = this.triggers;
        synchronized (concurrentHashMap) {
            boolean bl = false;
            Object object = this.triggers.remove(key2);
        }
    }

    public void subscribe(@NotNull ITriggerHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this._dynamicTriggerController.subscribe(handler);
    }

    public void unsubscribe(@NotNull ITriggerHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this._dynamicTriggerController.unsubscribe(handler);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Trigger.OSTriggerOperator.values().length];
            nArray[Trigger.OSTriggerOperator.EQUAL_TO.ordinal()] = 1;
            nArray[Trigger.OSTriggerOperator.NOT_EQUAL_TO.ordinal()] = 2;
            nArray[Trigger.OSTriggerOperator.EXISTS.ordinal()] = 3;
            nArray[Trigger.OSTriggerOperator.CONTAINS.ordinal()] = 4;
            nArray[Trigger.OSTriggerOperator.NOT_EXISTS.ordinal()] = 5;
            nArray[Trigger.OSTriggerOperator.LESS_THAN.ordinal()] = 6;
            nArray[Trigger.OSTriggerOperator.GREATER_THAN.ordinal()] = 7;
            nArray[Trigger.OSTriggerOperator.LESS_THAN_OR_EQUAL_TO.ordinal()] = 8;
            nArray[Trigger.OSTriggerOperator.GREATER_THAN_OR_EQUAL_TO.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

