/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.inAppMessages.internal.common;

import com.onesignal.core.internal.language.ILanguageContext;
import com.onesignal.inAppMessages.internal.InAppMessage;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/onesignal/inAppMessages/internal/common/InAppHelper;", "", "()V", "PREFERRED_VARIANT_ORDER", "", "", "variantIdForMessage", "message", "Lcom/onesignal/inAppMessages/internal/InAppMessage;", "languageContext", "Lcom/onesignal/core/internal/language/ILanguageContext;", "com.onesignal.inAppMessages"})
public final class InAppHelper {
    @NotNull
    public static final InAppHelper INSTANCE = new InAppHelper();
    @NotNull
    private static final List<String> PREFERRED_VARIANT_ORDER;

    private InAppHelper() {
    }

    @Nullable
    public final String variantIdForMessage(@NotNull InAppMessage message, @NotNull ILanguageContext languageContext) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)languageContext, (String)"languageContext");
        String language = languageContext.getLanguage();
        for (String variant : PREFERRED_VARIANT_ORDER) {
            if (!message.getVariants().containsKey(variant)) continue;
            Map<String, String> map = message.getVariants().get(variant);
            Intrinsics.checkNotNull(map);
            Map<String, String> variantMap = map;
            return variantMap.containsKey(language) ? variantMap.get(language) : variantMap.get("default");
        }
        return null;
    }

    static {
        Object[] objectArray = new String[]{"android", "app", "all"};
        PREFERRED_VARIANT_ORDER = CollectionsKt.listOf((Object[])objectArray);
    }
}

