/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.generation.impl;

import android.content.Context;
import androidx.work.CoroutineWorker;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import androidx.work.WorkerParameters;
import com.onesignal.OneSignal;
import com.onesignal.common.AndroidUtils;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.notifications.internal.common.NotificationFormatHelper;
import com.onesignal.notifications.internal.generation.INotificationGenerationProcessor;
import com.onesignal.notifications.internal.generation.INotificationGenerationWorkManager;
import com.onesignal.notifications.internal.generation.impl.NotificationGenerationWorkManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/onesignal/notifications/internal/generation/impl/NotificationGenerationWorkManager;", "Lcom/onesignal/notifications/internal/generation/INotificationGenerationWorkManager;", "()V", "beginEnqueueingWork", "", "context", "Landroid/content/Context;", "osNotificationId", "", "androidNotificationId", "", "jsonPayload", "Lorg/json/JSONObject;", "timestamp", "", "isRestoring", "isHighPriority", "Companion", "NotificationGenerationWorker", "com.onesignal.notifications"})
public final class NotificationGenerationWorkManager
implements INotificationGenerationWorkManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String OS_ID_DATA_PARAM = "os_notif_id";
    @NotNull
    private static final String ANDROID_NOTIF_ID_WORKER_DATA_PARAM = "android_notif_id";
    @NotNull
    private static final String JSON_PAYLOAD_WORKER_DATA_PARAM = "json_payload";
    @NotNull
    private static final String TIMESTAMP_WORKER_DATA_PARAM = "timestamp";
    @NotNull
    private static final String IS_RESTORING_WORKER_DATA_PARAM = "is_restoring";
    @NotNull
    private static final ConcurrentHashMap<String, Boolean> notificationIds = new ConcurrentHashMap();

    @Override
    public boolean beginEnqueueingWork(@NotNull Context context, @NotNull String osNotificationId, int androidNotificationId, @Nullable JSONObject jsonPayload, long timestamp, boolean isRestoring, boolean isHighPriority) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)osNotificationId, (String)"osNotificationId");
        String id2 = NotificationFormatHelper.INSTANCE.getOSNotificationIdFromJson(jsonPayload);
        if (id2 == null) {
            Logging.debug$default((String)"Notification beginEnqueueingWork with id null", null, (int)2, null);
            return false;
        }
        if (!Companion.addNotificationIdProcessed(id2)) {
            Logging.debug$default((String)"Notification beginEnqueueingWork with id duplicated", null, (int)2, null);
            return true;
        }
        Data data = new Data.Builder().putString(OS_ID_DATA_PARAM, id2).putInt(ANDROID_NOTIF_ID_WORKER_DATA_PARAM, androidNotificationId).putString(JSON_PAYLOAD_WORKER_DATA_PARAM, String.valueOf(jsonPayload)).putLong(TIMESTAMP_WORKER_DATA_PARAM, timestamp).putBoolean(IS_RESTORING_WORKER_DATA_PARAM, isRestoring).build();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"Builder()\n            .p\u2026ing)\n            .build()");
        Data inputData = data;
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(NotificationGenerationWorker.class).setInputData(inputData)).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(NotificationGene\u2026ata)\n            .build()");
        OneTimeWorkRequest workRequest2 = (OneTimeWorkRequest)workRequest;
        Logging.debug$default((String)("NotificationWorkManager enqueueing notification work with notificationId: " + osNotificationId + " and jsonPayload: " + jsonPayload), null, (int)2, null);
        WorkManager.getInstance((Context)context).enqueueUniqueWork(osNotificationId, ExistingWorkPolicy.KEEP, workRequest2);
        return true;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Lcom/onesignal/notifications/internal/generation/impl/NotificationGenerationWorkManager$NotificationGenerationWorker;", "Landroidx/work/CoroutineWorker;", "context", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "com.onesignal.notifications"})
    public static final class NotificationGenerationWorker
    extends CoroutineWorker {
        public NotificationGenerationWorker(@NotNull Context context, @NotNull WorkerParameters workerParams) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
            super(context, workerParams);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public Object doWork(@NotNull Continuation<? super ListenableWorker.Result> var1_1) {
            if (!(var1_1 instanceof doWork.1)) ** GOTO lbl-1000
            var12_2 = var1_1;
            if ((var12_2.label & -2147483648) != 0) {
                var12_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ NotificationGenerationWorker this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.doWork((Continuation<? super ListenableWorker.Result>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!OneSignal.isInitialized()) {
                        v0 = ListenableWorker.Result.failure();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"failure()");
                        return v0;
                    }
                    this_$iv = OneSignal.INSTANCE;
                    $i$f$getService = false;
                    notificationProcessor = (INotificationGenerationProcessor)this_$iv.getServices().getService(INotificationGenerationProcessor.class);
                    v1 = this.getInputData();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"inputData");
                    inputData = v1;
                    v2 = inputData.getString("os_notif_id");
                    if (v2 == null) {
                        v3 = ListenableWorker.Result.failure();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"failure()");
                        return v3;
                    }
                    id = v2;
                    Logging.debug$default((String)("NotificationWorker running doWork with data: " + inputData), null, (int)2, null);
                    androidNotificationId = inputData.getInt("android_notif_id", 0);
                    jsonPayload = new JSONObject(inputData.getString("json_payload"));
                    timestamp = inputData.getLong("timestamp", System.currentTimeMillis() / 1000L);
                    isRestoring = inputData.getBoolean("is_restoring", false);
                    var10_16 = this.getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)var10_16, (String)"applicationContext");
                    $continuation.L$0 = id;
                    $continuation.label = 1;
                    v4 = notificationProcessor.processNotificationData(var10_16, androidNotificationId, jsonPayload, isRestoring != false, timestamp, (Continuation<? super Unit>)$continuation);
                    ** if (v4 != var13_4) goto lbl42
lbl41:
                    // 1 sources

                    return var13_4;
lbl42:
                    // 1 sources

                    ** GOTO lbl49
                }
                case 1: {
                    id = (String)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl49:
                        // 2 sources

                        v5 = id;
                    }
                    catch (JSONException e) {
                        Logging.error((String)("Error occurred doing work for job with id: " + id), (Throwable)e);
                        v6 = ListenableWorker.Result.failure();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"failure()");
                        var6_13 = v6;
                        return var6_13;
                    }
                    ** GOTO lbl-1000
                }
                {
                    finally {
                        v7 = id;
                        Intrinsics.checkNotNull((Object)v7);
                        NotificationGenerationWorkManager.Companion.removeNotificationIdProcessed(v7);
                    }
                }
lbl-1000:
                // 1 sources

                {
                    Intrinsics.checkNotNull((Object)v5);
                    NotificationGenerationWorkManager.Companion.removeNotificationIdProcessed(v5);
                    v8 = ListenableWorker.Result.success();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"success()");
                    return v8;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/onesignal/notifications/internal/generation/impl/NotificationGenerationWorkManager$Companion;", "", "()V", "ANDROID_NOTIF_ID_WORKER_DATA_PARAM", "", "IS_RESTORING_WORKER_DATA_PARAM", "JSON_PAYLOAD_WORKER_DATA_PARAM", "OS_ID_DATA_PARAM", "TIMESTAMP_WORKER_DATA_PARAM", "notificationIds", "Ljava/util/concurrent/ConcurrentHashMap;", "", "addNotificationIdProcessed", "osNotificationId", "removeNotificationIdProcessed", "", "com.onesignal.notifications"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean addNotificationIdProcessed(@NotNull String osNotificationId) {
            Intrinsics.checkNotNullParameter((Object)osNotificationId, (String)"osNotificationId");
            if (AndroidUtils.INSTANCE.isStringNotEmpty(osNotificationId)) {
                if (notificationIds.contains(osNotificationId)) {
                    Logging.debug$default((String)("OSNotificationWorkManager notification with notificationId: " + osNotificationId + " already queued"), null, (int)2, null);
                    return false;
                }
                ((Map)notificationIds).put(osNotificationId, true);
            }
            return true;
        }

        public final void removeNotificationIdProcessed(@NotNull String osNotificationId) {
            Intrinsics.checkNotNullParameter((Object)osNotificationId, (String)"osNotificationId");
            if (AndroidUtils.INSTANCE.isStringNotEmpty(osNotificationId)) {
                notificationIds.remove(osNotificationId);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

