/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.bidi;

import com.openhtmltopdf.bidi.BidiSplitter;
import com.openhtmltopdf.bidi.BidiTextRun;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.layout.LayoutContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ParagraphSplitter {
    private final List<Paragraph> allParagraphs = new ArrayList<Paragraph>();
    private final Map<Text, Paragraph> paragraphs = new HashMap<Text, Paragraph>();
    private final Map<Element, Paragraph> blocks = new HashMap<Element, Paragraph>();

    public static byte convertDirectionIdent(IdentValue ident) {
        if (ident == IdentValue.RTL) {
            return 1;
        }
        return 0;
    }

    public Paragraph lookupParagraph(Text node) {
        return this.paragraphs.get(node);
    }

    public Paragraph lookupBlockElement(Element elem) {
        return this.blocks.get(elem);
    }

    public void splitRoot(LayoutContext c, Document doc) {
        CalculatedStyle style = c.getSharedContext().getStyle(doc.getDocumentElement());
        IdentValue direction = style.getDirection();
        Paragraph parent = new Paragraph(direction);
        this.splitParagraphs(c, doc, parent);
    }

    public void runBidiOnParagraphs(LayoutContext c) {
        for (Paragraph p : this.allParagraphs) {
            p.runBidiSplitter(c.getBidiSplitterFactory().createBidiSplitter(), c);
        }
    }

    private void splitParagraphs(LayoutContext c, Node parent, Paragraph nearestBlock) {
        Node node = parent.getFirstChild();
        if (node == null) {
            return;
        }
        do {
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                String text = ((Text)node).getData();
                nearestBlock.add(text, (Text)node);
                this.paragraphs.put((Text)node, nearestBlock);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            CalculatedStyle style = c.getSharedContext().getStyle(element);
            if (element.getNodeName().equals("head")) continue;
            if (style.isSpecifiedAsBlock() || element.hasAttribute("dir") || element.getNodeName().equals("bdi")) {
                Paragraph para = new Paragraph(style.getDirection());
                this.allParagraphs.add(para);
                this.blocks.put(element, para);
                this.splitParagraphs(c, element, para);
                continue;
            }
            this.blocks.put(element, nearestBlock);
            this.splitParagraphs(c, element, nearestBlock);
        } while ((node = node.getNextSibling()) != null);
    }

    public static class Paragraph {
        private final StringBuilder builder = new StringBuilder();
        private final Map<Text, TextRun> textRuns = new HashMap<Text, TextRun>();
        private final TreeMap<Integer, BidiTextRun> splitPoints = new TreeMap();
        private final IdentValue cssDirection;
        private byte actualDirection = 0;

        private Paragraph(IdentValue direction) {
            this.cssDirection = direction;
        }

        private void add(String text, Text textNode) {
            int startIndex = this.builder.length();
            this.builder.append(text);
            int endIndex = this.builder.length();
            this.textRuns.put(textNode, new TextRun(textNode, startIndex, endIndex));
        }

        private void runBidiSplitter(BidiSplitter splitter, LayoutContext c) {
            int defaultDirection = 0;
            String para = this.builder.toString();
            if (this.cssDirection == IdentValue.RTL) {
                defaultDirection = 1;
            } else if (this.cssDirection == IdentValue.AUTO) {
                defaultDirection = splitter.getBaseDirection(para);
            }
            this.actualDirection = (byte)(defaultDirection == 3 ? 0 : defaultDirection);
            splitter.setParagraph(para, this.actualDirection);
            this.copySplitPointsFromBidiSplitter(splitter);
        }

        public int getFirstCharIndexInParagraph(Text text) {
            return this.textRuns.get(text).startIndexInParagraph;
        }

        private void copySplitPointsFromBidiSplitter(BidiSplitter splitter) {
            int length = splitter.countTextRuns();
            for (int i = 0; i < length; ++i) {
                BidiTextRun run = splitter.getVisualRun(i);
                this.splitPoints.put(run.getStart(), run);
            }
        }

        public BidiTextRun nextSplit(int startIndexInParagraph) {
            Map.Entry<Integer, BidiTextRun> entry = this.splitPoints.ceilingEntry(startIndexInParagraph);
            if (entry != null) {
                return entry.getValue();
            }
            return null;
        }

        public BidiTextRun prevSplit(int startIndexInParagraph) {
            Map.Entry<Integer, BidiTextRun> entry = this.splitPoints.floorEntry(startIndexInParagraph);
            if (entry != null) {
                return entry.getValue();
            }
            return null;
        }

        public byte getActualDirection() {
            return this.actualDirection;
        }

        public IdentValue getCSSDirection() {
            return this.cssDirection;
        }
    }

    public static class TextRun {
        private final Text domText;
        private final int startIndexInParagraph;
        private final int endIndexInParagraph;

        TextRun(Text domText, int startIndexInParagraph, int endIndexInParagraph) {
            this.domText = domText;
            this.startIndexInParagraph = startIndexInParagraph;
            this.endIndexInParagraph = endIndexInParagraph;
        }
    }
}

