/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.ICapability;
import com.openshift.restclient.model.INamespace;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class KubernetesResource
implements IResource,
ResourcePropertyKeys {
    private ModelNode node;
    private IClient client;
    private Map<Class<? extends ICapability>, ICapability> capabilities = new HashMap<Class<? extends ICapability>, ICapability>();
    private Map<String, String[]> propertyKeys;
    private IProject project;
    private INamespace namespace;

    public KubernetesResource(ModelNode node, IClient client, Map<String, String[]> overrideProperties) {
        if (overrideProperties == null) {
            overrideProperties = new HashMap<String, String[]>();
        }
        this.node = node;
        this.client = client;
        this.propertyKeys = overrideProperties;
        CapabilityInitializer.initializeCapabilities(this.capabilities, this, client);
    }

    @Override
    public String getResourceVersion() {
        return this.asString("metadata.resourceVersion");
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.asMap("metadata");
    }

    @Override
    public <T extends ICapability> T getCapability(Class<T> capability) {
        return (T)this.capabilities.get(capability);
    }

    @Override
    public Set<Class<? extends ICapability>> getCapabilities() {
        return Collections.unmodifiableSet(this.capabilities.keySet());
    }

    protected Map<Class<? extends ICapability>, ICapability> getModifiableCapabilities() {
        return this.capabilities;
    }

    @Override
    public boolean supports(Class<? extends ICapability> capability) {
        return this.capabilities.containsKey(capability);
    }

    @Override
    public <T extends ICapability, R> R accept(CapabilityVisitor<T, R> visitor, R unsupportedValue) {
        if (this.capabilities.containsKey(visitor.getCapabilityType())) {
            ICapability capability = this.capabilities.get(visitor.getCapabilityType());
            return visitor.visit(capability);
        }
        return unsupportedValue;
    }

    @Override
    public IProject getProject() {
        if (this.project == null) {
            this.project = (IProject)this.client.get("Project", this.getNamespaceName(), "");
        }
        return this.project;
    }

    @Override
    public INamespace getNamespace() {
        if (this.namespace == null) {
            this.namespace = (INamespace)this.client.get("Namespace", this.getNamespaceName(), "");
        }
        return this.namespace;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.asMap("metadata.annotations");
    }

    @Override
    public String getAnnotation(String key) {
        return this.getAnnotations().get(key);
    }

    @Override
    public void setAnnotation(String name, String value) {
        if (value == null) {
            return;
        }
        ModelNode annotations = this.get("metadata.annotations");
        annotations.get(name).set(value);
    }

    @Override
    public void removeAnnotation(String name) {
        ModelNode annotations = this.get("metadata.annotations");
        annotations.remove(name);
    }

    @Override
    public boolean isAnnotatedWith(String key) {
        Map<String, String> annotations = this.getAnnotations();
        return annotations.containsKey(key);
    }

    public Map<String, String[]> getPropertyKeys() {
        return this.propertyKeys;
    }

    public IClient getClient() {
        return this.client;
    }

    public void setNode(ModelNode node) {
        this.node = node.clone();
    }

    public ModelNode getNode() {
        return this.node;
    }

    public void refresh() {
        this.node = ModelNode.fromJSONString((String)this.client.get(this.getKind(), this.getName(), this.getNamespaceName()).toString());
    }

    @Override
    public String getKind() {
        return this.asString("kind");
    }

    @Override
    public String getApiVersion() {
        return this.asString("apiVersion");
    }

    @Override
    public String getCreationTimeStamp() {
        return this.asString("metadata.creationTimestamp");
    }

    @Override
    public String getName() {
        return this.asString("metadata.name");
    }

    public void setName(String name) {
        this.set("metadata.name", name);
    }

    @Override
    public String getNamespaceName() {
        return this.asString("metadata.namespace");
    }

    public void setNamespace(String namespace) {
        this.set("metadata.namespace", namespace);
    }

    @Override
    public void addLabel(String key, String value) {
        ModelNode labels = this.node.get(this.getPath("metadata.labels"));
        labels.get(key).set(value);
    }

    @Override
    public Map<String, String> getLabels() {
        return this.asMap("metadata.labels");
    }

    protected boolean has(String key) {
        return this.node.has(this.getPath(key));
    }

    protected ModelNode get(String key) {
        return this.get(this.node, key);
    }

    protected ModelNode get(ModelNode node, String key) {
        return node.get(this.getPath(key));
    }

    protected Map<String, String> getEnvMap(String key) {
        HashMap<String, String> values = new HashMap<String, String>();
        ModelNode source = this.node.get(this.getPath(key));
        if (source.getType() == ModelType.LIST) {
            for (ModelNode value : source.asList()) {
                values.put(value.get("name").asString(), value.get("value").asString());
            }
        }
        return values;
    }

    protected void set(String key, Map<String, String> values) {
        JBossDmrExtentions.set(this.node, this.propertyKeys, key, values);
    }

    protected void set(String key, int value) {
        JBossDmrExtentions.set(this.node, this.propertyKeys, key, value);
    }

    protected void set(ModelNode node, String key, int value) {
        JBossDmrExtentions.set(node, this.propertyKeys, key, value);
    }

    protected void set(String key, String value) {
        JBossDmrExtentions.set(this.node, this.propertyKeys, key, value);
    }

    protected void set(ModelNode node, String key, String value) {
        JBossDmrExtentions.set(node, this.propertyKeys, key, value);
    }

    protected void set(String key, boolean value) {
        JBossDmrExtentions.set(this.node, this.propertyKeys, key, value);
    }

    protected void set(ModelNode node, String key, boolean value) {
        JBossDmrExtentions.set(node, this.propertyKeys, key, value);
    }

    protected void set(String property, Set<String> values) {
        JBossDmrExtentions.set(this.node, this.propertyKeys, property, values);
    }

    protected void set(String property, String ... values) {
        JBossDmrExtentions.set(this.node, this.propertyKeys, property, values);
    }

    protected void setEnvMap(String key, Map<String, String> values) {
        ModelNode mapNodeParent = this.node.get(this.getPath(key));
        for (Map.Entry<String, String> value : values.entrySet()) {
            ModelNode mapNode = mapNodeParent.add();
            mapNode.get("name").set(value.getKey());
            mapNode.get("value").set(value.getValue());
        }
    }

    protected String[] getPath(String key) {
        return JBossDmrExtentions.getPath(this.propertyKeys, key);
    }

    protected String asString(ModelNode node, String subKey) {
        return JBossDmrExtentions.asString(node, this.propertyKeys, subKey);
    }

    protected String asString(String property) {
        return JBossDmrExtentions.asString(this.node, this.propertyKeys, property);
    }

    protected int asInt(String key) {
        return JBossDmrExtentions.asInt(this.node, this.propertyKeys, key);
    }

    protected int asInt(ModelNode node, String key) {
        return JBossDmrExtentions.asInt(node, this.propertyKeys, key);
    }

    protected Map<String, String> asMap(String property) {
        return JBossDmrExtentions.asMap(this.node, this.propertyKeys, property);
    }

    protected boolean asBoolean(ModelNode node, String property) {
        return JBossDmrExtentions.asBoolean(node, this.propertyKeys, property);
    }

    protected boolean asBoolean(String property) {
        return JBossDmrExtentions.asBoolean(this.node, this.propertyKeys, property);
    }

    protected Set asSet(String property, ModelType type) {
        return JBossDmrExtentions.asSet(this.node, this.propertyKeys, property, type);
    }

    public String toString() {
        return this.toJson(true);
    }

    public String toPrettyString() {
        return this.toJson(false);
    }

    public int hashCode() {
        String namespace = this.getNamespaceName();
        String name = this.getName();
        String kind = this.getKind();
        int prime = 31;
        return 31 * (namespace.hashCode() + name.hashCode() + kind.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KubernetesResource other = (KubernetesResource)obj;
        if (this.getKind() != null ? !this.getKind().equals(other.getKind()) : other.getKind() != null) {
            return false;
        }
        if (this.getNamespaceName() != null ? !this.getNamespaceName().equals(other.getNamespaceName()) : other.getNamespaceName() != null) {
            return false;
        }
        return !(this.getName() != null ? !this.getName().equals(other.getName()) : other.getName() != null);
    }

    @Override
    public String toJson() {
        return this.toJson(false);
    }

    @Override
    public String toJson(boolean compact) {
        return JBossDmrExtentions.toJsonString(this.node, compact);
    }
}

