/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.Immutable;
import com.palantir.javaformat.BreakBehaviours;
import java.io.IOException;
import org.derive4j.ArgOption;
import org.derive4j.Data;

@Immutable
@JsonSerialize(using=Json.class)
@Data(arguments={ArgOption.checkedNotNull})
public abstract class BreakBehaviour {
    public abstract <R> R match(Cases<R> var1);

    public abstract String toString();

    static class Json
    extends JsonSerializer<BreakBehaviour> {
        Json() {
        }

        public void serialize(BreakBehaviour value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            BreakBehaviours.caseOf(value).breakThisLevel(() -> {
                try {
                    gen.writeObjectField("type", (Object)"breakThisLevel");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }).preferBreakingLastInnerLevel(keepIndentWhenInlined -> {
                try {
                    gen.writeObjectField("type", (Object)"preferBreakingLastInnerLevel");
                    gen.writeObjectField("keepIndentWhenInlined", keepIndentWhenInlined);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }).inlineSuffix(() -> {
                try {
                    gen.writeObjectField("type", (Object)"inlineSuffix");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }).breakOnlyIfInnerLevelsThenFitOnOneLine(keepIndentWhenInlined -> {
                try {
                    gen.writeObjectField("type", (Object)"breakOnlyIfInnerLevelsThenFitOnOneLine");
                    gen.writeObjectField("keepIndentWhenInlined", keepIndentWhenInlined);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
            gen.writeEndObject();
        }
    }

    public static interface Cases<R> {
        public R breakThisLevel();

        public R preferBreakingLastInnerLevel(boolean var1);

        public R inlineSuffix();

        public R breakOnlyIfInnerLevelsThenFitOnOneLine(boolean var1);
    }
}

