/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.google.common.base.Preconditions;
import com.palantir.javaformat.PartialInlineability;
import com.palantir.javaformat.doc.Break;
import com.palantir.javaformat.doc.Comment;
import com.palantir.javaformat.doc.Doc;
import com.palantir.javaformat.doc.DocVisitor;
import com.palantir.javaformat.doc.Level;
import com.palantir.javaformat.doc.NonBreakingSpace;
import com.palantir.javaformat.doc.StartsWithBreakVisitor;
import com.palantir.javaformat.doc.State;
import com.palantir.javaformat.doc.Token;
import java.util.List;
import java.util.OptionalInt;

class CountWidthUntilBreakVisitor
implements DocVisitor<Float> {
    private final int availableWidth;

    public CountWidthUntilBreakVisitor(int availableWidth) {
        this.availableWidth = availableWidth;
    }

    @Override
    public Float visitSpace(NonBreakingSpace doc) {
        return Float.valueOf(doc.getWidth());
    }

    @Override
    public Float visitComment(Comment doc) {
        return Float.valueOf(doc.getWidth());
    }

    @Override
    public Float visitToken(Token doc) {
        return Float.valueOf(doc.getWidth());
    }

    @Override
    public Float visitBreak(Break doc) {
        return Float.valueOf(doc.getWidth());
    }

    @Override
    public Float visitLevel(Level level) {
        if (level.partialInlineability() == PartialInlineability.IF_FIRST_LEVEL_FITS && level.getDocs().get(0).getWidth() <= (float)this.availableWidth) {
            return Float.valueOf(level.getDocs().get(0).getWidth());
        }
        OptionalInt found = CountWidthUntilBreakVisitor.getFirstNonEmptyLevel(level.getDocs());
        if (found.isPresent()) {
            return (Float)this.visit(level.getDocs().get(found.getAsInt()));
        }
        Preconditions.checkState((StartsWithBreakVisitor.INSTANCE.visit(level) == StartsWithBreakVisitor.Result.YES ? 1 : 0) != 0, (String)"Didn't find expected break at the beginning of level.\n%s", (Object)level.representation(State.startingState()));
        return Float.valueOf(0.0f);
    }

    private static OptionalInt getFirstNonEmptyLevel(List<Doc> docs) {
        int idx = 0;
        for (Doc doc : docs) {
            if (!(doc instanceof Level)) break;
            if (StartsWithBreakVisitor.INSTANCE.visit(doc) != StartsWithBreakVisitor.Result.EMPTY) {
                return OptionalInt.of(idx);
            }
            ++idx;
        }
        return OptionalInt.empty();
    }
}

