/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.javaformat.doc.Break;
import com.palantir.javaformat.doc.BreakTag;
import com.palantir.javaformat.doc.Comment;
import com.palantir.javaformat.doc.Level;
import com.palantir.javaformat.doc.State;
import fj.data.Set;
import fj.data.TreeMap;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="State", generator="Immutables")
@Immutable
public final class ImmutableState
extends State {
    private final int lastIndent;
    private final int indent;
    private final int column;
    private final boolean mustBreak;
    private final int numLines;
    private final int branchingCoefficient;
    private final Set<BreakTag> breakTagsTaken;
    private final TreeMap<Break, State.BreakState> breakStates;
    private final TreeMap<Level, State.LevelState> levelStates;
    private final TreeMap<Comment, State.TokState> tokStates;

    private ImmutableState(int lastIndent, int indent, int column, boolean mustBreak, int numLines, int branchingCoefficient, Set<BreakTag> breakTagsTaken, TreeMap<Break, State.BreakState> breakStates, TreeMap<Level, State.LevelState> levelStates, TreeMap<Comment, State.TokState> tokStates) {
        this.lastIndent = lastIndent;
        this.indent = indent;
        this.column = column;
        this.mustBreak = mustBreak;
        this.numLines = numLines;
        this.branchingCoefficient = branchingCoefficient;
        this.breakTagsTaken = breakTagsTaken;
        this.breakStates = breakStates;
        this.levelStates = levelStates;
        this.tokStates = tokStates;
    }

    @Override
    @JsonProperty(value="lastIndent")
    public int lastIndent() {
        return this.lastIndent;
    }

    @Override
    @JsonProperty(value="indent")
    public int indent() {
        return this.indent;
    }

    @Override
    @JsonProperty(value="column")
    public int column() {
        return this.column;
    }

    @Override
    @JsonProperty(value="mustBreak")
    public boolean mustBreak() {
        return this.mustBreak;
    }

    @Override
    @JsonProperty(value="numLines")
    public int numLines() {
        return this.numLines;
    }

    @Override
    @JsonProperty(value="branchingCoefficient")
    public int branchingCoefficient() {
        return this.branchingCoefficient;
    }

    @Override
    @JsonProperty(value="breakTagsTaken")
    @JsonIgnore
    protected Set<BreakTag> breakTagsTaken() {
        return this.breakTagsTaken;
    }

    @Override
    @JsonProperty(value="breakStates")
    @JsonIgnore
    protected TreeMap<Break, State.BreakState> breakStates() {
        return this.breakStates;
    }

    @Override
    @JsonProperty(value="levelStates")
    @JsonIgnore
    protected TreeMap<Level, State.LevelState> levelStates() {
        return this.levelStates;
    }

    @Override
    @JsonProperty(value="tokStates")
    @JsonIgnore
    protected TreeMap<Comment, State.TokState> tokStates() {
        return this.tokStates;
    }

    public final ImmutableState withLastIndent(int value) {
        if (this.lastIndent == value) {
            return this;
        }
        return new ImmutableState(value, this.indent, this.column, this.mustBreak, this.numLines, this.branchingCoefficient, this.breakTagsTaken, this.breakStates, this.levelStates, this.tokStates);
    }

    public final ImmutableState withIndent(int value) {
        if (this.indent == value) {
            return this;
        }
        return new ImmutableState(this.lastIndent, value, this.column, this.mustBreak, this.numLines, this.branchingCoefficient, this.breakTagsTaken, this.breakStates, this.levelStates, this.tokStates);
    }

    @Override
    public final ImmutableState withColumn(int value) {
        if (this.column == value) {
            return this;
        }
        return new ImmutableState(this.lastIndent, this.indent, value, this.mustBreak, this.numLines, this.branchingCoefficient, this.breakTagsTaken, this.breakStates, this.levelStates, this.tokStates);
    }

    @Override
    public final ImmutableState withMustBreak(boolean value) {
        if (this.mustBreak == value) {
            return this;
        }
        return new ImmutableState(this.lastIndent, this.indent, this.column, value, this.numLines, this.branchingCoefficient, this.breakTagsTaken, this.breakStates, this.levelStates, this.tokStates);
    }

    public final ImmutableState withNumLines(int value) {
        if (this.numLines == value) {
            return this;
        }
        return new ImmutableState(this.lastIndent, this.indent, this.column, this.mustBreak, value, this.branchingCoefficient, this.breakTagsTaken, this.breakStates, this.levelStates, this.tokStates);
    }

    public final ImmutableState withBranchingCoefficient(int value) {
        if (this.branchingCoefficient == value) {
            return this;
        }
        return new ImmutableState(this.lastIndent, this.indent, this.column, this.mustBreak, this.numLines, value, this.breakTagsTaken, this.breakStates, this.levelStates, this.tokStates);
    }

    public final ImmutableState withBreakTagsTaken(Set<BreakTag> value) {
        if (this.breakTagsTaken == value) {
            return this;
        }
        Set<BreakTag> newValue = Objects.requireNonNull(value, "breakTagsTaken");
        return new ImmutableState(this.lastIndent, this.indent, this.column, this.mustBreak, this.numLines, this.branchingCoefficient, newValue, this.breakStates, this.levelStates, this.tokStates);
    }

    public final ImmutableState withBreakStates(TreeMap<Break, State.BreakState> value) {
        if (this.breakStates == value) {
            return this;
        }
        TreeMap<Break, State.BreakState> newValue = Objects.requireNonNull(value, "breakStates");
        return new ImmutableState(this.lastIndent, this.indent, this.column, this.mustBreak, this.numLines, this.branchingCoefficient, this.breakTagsTaken, newValue, this.levelStates, this.tokStates);
    }

    public final ImmutableState withLevelStates(TreeMap<Level, State.LevelState> value) {
        if (this.levelStates == value) {
            return this;
        }
        TreeMap<Level, State.LevelState> newValue = Objects.requireNonNull(value, "levelStates");
        return new ImmutableState(this.lastIndent, this.indent, this.column, this.mustBreak, this.numLines, this.branchingCoefficient, this.breakTagsTaken, this.breakStates, newValue, this.tokStates);
    }

    public final ImmutableState withTokStates(TreeMap<Comment, State.TokState> value) {
        if (this.tokStates == value) {
            return this;
        }
        TreeMap<Comment, State.TokState> newValue = Objects.requireNonNull(value, "tokStates");
        return new ImmutableState(this.lastIndent, this.indent, this.column, this.mustBreak, this.numLines, this.branchingCoefficient, this.breakTagsTaken, this.breakStates, this.levelStates, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableState && this.equalTo(0, (ImmutableState)another);
    }

    private boolean equalTo(int synthetic, ImmutableState another) {
        return this.lastIndent == another.lastIndent && this.indent == another.indent && this.column == another.column && this.mustBreak == another.mustBreak && this.numLines == another.numLines && this.branchingCoefficient == another.branchingCoefficient;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.lastIndent;
        h += (h << 5) + this.indent;
        h += (h << 5) + this.column;
        h += (h << 5) + Booleans.hashCode((boolean)this.mustBreak);
        h += (h << 5) + this.numLines;
        h += (h << 5) + this.branchingCoefficient;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"State").omitNullValues().add("lastIndent", this.lastIndent).add("indent", this.indent).add("column", this.column).add("mustBreak", this.mustBreak).add("numLines", this.numLines).add("branchingCoefficient", this.branchingCoefficient).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableState fromJson(Json json) {
        State.Builder builder = new State.Builder();
        if (json.lastIndentIsSet) {
            builder.lastIndent(json.lastIndent);
        }
        if (json.indentIsSet) {
            builder.indent(json.indent);
        }
        if (json.columnIsSet) {
            builder.column(json.column);
        }
        if (json.mustBreakIsSet) {
            builder.mustBreak(json.mustBreak);
        }
        if (json.numLinesIsSet) {
            builder.numLines(json.numLines);
        }
        if (json.branchingCoefficientIsSet) {
            builder.branchingCoefficient(json.branchingCoefficient);
        }
        if (json.breakTagsTaken != null) {
            builder.breakTagsTaken(json.breakTagsTaken);
        }
        if (json.breakStates != null) {
            builder.breakStates(json.breakStates);
        }
        if (json.levelStates != null) {
            builder.levelStates(json.levelStates);
        }
        if (json.tokStates != null) {
            builder.tokStates(json.tokStates);
        }
        return (ImmutableState)builder.build();
    }

    public static State copyOf(State instance) {
        if (instance instanceof ImmutableState) {
            return (ImmutableState)instance;
        }
        return new State.Builder().from(instance).build();
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="State", generator="Immutables")
    static final class Json
    extends State {
        int lastIndent;
        boolean lastIndentIsSet;
        int indent;
        boolean indentIsSet;
        int column;
        boolean columnIsSet;
        boolean mustBreak;
        boolean mustBreakIsSet;
        int numLines;
        boolean numLinesIsSet;
        int branchingCoefficient;
        boolean branchingCoefficientIsSet;
        @Nullable
        Set<BreakTag> breakTagsTaken;
        @Nullable
        TreeMap<Break, State.BreakState> breakStates;
        @Nullable
        TreeMap<Level, State.LevelState> levelStates;
        @Nullable
        TreeMap<Comment, State.TokState> tokStates;

        Json() {
        }

        @JsonProperty(value="lastIndent")
        public void setLastIndent(int lastIndent) {
            this.lastIndent = lastIndent;
            this.lastIndentIsSet = true;
        }

        @JsonProperty(value="indent")
        public void setIndent(int indent) {
            this.indent = indent;
            this.indentIsSet = true;
        }

        @JsonProperty(value="column")
        public void setColumn(int column) {
            this.column = column;
            this.columnIsSet = true;
        }

        @JsonProperty(value="mustBreak")
        public void setMustBreak(boolean mustBreak) {
            this.mustBreak = mustBreak;
            this.mustBreakIsSet = true;
        }

        @JsonProperty(value="numLines")
        public void setNumLines(int numLines) {
            this.numLines = numLines;
            this.numLinesIsSet = true;
        }

        @JsonProperty(value="branchingCoefficient")
        public void setBranchingCoefficient(int branchingCoefficient) {
            this.branchingCoefficient = branchingCoefficient;
            this.branchingCoefficientIsSet = true;
        }

        @JsonProperty(value="breakTagsTaken")
        @JsonIgnore
        public void setBreakTagsTaken(Set<BreakTag> breakTagsTaken) {
            this.breakTagsTaken = breakTagsTaken;
        }

        @JsonProperty(value="breakStates")
        @JsonIgnore
        public void setBreakStates(TreeMap<Break, State.BreakState> breakStates) {
            this.breakStates = breakStates;
        }

        @JsonProperty(value="levelStates")
        @JsonIgnore
        public void setLevelStates(TreeMap<Level, State.LevelState> levelStates) {
            this.levelStates = levelStates;
        }

        @JsonProperty(value="tokStates")
        @JsonIgnore
        public void setTokStates(TreeMap<Comment, State.TokState> tokStates) {
            this.tokStates = tokStates;
        }

        @Override
        public int lastIndent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int column() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mustBreak() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int numLines() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int branchingCoefficient() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Set<BreakTag> breakTagsTaken() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected TreeMap<Break, State.BreakState> breakStates() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected TreeMap<Level, State.LevelState> levelStates() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected TreeMap<Comment, State.TokState> tokStates() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="State", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_LAST_INDENT = 1L;
        private static final long INIT_BIT_INDENT = 2L;
        private static final long INIT_BIT_COLUMN = 4L;
        private static final long INIT_BIT_MUST_BREAK = 8L;
        private static final long INIT_BIT_NUM_LINES = 16L;
        private static final long INIT_BIT_BRANCHING_COEFFICIENT = 32L;
        private static final long INIT_BIT_BREAK_TAGS_TAKEN = 64L;
        private static final long INIT_BIT_BREAK_STATES = 128L;
        private static final long INIT_BIT_LEVEL_STATES = 256L;
        private static final long INIT_BIT_TOK_STATES = 512L;
        private long initBits = 1023L;
        private int lastIndent;
        private int indent;
        private int column;
        private boolean mustBreak;
        private int numLines;
        private int branchingCoefficient;
        @Nullable
        private Set<BreakTag> breakTagsTaken;
        @Nullable
        private TreeMap<Break, State.BreakState> breakStates;
        @Nullable
        private TreeMap<Level, State.LevelState> levelStates;
        @Nullable
        private TreeMap<Comment, State.TokState> tokStates;

        public Builder() {
            if (!(this instanceof State.Builder)) {
                throw new UnsupportedOperationException("Use: new State.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final State.Builder from(State instance) {
            Objects.requireNonNull(instance, "instance");
            this.lastIndent(instance.lastIndent());
            this.indent(instance.indent());
            this.column(instance.column());
            this.mustBreak(instance.mustBreak());
            this.numLines(instance.numLines());
            this.branchingCoefficient(instance.branchingCoefficient());
            this.breakTagsTaken(instance.breakTagsTaken());
            this.breakStates(instance.breakStates());
            this.levelStates(instance.levelStates());
            this.tokStates(instance.tokStates());
            return (State.Builder)this;
        }

        @CanIgnoreReturnValue
        public final State.Builder lastIndent(int lastIndent) {
            this.lastIndent = lastIndent;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (State.Builder)this;
        }

        @CanIgnoreReturnValue
        public final State.Builder indent(int indent) {
            this.indent = indent;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (State.Builder)this;
        }

        @CanIgnoreReturnValue
        public final State.Builder column(int column) {
            this.column = column;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (State.Builder)this;
        }

        @CanIgnoreReturnValue
        public final State.Builder mustBreak(boolean mustBreak) {
            this.mustBreak = mustBreak;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (State.Builder)this;
        }

        @CanIgnoreReturnValue
        public final State.Builder numLines(int numLines) {
            this.numLines = numLines;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (State.Builder)this;
        }

        @CanIgnoreReturnValue
        public final State.Builder branchingCoefficient(int branchingCoefficient) {
            this.branchingCoefficient = branchingCoefficient;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return (State.Builder)this;
        }

        @CanIgnoreReturnValue
        public final State.Builder breakTagsTaken(Set<BreakTag> breakTagsTaken) {
            this.breakTagsTaken = Objects.requireNonNull(breakTagsTaken, "breakTagsTaken");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return (State.Builder)this;
        }

        @CanIgnoreReturnValue
        public final State.Builder breakStates(TreeMap<Break, State.BreakState> breakStates) {
            this.breakStates = Objects.requireNonNull(breakStates, "breakStates");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return (State.Builder)this;
        }

        @CanIgnoreReturnValue
        public final State.Builder levelStates(TreeMap<Level, State.LevelState> levelStates) {
            this.levelStates = Objects.requireNonNull(levelStates, "levelStates");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return (State.Builder)this;
        }

        @CanIgnoreReturnValue
        public final State.Builder tokStates(TreeMap<Comment, State.TokState> tokStates) {
            this.tokStates = Objects.requireNonNull(tokStates, "tokStates");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return (State.Builder)this;
        }

        public State build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableState(this.lastIndent, this.indent, this.column, this.mustBreak, this.numLines, this.branchingCoefficient, this.breakTagsTaken, this.breakStates, this.levelStates, this.tokStates);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lastIndent");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("indent");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("column");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("mustBreak");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("numLines");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("branchingCoefficient");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("breakTagsTaken");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("breakStates");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("levelStates");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("tokStates");
            }
            return "Cannot build State, some of required attributes are not set " + attributes;
        }
    }
}

