/**
 * Copyright 2008 Perforce Software Inc., All Rights Reserved.
 */
package com.perforce.p4java.exception;

/**
 * Superclass for all P4Java-generated exceptions. Such exceptions are used
 * for at least potentially-catchable errors; things corresponding more to panic
 * situations are normally signaled by P4JavaError subclasses.
 * <p>
 * 
 * Unless otherwise noted, all exceptions thrown across PJava's public methods
 * and interfaces are a subclass of this class or the associated P4JavaError class;
 * this means any OS or JVM (etc.) exceptions are wrapped in a suitable subclass.<p>
 * 
 * P4JavaException error messages are deliberately not internationalized or localized:
 * in general, almost all end-user-visible error messages are generated by the underlying
 * Perforce server; these are simply wrapped and passed-through as-is (and will be
 * localised if they were localised on the server). All other error messages are
 * either wrapped OS messages (which will be internationalized if the OS internationalized
 * them) or a very limited set of English error messages from within P4Java itself. Since
 * this latter set is tiny, it has been left in the en/us locale, but this can be changed
 * if there's enough demand.
 * 
 *
 */

public class P4JavaException extends Exception {
	
	private static final long serialVersionUID = 1L;

	public P4JavaException() {
		super();
	}

	public P4JavaException(String message, Throwable cause) {
		super(message, cause);
	}

	public P4JavaException(String message) {
		super(message);
	}

	public P4JavaException(Throwable cause) {
		super(cause);
	}
}
