/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public final class ClassPathUtils {
    public static Set<Class<?>> scanPackage(ClassLoader classLoader, Package pkg) throws IOException {
        return ClassPathUtils.scanPackage(classLoader, pkg.getName());
    }

    public static Set<Class<?>> scanPackage(ClassLoader classLoader, String pkg) throws IOException {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[]{classLoader})).addClassLoader(classLoader).filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{pkg})).setScanners(new Scanner[]{new SubTypesScanner(false)}));
        HashSet classes = new HashSet();
        for (String typeNames : reflections.getStore().get(SubTypesScanner.class.getSimpleName()).values()) {
            Class<?> clazz = ClassPathUtils.safeClassForName(classLoader, typeNames);
            if (clazz == null) continue;
            classes.add(clazz);
        }
        return classes;
    }

    public static Class<?> safeClassForName(ClassLoader classLoader, String className) {
        try {
            if (className.startsWith("com.sun.") || className.startsWith("com.apple.")) {
                return null;
            }
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    private ClassPathUtils() {
    }
}

