/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionBase;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class QList
extends FactoryExpressionBase<List<?>> {
    private static final long serialVersionUID = -7545994090073480810L;
    private final @Unmodifiable List<Expression<?>> args;

    protected QList(Expression<?> ... args) {
        super(List.class);
        this.args = CollectionUtils.unmodifiableList(Arrays.asList(args));
    }

    protected QList(List<Expression<?>> args) {
        super(List.class);
        this.args = CollectionUtils.unmodifiableList(args);
    }

    protected QList(Expression<?>[] ... args) {
        super(List.class);
        ArrayList builder = new ArrayList();
        for (Expression<?>[] exprs : args) {
            Collections.addAll(builder, exprs);
        }
        this.args = CollectionUtils.unmodifiableList(builder);
    }

    @Override
    @Nullable
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    @Override
    public @Unmodifiable List<Expression<?>> getArgs() {
        return this.args;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FactoryExpression) {
            FactoryExpression c = (FactoryExpression)obj;
            return this.args.equals(c.getArgs()) && this.getType().equals(c.getType());
        }
        return false;
    }

    @Override
    @Nullable
    public List<?> newInstance(Object ... args) {
        return Collections.unmodifiableList(Arrays.asList(args));
    }
}

