/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.mongodb.document;

import com.mongodb.ReadPreference;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.SimpleQuery;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CollectionPathBase;
import com.querydsl.mongodb.document.AnyEmbeddedBuilder;
import com.querydsl.mongodb.document.JoinBuilder;
import com.querydsl.mongodb.document.MongodbDocumentSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bson.Document;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMongodbQuery<Q extends AbstractMongodbQuery<Q>>
implements SimpleQuery<Q> {
    private final MongodbDocumentSerializer serializer;
    private final QueryMixin<Q> queryMixin;
    private ReadPreference readPreference;

    public AbstractMongodbQuery(MongodbDocumentSerializer serializer) {
        AbstractMongodbQuery query = this;
        this.queryMixin = new QueryMixin((Object)query, (QueryMetadata)new DefaultQueryMetadata(), false);
        this.serializer = serializer;
    }

    public <T> JoinBuilder<Q, T> join(Path<T> ref, Path<T> target) {
        return new JoinBuilder<Q, T>(this.queryMixin, ref, target);
    }

    public <T> JoinBuilder<Q, T> join(CollectionPathBase<?, T, ?> ref, Path<T> target) {
        return new JoinBuilder<Q, T>(this.queryMixin, (Path<?>)ref, target);
    }

    public <T> AnyEmbeddedBuilder<Q> anyEmbedded(Path<? extends Collection<T>> collection, Path<T> target) {
        return new AnyEmbeddedBuilder<Q>(this.queryMixin, collection);
    }

    @Nullable
    protected Predicate createFilter(QueryMetadata metadata) {
        Predicate filter = !metadata.getJoins().isEmpty() ? ExpressionUtils.allOf((Predicate[])new Predicate[]{metadata.getWhere(), this.createJoinFilter(metadata)}) : metadata.getWhere();
        return filter;
    }

    @Nullable
    protected Predicate createJoinFilter(QueryMetadata metadata) {
        HashMap<Path, Predicate> predicates = new HashMap<Path, Predicate>();
        List joins = metadata.getJoins();
        for (int i = joins.size() - 1; i >= 0; --i) {
            JoinExpression join = (JoinExpression)joins.get(i);
            Path source = (Path)((Operation)join.getTarget()).getArg(0);
            Path target = (Path)((Operation)join.getTarget()).getArg(1);
            Predicate extraFilters = (Predicate)predicates.get(target.getRoot());
            Predicate filter = ExpressionUtils.allOf((Predicate[])new Predicate[]{join.getCondition(), extraFilters});
            List<Object> ids = this.getIds(target.getType(), filter);
            if (ids.isEmpty()) {
                throw new NoResults();
            }
            Path path = ExpressionUtils.path(String.class, (Path)source, (String)"$id");
            predicates.merge(source.getRoot(), ExpressionUtils.in((Expression)path, ids), ExpressionUtils::and);
        }
        Path source = (Path)((Operation)((JoinExpression)joins.get(0)).getTarget()).getArg(0);
        return (Predicate)predicates.get(source.getRoot());
    }

    private Predicate allOf(Collection<Predicate> predicates) {
        return predicates != null ? ExpressionUtils.allOf(predicates) : null;
    }

    protected abstract List<Object> getIds(Class<?> var1, Predicate var2);

    public Q distinct() {
        return (Q)((AbstractMongodbQuery)this.queryMixin.distinct());
    }

    public Q where(Predicate e) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.where(e));
    }

    public Q where(Predicate ... e) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.where(e));
    }

    public Q limit(long limit) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.limit(limit));
    }

    public Q offset(long offset) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.offset(offset));
    }

    public Q restrict(QueryModifiers modifiers) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.restrict(modifiers));
    }

    public Q orderBy(OrderSpecifier<?> o) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.orderBy(o));
    }

    public Q orderBy(OrderSpecifier<?> ... o) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.orderBy(o));
    }

    public <T> Q set(ParamExpression<T> param, T value) {
        return (Q)((AbstractMongodbQuery)this.queryMixin.set(param, value));
    }

    protected Document createProjection(Expression<?> projection) {
        if (projection instanceof FactoryExpression) {
            Document obj = new Document();
            for (Object expr : ((FactoryExpression)projection).getArgs()) {
                if (!(expr instanceof Expression)) continue;
                obj.put((String)this.serializer.handle((Expression)expr), (Object)1);
            }
            return obj;
        }
        return null;
    }

    protected Document createQuery(@Nullable Predicate predicate) {
        if (predicate != null) {
            return (Document)this.serializer.handle((Expression<?>)predicate);
        }
        return new Document();
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    protected QueryMixin<Q> getQueryMixin() {
        return this.queryMixin;
    }

    protected MongodbDocumentSerializer getSerializer() {
        return this.serializer;
    }

    protected ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public Document asDocument() {
        return this.createQuery(this.queryMixin.getMetadata().getWhere());
    }

    public String toString() {
        return this.asDocument().toString();
    }

    static class NoResults
    extends RuntimeException {
        NoResults() {
        }
    }
}

