/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.impl.AbstractMetricsCollector;

public class StandardMetricsCollector
extends AbstractMetricsCollector {
    private final MetricRegistry registry;
    private final Counter connections;
    private final Counter channels;
    private final Meter publishedMessages;
    private final Meter consumedMessages;
    private final Meter acknowledgedMessages;
    private final Meter rejectedMessages;

    public StandardMetricsCollector(MetricRegistry registry, String metricsPrefix) {
        this.registry = registry;
        this.connections = registry.counter(metricsPrefix + ".connections");
        this.channels = registry.counter(metricsPrefix + ".channels");
        this.publishedMessages = registry.meter(metricsPrefix + ".published");
        this.consumedMessages = registry.meter(metricsPrefix + ".consumed");
        this.acknowledgedMessages = registry.meter(metricsPrefix + ".acknowledged");
        this.rejectedMessages = registry.meter(metricsPrefix + ".rejected");
    }

    public StandardMetricsCollector() {
        this(new MetricRegistry());
    }

    public StandardMetricsCollector(MetricRegistry metricRegistry) {
        this(metricRegistry, "rabbitmq");
    }

    @Override
    protected void incrementConnectionCount(Connection connection) {
        this.connections.inc();
    }

    @Override
    protected void decrementConnectionCount(Connection connection) {
        this.connections.dec();
    }

    @Override
    protected void incrementChannelCount(Channel channel) {
        this.channels.inc();
    }

    @Override
    protected void decrementChannelCount(Channel channel) {
        this.channels.dec();
    }

    @Override
    protected void markPublishedMessage() {
        this.publishedMessages.mark();
    }

    @Override
    protected void markConsumedMessage() {
        this.consumedMessages.mark();
    }

    @Override
    protected void markAcknowledgedMessage() {
        this.acknowledgedMessages.mark();
    }

    @Override
    protected void markRejectedMessage() {
        this.rejectedMessages.mark();
    }

    public MetricRegistry getMetricRegistry() {
        return this.registry;
    }

    public Counter getConnections() {
        return this.connections;
    }

    public Counter getChannels() {
        return this.channels;
    }

    public Meter getPublishedMessages() {
        return this.publishedMessages;
    }

    public Meter getConsumedMessages() {
        return this.consumedMessages;
    }

    public Meter getAcknowledgedMessages() {
        return this.acknowledgedMessages;
    }

    public Meter getRejectedMessages() {
        return this.rejectedMessages;
    }
}

