/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class AuthConfig {
    @JsonProperty(value="Username")
    private String username;
    @JsonProperty(value="Password")
    private String password;
    @JsonProperty(value="Email")
    private String email;
    @JsonProperty(value="ServerAddress")
    private String serverAddress;

    private AuthConfig() {
    }

    private AuthConfig(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.email = builder.email;
        this.serverAddress = builder.serverAddress;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String email() {
        return this.email;
    }

    public String serverAddress() {
        return this.serverAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthConfig config = (AuthConfig)o;
        if (this.username != null ? !this.username.equals(config.username) : config.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(config.password) : config.password != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(config.email) : config.email != null) {
            return false;
        }
        return !(this.serverAddress != null ? !this.serverAddress.equals(config.serverAddress) : config.serverAddress != null);
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.serverAddress != null ? this.serverAddress.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("username", (Object)this.username).add("password", (Object)this.password).add("email", (Object)this.email).add("serverAddress", (Object)this.serverAddress).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String username;
        private String password;
        private String email;
        private String serverAddress = "https://index.docker.io/v1/";

        private Builder() {
        }

        private Builder(AuthConfig config) {
            this.username = config.username;
            this.password = config.password;
            this.email = config.email;
            this.serverAddress = config.serverAddress;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public String username() {
            return this.username;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public String password() {
            return this.password;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public String email() {
            return this.email;
        }

        public Builder serverAddress(String serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public String serverAddress() {
            return this.serverAddress;
        }

        public AuthConfig build() {
            return new AuthConfig(this);
        }
    }
}

