/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.spotify.docker.client.messages.PortBinding;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class HostConfig {
    @JsonProperty(value="Binds")
    private ImmutableList<String> binds;
    @JsonProperty(value="ContainerIDFile")
    private String containerIDFile;
    @JsonProperty(value="LxcConf")
    private ImmutableList<LxcConfParameter> lxcConf;
    @JsonProperty(value="Privileged")
    private Boolean privileged;
    @JsonProperty(value="PortBindings")
    private Map<String, List<PortBinding>> portBindings;
    @JsonProperty(value="Links")
    private ImmutableList<String> links;
    @JsonProperty(value="PublishAllPorts")
    private Boolean publishAllPorts;
    @JsonProperty(value="Dns")
    private ImmutableList<String> dns;
    @JsonProperty(value="DnsSearch")
    private ImmutableList<String> dnsSearch;
    @JsonProperty(value="VolumesFrom")
    private ImmutableList<String> volumesFrom;
    @JsonProperty(value="NetworkMode")
    private String networkMode;
    @JsonProperty(value="SecurityOpt")
    private ImmutableList<String> securityOpt;
    @JsonProperty(value="Memory")
    private Long memory;
    @JsonProperty(value="MemorySwap")
    private Long memorySwap;
    @JsonProperty(value="CpuShares")
    private Long cpuShares;
    @JsonProperty(value="CpusetCpus")
    private String cpusetCpus;
    @JsonProperty(value="CgroupParent")
    private String cgroupParent;

    private HostConfig() {
    }

    private HostConfig(Builder builder) {
        this.binds = builder.binds;
        this.containerIDFile = builder.containerIDFile;
        this.lxcConf = builder.lxcConf;
        this.privileged = builder.privileged;
        this.portBindings = builder.portBindings;
        this.links = builder.links;
        this.publishAllPorts = builder.publishAllPorts;
        this.dns = builder.dns;
        this.dnsSearch = builder.dnsSearch;
        this.volumesFrom = builder.volumesFrom;
        this.networkMode = builder.networkMode;
        this.securityOpt = builder.securityOpt;
        this.memory = builder.memory;
        this.memorySwap = builder.memorySwap;
        this.cpuShares = builder.cpuShares;
        this.cpusetCpus = builder.cpusetCpus;
        this.cgroupParent = builder.cgroupParent;
    }

    public List<String> binds() {
        return this.binds;
    }

    public String containerIDFile() {
        return this.containerIDFile;
    }

    public List<LxcConfParameter> lxcConf() {
        return this.lxcConf;
    }

    public Boolean privileged() {
        return this.privileged;
    }

    public Map<String, List<PortBinding>> portBindings() {
        return this.portBindings == null ? null : Collections.unmodifiableMap(this.portBindings);
    }

    public List<String> links() {
        return this.links;
    }

    public Boolean publishAllPorts() {
        return this.publishAllPorts;
    }

    public List<String> dns() {
        return this.dns;
    }

    public List<String> dnsSearch() {
        return this.dnsSearch;
    }

    public List<String> volumesFrom() {
        return this.volumesFrom;
    }

    public String networkMode() {
        return this.networkMode;
    }

    public List<String> securityOpt() {
        return this.securityOpt;
    }

    public Long memory() {
        return this.memory;
    }

    public Long memorySwap() {
        return this.memorySwap;
    }

    public Long cpuShares() {
        return this.cpuShares;
    }

    public String cpusetCpus() {
        return this.cpusetCpus;
    }

    public String cgroupParent() {
        return this.cgroupParent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostConfig that = (HostConfig)o;
        if (this.binds != null ? !this.binds.equals(that.binds) : that.binds != null) {
            return false;
        }
        if (this.containerIDFile != null ? !this.containerIDFile.equals(that.containerIDFile) : that.containerIDFile != null) {
            return false;
        }
        if (this.dns != null ? !this.dns.equals(that.dns) : that.dns != null) {
            return false;
        }
        if (this.dnsSearch != null ? !this.dnsSearch.equals(that.dnsSearch) : that.dnsSearch != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.lxcConf != null ? !this.lxcConf.equals(that.lxcConf) : that.lxcConf != null) {
            return false;
        }
        if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) {
            return false;
        }
        if (this.portBindings != null ? !this.portBindings.equals(that.portBindings) : that.portBindings != null) {
            return false;
        }
        if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) {
            return false;
        }
        if (this.publishAllPorts != null ? !this.publishAllPorts.equals(that.publishAllPorts) : that.publishAllPorts != null) {
            return false;
        }
        if (this.volumesFrom != null ? !this.volumesFrom.equals(that.volumesFrom) : that.volumesFrom != null) {
            return false;
        }
        if (this.securityOpt != null ? !this.securityOpt.equals(that.securityOpt) : that.securityOpt != null) {
            return false;
        }
        if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) {
            return false;
        }
        if (this.memorySwap != null ? !this.memorySwap.equals(that.memorySwap) : that.memorySwap != null) {
            return false;
        }
        if (this.cpuShares != null ? !this.cpuShares.equals(that.cpuShares) : that.cpuShares != null) {
            return false;
        }
        if (this.cpusetCpus != null ? !this.cpusetCpus.equals(that.cpusetCpus) : that.cpusetCpus != null) {
            return false;
        }
        return !(this.cgroupParent != null ? !this.cgroupParent.equals(that.cgroupParent) : that.cgroupParent != null);
    }

    public int hashCode() {
        int result = this.binds != null ? this.binds.hashCode() : 0;
        result = 31 * result + (this.containerIDFile != null ? this.containerIDFile.hashCode() : 0);
        result = 31 * result + (this.lxcConf != null ? this.lxcConf.hashCode() : 0);
        result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
        result = 31 * result + (this.portBindings != null ? this.portBindings.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.publishAllPorts != null ? this.publishAllPorts.hashCode() : 0);
        result = 31 * result + (this.dns != null ? this.dns.hashCode() : 0);
        result = 31 * result + (this.dnsSearch != null ? this.dnsSearch.hashCode() : 0);
        result = 31 * result + (this.volumesFrom != null ? this.volumesFrom.hashCode() : 0);
        result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
        result = 31 * result + (this.securityOpt != null ? this.securityOpt.hashCode() : 0);
        result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
        result = 31 * result + (this.memorySwap != null ? this.memorySwap.hashCode() : 0);
        result = 31 * result + (this.cpuShares != null ? this.cpuShares.hashCode() : 0);
        result = 31 * result + (this.cpusetCpus != null ? this.cpusetCpus.hashCode() : 0);
        result = 31 * result + (this.cgroupParent != null ? this.cgroupParent.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("binds", this.binds).add("containerIDFile", (Object)this.containerIDFile).add("lxcConf", this.lxcConf).add("privileged", (Object)this.privileged).add("portBindings", this.portBindings).add("links", this.links).add("publishAllPorts", (Object)this.publishAllPorts).add("dns", this.dns).add("dnsSearch", this.dnsSearch).add("volumesFrom", this.volumesFrom).add("networkMode", (Object)this.networkMode).add("securityOpt", this.securityOpt).add("memory", (Object)this.memory).add("memorySwap", (Object)this.memorySwap).add("cpuShares", (Object)this.cpuShares).add("cpusetCpus", (Object)this.cpusetCpus).add("cgroupParent", (Object)this.cgroupParent).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableList<String> binds;
        private String containerIDFile;
        private ImmutableList<LxcConfParameter> lxcConf;
        private Boolean privileged;
        private Map<String, List<PortBinding>> portBindings;
        private ImmutableList<String> links;
        private Boolean publishAllPorts;
        private ImmutableList<String> dns;
        private ImmutableList<String> dnsSearch;
        private ImmutableList<String> volumesFrom;
        private String networkMode;
        private ImmutableList<String> securityOpt;
        public Long memory;
        public Long memorySwap;
        public Long cpuShares;
        public String cpusetCpus;
        public String cgroupParent;

        private Builder() {
        }

        private Builder(HostConfig hostConfig) {
            this.binds = hostConfig.binds;
            this.containerIDFile = hostConfig.containerIDFile;
            this.lxcConf = hostConfig.lxcConf;
            this.privileged = hostConfig.privileged;
            this.portBindings = hostConfig.portBindings;
            this.links = hostConfig.links;
            this.publishAllPorts = hostConfig.publishAllPorts;
            this.dns = hostConfig.dns;
            this.dnsSearch = hostConfig.dnsSearch;
            this.volumesFrom = hostConfig.volumesFrom;
            this.networkMode = hostConfig.networkMode;
            this.securityOpt = hostConfig.securityOpt;
            this.memory = hostConfig.memory;
            this.memorySwap = hostConfig.memorySwap;
            this.cpuShares = hostConfig.cpuShares;
            this.cpusetCpus = hostConfig.cpusetCpus;
            this.cgroupParent = hostConfig.cgroupParent;
        }

        public Builder binds(List<String> binds) {
            this.binds = ImmutableList.copyOf(binds);
            return this;
        }

        public Builder binds(String ... binds) {
            this.binds = ImmutableList.copyOf((Object[])binds);
            return this;
        }

        public List<String> binds() {
            return this.binds;
        }

        public Builder containerIDFile(String containerIDFile) {
            this.containerIDFile = containerIDFile;
            return this;
        }

        public String containerIDFile() {
            return this.containerIDFile;
        }

        public Builder lxcConf(List<LxcConfParameter> lxcConf) {
            this.lxcConf = ImmutableList.copyOf(lxcConf);
            return this;
        }

        public Builder lxcConf(LxcConfParameter ... lxcConf) {
            this.lxcConf = ImmutableList.copyOf((Object[])lxcConf);
            return this;
        }

        public List<LxcConfParameter> lxcConf() {
            return this.lxcConf;
        }

        public Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public Boolean privileged() {
            return this.privileged;
        }

        public Builder portBindings(Map<String, List<PortBinding>> portBindings) {
            this.portBindings = portBindings == null ? null : Maps.newHashMap(portBindings);
            return this;
        }

        public Map<String, List<PortBinding>> portBindings() {
            return this.portBindings;
        }

        public Builder links(List<String> links) {
            this.links = ImmutableList.copyOf(links);
            return this;
        }

        public Builder links(String ... links) {
            this.links = ImmutableList.copyOf((Object[])links);
            return this;
        }

        public List<String> links() {
            return this.links;
        }

        public Builder publishAllPorts(Boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        public Boolean publishAllPorts() {
            return this.publishAllPorts;
        }

        public Builder dns(List<String> dns) {
            this.dns = ImmutableList.copyOf(dns);
            return this;
        }

        public Builder dns(String ... dns) {
            this.dns = ImmutableList.copyOf((Object[])dns);
            return this;
        }

        public List<String> dns() {
            return this.dns;
        }

        public Builder dnsSearch(List<String> dnsSearch) {
            this.dnsSearch = ImmutableList.copyOf(dnsSearch);
            return this;
        }

        public Builder dnsSearch(String ... dnsSearch) {
            this.dnsSearch = ImmutableList.copyOf((Object[])dnsSearch);
            return this;
        }

        public List<String> dnsSearch() {
            return this.dnsSearch;
        }

        public Builder volumesFrom(List<String> volumesFrom) {
            this.volumesFrom = ImmutableList.copyOf(volumesFrom);
            return this;
        }

        public Builder volumesFrom(String ... volumesFrom) {
            this.volumesFrom = ImmutableList.copyOf((Object[])volumesFrom);
            return this;
        }

        public List<String> volumesFrom() {
            return this.volumesFrom;
        }

        public Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        public String networkMode() {
            return this.networkMode;
        }

        public Builder securityOpt(String ... securityOpt) {
            this.securityOpt = ImmutableList.copyOf((Object[])securityOpt);
            return this;
        }

        public List<String> securityOpt() {
            return this.securityOpt;
        }

        public Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public Long memory() {
            return this.memory;
        }

        public Builder memorySwap(Long memorySwap) {
            this.memorySwap = memorySwap;
            return this;
        }

        public Long memorySwap() {
            return this.memorySwap;
        }

        public Builder cpuShares(Long cpuShares) {
            this.cpuShares = cpuShares;
            return this;
        }

        public Long cpuShares() {
            return this.cpuShares;
        }

        public Builder cpusetCpus(String cpusetCpus) {
            this.cpusetCpus = cpusetCpus;
            return this;
        }

        public String cpusetCpus() {
            return this.cpusetCpus;
        }

        public Builder cgroupParent(String cgroupParent) {
            this.cgroupParent = cgroupParent;
            return this;
        }

        public String cgroupParent() {
            return this.cgroupParent;
        }

        public HostConfig build() {
            return new HostConfig(this);
        }
    }

    public static class LxcConfParameter {
        @JsonProperty(value="Key")
        private String key;
        @JsonProperty(value="Value")
        private String value;

        public LxcConfParameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LxcConfParameter that = (LxcConfParameter)o;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("value", (Object)this.value).toString();
        }
    }
}

