/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.spotify.docker.client.messages.Device;
import com.spotify.docker.client.messages.LogConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.messages.Volume;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class HostConfig {
    @JsonProperty(value="Binds")
    private ImmutableList<String> binds;
    @JsonProperty(value="ContainerIDFile")
    private String containerIDFile;
    @JsonProperty(value="LxcConf")
    private ImmutableList<LxcConfParameter> lxcConf;
    @JsonProperty(value="Privileged")
    private Boolean privileged;
    @JsonProperty(value="PortBindings")
    private Map<String, List<PortBinding>> portBindings;
    @JsonProperty(value="Links")
    private ImmutableList<String> links;
    @JsonProperty(value="PublishAllPorts")
    private Boolean publishAllPorts;
    @JsonProperty(value="Dns")
    private ImmutableList<String> dns;
    @JsonProperty(value="DnsSearch")
    private ImmutableList<String> dnsSearch;
    @JsonProperty(value="ExtraHosts")
    private ImmutableList<String> extraHosts;
    @JsonProperty(value="VolumesFrom")
    private ImmutableList<String> volumesFrom;
    @JsonProperty(value="CapAdd")
    private ImmutableList<String> capAdd;
    @JsonProperty(value="CapDrop")
    private ImmutableList<String> capDrop;
    @JsonProperty(value="NetworkMode")
    private String networkMode;
    @JsonProperty(value="SecurityOpt")
    private ImmutableList<String> securityOpt;
    @JsonProperty(value="Devices")
    private ImmutableList<Device> devices;
    @JsonProperty(value="Memory")
    private Long memory;
    @JsonProperty(value="MemorySwap")
    private Long memorySwap;
    @JsonProperty(value="MemoryReservation")
    private Long memoryReservation;
    @JsonProperty(value="CpuShares")
    private Long cpuShares;
    @JsonProperty(value="CpusetCpus")
    private String cpusetCpus;
    @JsonProperty(value="CpuQuota")
    private Long cpuQuota;
    @JsonProperty(value="CgroupParent")
    private String cgroupParent;
    @JsonProperty(value="RestartPolicy")
    private RestartPolicy restartPolicy;
    @JsonProperty(value="LogConfig")
    private LogConfig logConfig;
    @JsonProperty(value="IpcMode")
    private String ipcMode;
    @JsonProperty(value="Ulimits")
    private ImmutableList<Ulimit> ulimits;
    @JsonProperty(value="PidMode")
    private String pidMode;
    @JsonProperty(value="ShmSize")
    private Long shmSize;
    @JsonProperty(value="OomKillDisable")
    private Boolean oomKillDisable;
    @JsonProperty(value="OomScoreAdj")
    private Integer oomScoreAdj;

    private HostConfig() {
    }

    private HostConfig(Builder builder) {
        this.binds = builder.binds;
        this.containerIDFile = builder.containerIDFile;
        this.lxcConf = builder.lxcConf;
        this.privileged = builder.privileged;
        this.portBindings = builder.portBindings;
        this.links = builder.links;
        this.publishAllPorts = builder.publishAllPorts;
        this.dns = builder.dns;
        this.dnsSearch = builder.dnsSearch;
        this.extraHosts = builder.extraHosts;
        this.volumesFrom = builder.volumesFrom;
        this.capAdd = builder.capAdd;
        this.capDrop = builder.capDrop;
        this.networkMode = builder.networkMode;
        this.securityOpt = builder.securityOpt;
        this.devices = builder.devices;
        this.memory = builder.memory;
        this.memorySwap = builder.memorySwap;
        this.memoryReservation = builder.memoryReservation;
        this.cpuShares = builder.cpuShares;
        this.cpusetCpus = builder.cpusetCpus;
        this.cpuQuota = builder.cpuQuota;
        this.cgroupParent = builder.cgroupParent;
        this.restartPolicy = builder.restartPolicy;
        this.logConfig = builder.logConfig;
        this.ipcMode = builder.ipcMode;
        this.ulimits = builder.ulimits;
        this.pidMode = builder.pidMode;
        this.shmSize = builder.shmSize;
        this.oomKillDisable = builder.oomKillDisable;
        this.oomScoreAdj = builder.oomScoreAdj;
    }

    public List<String> binds() {
        return this.binds;
    }

    public String containerIDFile() {
        return this.containerIDFile;
    }

    public List<LxcConfParameter> lxcConf() {
        return this.lxcConf;
    }

    public Boolean privileged() {
        return this.privileged;
    }

    public Map<String, List<PortBinding>> portBindings() {
        return this.portBindings == null ? null : Collections.unmodifiableMap(this.portBindings);
    }

    public List<String> links() {
        return this.links;
    }

    public Boolean publishAllPorts() {
        return this.publishAllPorts;
    }

    public List<String> dns() {
        return this.dns;
    }

    public List<String> dnsSearch() {
        return this.dnsSearch;
    }

    public List<String> extraHosts() {
        return this.extraHosts;
    }

    public List<String> volumesFrom() {
        return this.volumesFrom;
    }

    public List<String> capAdd() {
        return this.capAdd;
    }

    public List<String> capDrop() {
        return this.capDrop;
    }

    public String networkMode() {
        return this.networkMode;
    }

    public List<String> securityOpt() {
        return this.securityOpt;
    }

    public List<Device> devices() {
        return this.devices;
    }

    public Long memory() {
        return this.memory;
    }

    public Long memorySwap() {
        return this.memorySwap;
    }

    public Long getMemoryReservation() {
        return this.memoryReservation;
    }

    public Long cpuShares() {
        return this.cpuShares;
    }

    public String cpusetCpus() {
        return this.cpusetCpus;
    }

    public Long cpuQuota() {
        return this.cpuQuota;
    }

    public String cgroupParent() {
        return this.cgroupParent;
    }

    public RestartPolicy restartPolicy() {
        return this.restartPolicy;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public String ipcMode() {
        return this.ipcMode;
    }

    public List<Ulimit> ulimits() {
        return this.ulimits;
    }

    public Long shmSize() {
        return this.shmSize;
    }

    public Boolean oomKillDisable() {
        return this.oomKillDisable;
    }

    public Integer oomScoreAdj() {
        return this.oomScoreAdj;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostConfig that = (HostConfig)o;
        return Objects.equals(this.binds, that.binds) && Objects.equals(this.containerIDFile, that.containerIDFile) && Objects.equals(this.lxcConf, that.lxcConf) && Objects.equals(this.privileged, that.privileged) && Objects.equals(this.portBindings, that.portBindings) && Objects.equals(this.links, that.links) && Objects.equals(this.publishAllPorts, that.publishAllPorts) && Objects.equals(this.dns, that.dns) && Objects.equals(this.dnsSearch, that.dnsSearch) && Objects.equals(this.extraHosts, that.extraHosts) && Objects.equals(this.volumesFrom, that.volumesFrom) && Objects.equals(this.capAdd, that.capAdd) && Objects.equals(this.capDrop, that.capDrop) && Objects.equals(this.networkMode, that.networkMode) && Objects.equals(this.securityOpt, that.securityOpt) && Objects.equals(this.devices, that.devices) && Objects.equals(this.memory, that.memory) && Objects.equals(this.memorySwap, that.memorySwap) && Objects.equals(this.memoryReservation, that.memoryReservation) && Objects.equals(this.cpuShares, that.cpuShares) && Objects.equals(this.cpusetCpus, that.cpusetCpus) && Objects.equals(this.cpuQuota, that.cpuQuota) && Objects.equals(this.cgroupParent, that.cgroupParent) && Objects.equals(this.restartPolicy, that.restartPolicy) && Objects.equals(this.logConfig, that.logConfig) && Objects.equals(this.ipcMode, that.ipcMode) && Objects.equals(this.ulimits, that.ulimits) && Objects.equals(this.oomKillDisable, that.oomKillDisable) && Objects.equals(this.oomScoreAdj, that.oomScoreAdj);
    }

    public int hashCode() {
        return Objects.hash(this.binds, this.containerIDFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsSearch, this.extraHosts, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.memoryReservation, this.cpuShares, this.cpusetCpus, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("binds", this.binds).add("containerIDFile", (Object)this.containerIDFile).add("lxcConf", this.lxcConf).add("privileged", (Object)this.privileged).add("portBindings", this.portBindings).add("links", this.links).add("publishAllPorts", (Object)this.publishAllPorts).add("dns", this.dns).add("dnsSearch", this.dnsSearch).add("extraHosts", this.extraHosts).add("volumesFrom", this.volumesFrom).add("capAdd", this.capAdd).add("capDrop", this.capDrop).add("networkMode", (Object)this.networkMode).add("securityOpt", this.securityOpt).add("devices", this.devices).add("memory", (Object)this.memory).add("memorySwap", (Object)this.memorySwap).add("memoryReservation", (Object)this.memoryReservation).add("cpuShares", (Object)this.cpuShares).add("cpusetCpus", (Object)this.cpusetCpus).add("cpuQuota", (Object)this.cpuQuota).add("cgroupParent", (Object)this.cgroupParent).add("restartPolicy", (Object)this.restartPolicy).add("logConfig", (Object)this.logConfig).add("ipcMode", (Object)this.ipcMode).add("ulimits", this.ulimits).add("pidMode", (Object)this.pidMode).add("shmSize", (Object)this.shmSize).add("oomKillDisable", (Object)this.oomKillDisable).add("oomScoreAdj", (Object)this.oomScoreAdj).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Ulimit {
        @JsonProperty(value="Name")
        private String name;
        @JsonProperty(value="Soft")
        private Integer soft;
        @JsonProperty(value="Hard")
        private Integer hard;

        public Ulimit() {
        }

        private Ulimit(Builder builder) {
            this.name = builder.name;
            this.soft = builder.soft;
            this.hard = builder.hard;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String name() {
            return this.name;
        }

        public Integer soft() {
            return this.soft;
        }

        public Integer hard() {
            return this.hard;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ulimit that = (Ulimit)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.soft, that.soft) && Objects.equals(this.hard, that.hard);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.soft, this.hard);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("soft", (Object)this.soft).add("hard", (Object)this.hard).toString();
        }

        public static class Builder {
            private String name;
            private Integer soft;
            private Integer hard;

            private Builder() {
            }

            public Ulimit build() {
                return new Ulimit(this);
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder soft(Integer soft) {
                this.soft = soft;
                return this;
            }

            public Builder hard(Integer hard) {
                this.hard = hard;
                return this;
            }
        }
    }

    public static class Bind {
        private String to;
        private String from;
        private Boolean readOnly;
        private Boolean noCopy;

        private Bind(Builder builder) {
            this.to = builder.to;
            this.from = builder.from;
            this.readOnly = builder.readOnly;
            this.noCopy = builder.noCopy;
        }

        public static BuilderTo to(String to) {
            return new BuilderTo(to);
        }

        public static BuilderFrom from(String from) {
            return new BuilderFrom(from);
        }

        public static BuilderFrom from(Volume volumeFrom) {
            return new BuilderFrom(volumeFrom);
        }

        public String toString() {
            String optionsValue;
            if (this.to == null || this.to.equals("")) {
                return "";
            }
            if (this.from == null || this.from.equals("")) {
                return this.to;
            }
            String bind = this.from + ":" + this.to;
            ArrayList<String> options = new ArrayList<String>();
            if (this.readOnly != null && this.readOnly.booleanValue()) {
                options.add("ro");
            }
            if (this.noCopy != null && this.noCopy.booleanValue()) {
                options.add("nocopy");
            }
            return (optionsValue = Joiner.on((char)',').join(options)).isEmpty() ? bind : bind + ":" + optionsValue;
        }

        public static class Builder {
            private String to;
            private String from;
            private Boolean readOnly = false;
            private Boolean noCopy;

            private Builder() {
            }

            private Builder(BuilderTo toBuilder, String from) {
                this.to = toBuilder.to;
                this.from = from;
            }

            private Builder(BuilderTo toBuilder, Volume volumeFrom) {
                this.to = toBuilder.to;
                this.from = volumeFrom.name();
            }

            private Builder(BuilderFrom fromBuilder, String to) {
                this.to = to;
                this.from = fromBuilder.from;
            }

            public Builder to(String to) {
                this.to = to;
                return this;
            }

            public String to() {
                return this.to;
            }

            public Builder from(String from) {
                this.from = from;
                return this;
            }

            public Builder from(Volume volumeFrom) {
                this.from = volumeFrom.name();
                return this;
            }

            public String from() {
                return this.from;
            }

            public Builder readOnly(Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Boolean readOnly() {
                return this.readOnly;
            }

            public Builder noCopy(Boolean noCopy) {
                this.noCopy = noCopy;
                return this;
            }

            public Boolean noCopy() {
                return this.noCopy;
            }

            public Bind build() {
                return new Bind(this);
            }
        }

        public static class BuilderFrom {
            private String from;

            public BuilderFrom(String from) {
                this.from = from;
            }

            public BuilderFrom(Volume volumeFrom) {
                this.from = volumeFrom.name();
            }

            public Builder to(String to) {
                return new Builder(this, to);
            }
        }

        public static class BuilderTo {
            private String to;

            public BuilderTo(String to) {
                this.to = to;
            }

            public Builder from(String from) {
                return new Builder(this, from);
            }

            public Builder from(Volume volumeFrom) {
                return new Builder(this, volumeFrom);
            }
        }
    }

    public static class Builder {
        private ImmutableList<String> binds;
        private String containerIDFile;
        private ImmutableList<LxcConfParameter> lxcConf;
        private Boolean privileged;
        private Map<String, List<PortBinding>> portBindings;
        private ImmutableList<String> links;
        private Boolean publishAllPorts;
        private ImmutableList<String> dns;
        private ImmutableList<String> dnsSearch;
        private ImmutableList<String> extraHosts;
        private ImmutableList<String> volumesFrom;
        private ImmutableList<String> capAdd;
        private ImmutableList<String> capDrop;
        private String networkMode;
        private ImmutableList<String> securityOpt;
        private ImmutableList<Device> devices;
        private Long memory;
        private Long memorySwap;
        private Long memoryReservation;
        private Long cpuShares;
        private String cpusetCpus;
        private Long cpuQuota;
        private String cgroupParent;
        private RestartPolicy restartPolicy;
        private LogConfig logConfig;
        private String ipcMode;
        private ImmutableList<Ulimit> ulimits;
        private String pidMode;
        private Long shmSize;
        private Boolean oomKillDisable;
        private Integer oomScoreAdj;

        private Builder() {
        }

        private Builder(HostConfig hostConfig) {
            this.binds = hostConfig.binds;
            this.containerIDFile = hostConfig.containerIDFile;
            this.lxcConf = hostConfig.lxcConf;
            this.privileged = hostConfig.privileged;
            this.portBindings = hostConfig.portBindings;
            this.links = hostConfig.links;
            this.publishAllPorts = hostConfig.publishAllPorts;
            this.dns = hostConfig.dns;
            this.dnsSearch = hostConfig.dnsSearch;
            this.extraHosts = hostConfig.extraHosts;
            this.volumesFrom = hostConfig.volumesFrom;
            this.capAdd = hostConfig.capAdd;
            this.capDrop = hostConfig.capDrop;
            this.networkMode = hostConfig.networkMode;
            this.securityOpt = hostConfig.securityOpt;
            this.devices = hostConfig.devices;
            this.memory = hostConfig.memory;
            this.memorySwap = hostConfig.memorySwap;
            this.memoryReservation = hostConfig.memoryReservation;
            this.cpuShares = hostConfig.cpuShares;
            this.cpusetCpus = hostConfig.cpusetCpus;
            this.cpuQuota = hostConfig.cpuQuota;
            this.cgroupParent = hostConfig.cgroupParent;
            this.restartPolicy = hostConfig.restartPolicy;
            this.logConfig = hostConfig.logConfig;
            this.ipcMode = hostConfig.ipcMode;
            this.ulimits = hostConfig.ulimits;
            this.pidMode = hostConfig.pidMode;
            this.shmSize = hostConfig.shmSize;
            this.oomKillDisable = hostConfig.oomKillDisable;
            this.oomScoreAdj = hostConfig.oomScoreAdj;
        }

        public Builder binds(List<String> binds) {
            if (binds != null && !binds.isEmpty()) {
                this.binds = Builder.copyWithoutDuplicates(binds);
            }
            return this;
        }

        public Builder binds(String ... binds) {
            if (binds != null && binds.length > 0) {
                return this.binds(Lists.newArrayList((Object[])binds));
            }
            return this;
        }

        public Builder binds(Bind ... binds) {
            if (binds == null || binds.length == 0) {
                return this;
            }
            return this.binds(Builder.toStringList(binds));
        }

        private static List<String> toStringList(Bind[] binds) {
            ArrayList bindStrings = Lists.newArrayList();
            for (Bind bind : binds) {
                bindStrings.add(bind.toString());
            }
            return bindStrings;
        }

        public Builder appendBinds(Iterable<String> newBinds) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.binds != null) {
                list.addAll((Collection<String>)this.binds);
            }
            list.addAll(Lists.newArrayList(newBinds));
            this.binds = Builder.copyWithoutDuplicates(list);
            return this;
        }

        public Builder appendBinds(Bind ... binds) {
            this.appendBinds(Builder.toStringList(binds));
            return this;
        }

        public Builder appendBinds(String ... binds) {
            this.appendBinds(Lists.newArrayList((Object[])binds));
            return this;
        }

        private static <T> ImmutableList<T> copyWithoutDuplicates(List<T> input) {
            ArrayList<T> list = new ArrayList<T>(input.size());
            for (T element : input) {
                if (list.contains(element)) continue;
                list.add(element);
            }
            return ImmutableList.copyOf(list);
        }

        public List<String> binds() {
            return this.binds;
        }

        public Builder containerIDFile(String containerIDFile) {
            this.containerIDFile = containerIDFile;
            return this;
        }

        public String containerIDFile() {
            return this.containerIDFile;
        }

        public Builder lxcConf(List<LxcConfParameter> lxcConf) {
            if (lxcConf != null && !lxcConf.isEmpty()) {
                this.lxcConf = ImmutableList.copyOf(lxcConf);
            }
            return this;
        }

        public Builder lxcConf(LxcConfParameter ... lxcConf) {
            if (lxcConf != null && lxcConf.length > 0) {
                this.lxcConf = ImmutableList.copyOf((Object[])lxcConf);
            }
            return this;
        }

        public List<LxcConfParameter> lxcConf() {
            return this.lxcConf;
        }

        public Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public Boolean privileged() {
            return this.privileged;
        }

        public Builder portBindings(Map<String, List<PortBinding>> portBindings) {
            if (portBindings != null && !portBindings.isEmpty()) {
                this.portBindings = Maps.newHashMap(portBindings);
            }
            return this;
        }

        public Map<String, List<PortBinding>> portBindings() {
            return this.portBindings;
        }

        public Builder links(List<String> links) {
            if (links != null && !links.isEmpty()) {
                this.links = ImmutableList.copyOf(links);
            }
            return this;
        }

        public Builder links(String ... links) {
            if (links != null && links.length > 0) {
                this.links = ImmutableList.copyOf((Object[])links);
            }
            return this;
        }

        public List<String> links() {
            return this.links;
        }

        public Builder publishAllPorts(Boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        public Boolean publishAllPorts() {
            return this.publishAllPorts;
        }

        public Builder dns(List<String> dns) {
            if (dns != null && !dns.isEmpty()) {
                this.dns = ImmutableList.copyOf(dns);
            }
            return this;
        }

        public Builder dns(String ... dns) {
            if (dns != null && dns.length > 0) {
                this.dns = ImmutableList.copyOf((Object[])dns);
            }
            return this;
        }

        public List<String> dns() {
            return this.dns;
        }

        public Builder dnsSearch(List<String> dnsSearch) {
            if (dnsSearch != null && !dnsSearch.isEmpty()) {
                this.dnsSearch = ImmutableList.copyOf(dnsSearch);
            }
            return this;
        }

        public Builder dnsSearch(String ... dnsSearch) {
            if (dnsSearch != null && dnsSearch.length > 0) {
                this.dnsSearch = ImmutableList.copyOf((Object[])dnsSearch);
            }
            return this;
        }

        public List<String> dnsSearch() {
            return this.dnsSearch;
        }

        public Builder extraHosts(List<String> extraHosts) {
            if (extraHosts != null && !extraHosts.isEmpty()) {
                this.extraHosts = ImmutableList.copyOf(extraHosts);
            }
            return this;
        }

        public Builder extraHosts(String ... extraHosts) {
            if (extraHosts != null && extraHosts.length > 0) {
                this.extraHosts = ImmutableList.copyOf((Object[])extraHosts);
            }
            return this;
        }

        public List<String> extraHosts() {
            return this.extraHosts;
        }

        public Builder volumesFrom(List<String> volumesFrom) {
            if (volumesFrom != null && !volumesFrom.isEmpty()) {
                this.volumesFrom = ImmutableList.copyOf(volumesFrom);
            }
            return this;
        }

        public Builder volumesFrom(String ... volumesFrom) {
            if (volumesFrom != null && volumesFrom.length > 0) {
                this.volumesFrom = ImmutableList.copyOf((Object[])volumesFrom);
            }
            return this;
        }

        public List<String> volumesFrom() {
            return this.volumesFrom;
        }

        public Builder capAdd(List<String> capAdd) {
            if (capAdd != null && !capAdd.isEmpty()) {
                this.capAdd = ImmutableList.copyOf(capAdd);
            }
            return this;
        }

        public Builder capAdd(String ... capAdd) {
            if (capAdd != null && capAdd.length > 0) {
                this.capAdd = ImmutableList.copyOf((Object[])capAdd);
            }
            return this;
        }

        public List<String> capAdd() {
            return this.capAdd;
        }

        public Builder capDrop(List<String> capDrop) {
            if (capDrop != null && !capDrop.isEmpty()) {
                this.capDrop = ImmutableList.copyOf(capDrop);
            }
            return this;
        }

        public Builder capDrop(String ... capDrop) {
            if (capDrop != null && capDrop.length > 0) {
                this.capDrop = ImmutableList.copyOf((Object[])capDrop);
            }
            return this;
        }

        public List<String> capDrop() {
            return this.capDrop;
        }

        public Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        public String networkMode() {
            return this.networkMode;
        }

        public Builder securityOpt(List<String> securityOpt) {
            if (securityOpt != null && !securityOpt.isEmpty()) {
                this.securityOpt = ImmutableList.copyOf(securityOpt);
            }
            return this;
        }

        public Builder securityOpt(String ... securityOpt) {
            if (securityOpt != null && securityOpt.length > 0) {
                this.securityOpt = ImmutableList.copyOf((Object[])securityOpt);
            }
            return this;
        }

        public List<String> securityOpt() {
            return this.securityOpt;
        }

        public Builder devices(List<Device> devices) {
            if (devices != null && !devices.isEmpty()) {
                this.devices = ImmutableList.copyOf(devices);
            }
            return this;
        }

        public Builder devices(Device ... devices) {
            if (devices != null && devices.length > 0) {
                this.devices = ImmutableList.copyOf((Object[])devices);
            }
            return this;
        }

        public List<Device> devices() {
            return this.devices;
        }

        public Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public Long memory() {
            return this.memory;
        }

        public Builder memorySwap(Long memorySwap) {
            this.memorySwap = memorySwap;
            return this;
        }

        public Long memorySwap() {
            return this.memorySwap;
        }

        public Builder memoryReservation(Long memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        public Long memoryReservation() {
            return this.memoryReservation;
        }

        public Builder cpuShares(Long cpuShares) {
            this.cpuShares = cpuShares;
            return this;
        }

        public Long cpuShares() {
            return this.cpuShares;
        }

        public Builder cpusetCpus(String cpusetCpus) {
            this.cpusetCpus = cpusetCpus;
            return this;
        }

        public String cpusetCpus() {
            return this.cpusetCpus;
        }

        public Builder cpuQuota(Long cpuQuota) {
            this.cpuQuota = cpuQuota;
            return this;
        }

        public Long cpuQuota() {
            return this.cpuQuota;
        }

        public Builder cgroupParent(String cgroupParent) {
            this.cgroupParent = cgroupParent;
            return this;
        }

        public String cgroupParent() {
            return this.cgroupParent;
        }

        public Builder restartPolicy(RestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        public Builder logConfig(LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public RestartPolicy restartPolicy() {
            return this.restartPolicy;
        }

        public LogConfig logConfig() {
            return this.logConfig;
        }

        public Builder ipcMode(String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        public String ipcMode() {
            return this.ipcMode;
        }

        public Builder ulimits(List<Ulimit> ulimits) {
            this.ulimits = ImmutableList.copyOf(ulimits);
            return this;
        }

        public Builder containerPidMode(String container) {
            this.pidMode = "container:" + container;
            return this;
        }

        public Builder hostPidMode() {
            this.pidMode = "host";
            return this;
        }

        public Builder shmSize(Long shmSize) {
            this.shmSize = shmSize;
            return this;
        }

        public Long shmSize() {
            return this.shmSize;
        }

        public Builder oomKillDisable(Boolean oomKillDisable) {
            this.oomKillDisable = oomKillDisable;
            return this;
        }

        public Boolean oomKillDisable() {
            return this.oomKillDisable;
        }

        public Builder oomScoreAdj(Integer oomScoreAdj) {
            this.oomScoreAdj = oomScoreAdj;
            return this;
        }

        public Integer oomScoreAdj() {
            return this.oomScoreAdj;
        }

        public HostConfig build() {
            return new HostConfig(this);
        }
    }

    public static class RestartPolicy {
        @JsonProperty(value="Name")
        private String name;
        @JsonProperty(value="MaximumRetryCount")
        private Integer maxRetryCount;

        public static RestartPolicy always() {
            return new RestartPolicy("always", null);
        }

        public static RestartPolicy unlessStopped() {
            return new RestartPolicy("unless-stopped", null);
        }

        public static RestartPolicy onFailure(Integer maxRetryCount) {
            return new RestartPolicy("on-failure", maxRetryCount);
        }

        private RestartPolicy() {
        }

        private RestartPolicy(String name, Integer maxRetryCount) {
            this.name = name;
            this.maxRetryCount = maxRetryCount;
        }

        public String name() {
            return this.name;
        }

        public Integer maxRetryCount() {
            return this.maxRetryCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RestartPolicy that = (RestartPolicy)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.maxRetryCount, that.maxRetryCount);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.maxRetryCount);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("maxRetryCount", (Object)this.maxRetryCount).toString();
        }
    }

    public static class LxcConfParameter {
        @JsonProperty(value="Key")
        private String key;
        @JsonProperty(value="Value")
        private String value;

        public LxcConfParameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LxcConfParameter that = (LxcConfParameter)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("value", (Object)this.value).toString();
        }
    }
}

