/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.messages.AutoValue_CpuStats;
import com.spotify.docker.client.messages.AutoValue_CpuStats_CpuUsage;
import com.spotify.docker.client.messages.AutoValue_CpuStats_ThrottlingData;
import java.util.List;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class CpuStats {
    @JsonProperty(value="cpu_usage")
    public abstract CpuUsage cpuUsage();

    @Nullable
    @JsonProperty(value="system_cpu_usage")
    public abstract Long systemCpuUsage();

    @JsonProperty(value="throttling_data")
    public abstract ThrottlingData throttlingData();

    @JsonCreator
    static CpuStats create(@JsonProperty(value="cpu_usage") CpuUsage cpuUsage, @JsonProperty(value="system_cpu_usage") Long systemCpuUsage, @JsonProperty(value="throttling_data") ThrottlingData throttlingData) {
        return new AutoValue_CpuStats.Builder().cpuUsage(cpuUsage).systemCpuUsage(systemCpuUsage).throttlingData(throttlingData).build();
    }

    public static abstract class ThrottlingData {
        @JsonProperty(value="periods")
        public abstract Long periods();

        @JsonProperty(value="throttled_periods")
        public abstract Long throttledPeriods();

        @JsonProperty(value="throttled_time")
        public abstract Long throttledTime();

        @JsonCreator
        static ThrottlingData create(@JsonProperty(value="periods") Long periods, @JsonProperty(value="throttled_periods") Long throttledPeriods, @JsonProperty(value="throttled_time") Long throttledTime) {
            return new AutoValue_CpuStats_ThrottlingData(periods, throttledPeriods, throttledTime);
        }
    }

    public static abstract class CpuUsage {
        @JsonProperty(value="total_usage")
        public abstract Long totalUsage();

        @Nullable
        @JsonProperty(value="percpu_usage")
        public abstract ImmutableList<Long> percpuUsage();

        @JsonProperty(value="usage_in_kernelmode")
        public abstract Long usageInKernelmode();

        @JsonProperty(value="usage_in_usermode")
        public abstract Long usageInUsermode();

        @JsonCreator
        static CpuUsage create(@JsonProperty(value="total_usage") Long totalUsage, @JsonProperty(value="percpu_usage") List<Long> perCpuUsage, @JsonProperty(value="usage_in_kernelmode") Long usageInKernelmode, @JsonProperty(value="usage_in_usermode") Long usageInUsermode) {
            return new AutoValue_CpuStats_CpuUsage.Builder().totalUsage(totalUsage).percpuUsage(perCpuUsage).usageInKernelmode(usageInKernelmode).usageInUsermode(usageInUsermode).build();
        }

        public static abstract class Builder {
            public abstract Builder totalUsage(Long var1);

            public abstract Builder percpuUsage(List<Long> var1);

            public abstract Builder usageInKernelmode(Long var1);

            public abstract Builder usageInUsermode(Long var1);

            public abstract CpuUsage build();
        }
    }

    public static abstract class Builder {
        public abstract Builder cpuUsage(CpuUsage var1);

        public abstract Builder systemCpuUsage(Long var1);

        public abstract Builder throttlingData(ThrottlingData var1);

        public abstract CpuStats build();
    }
}

