/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.framed;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.SslContextBuilder;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.framed.FramedConnection;
import com.squareup.okhttp.internal.framed.FramedStream;
import com.squareup.okhttp.internal.framed.Header;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class FramedServer
extends FramedConnection.Listener {
    static final Logger logger = Logger.getLogger(FramedServer.class.getName());
    private final List<Protocol> framedProtocols = Util.immutableList((Object[])new Protocol[]{Protocol.HTTP_2, Protocol.SPDY_3});
    private final File baseDirectory;
    private final SSLSocketFactory sslSocketFactory;

    public FramedServer(File baseDirectory, SSLSocketFactory sslSocketFactory) {
        this.baseDirectory = baseDirectory;
        this.sslSocketFactory = sslSocketFactory;
    }

    private void run() throws Exception {
        ServerSocket serverSocket = new ServerSocket(8888);
        serverSocket.setReuseAddress(true);
        while (true) {
            Socket socket = null;
            try {
                Protocol protocol;
                socket = serverSocket.accept();
                SSLSocket sslSocket = this.doSsl(socket);
                String protocolString = Platform.get().getSelectedProtocol(sslSocket);
                Protocol protocol2 = protocol = protocolString != null ? Protocol.get((String)protocolString) : null;
                if (protocol == null || !this.framedProtocols.contains(protocol)) {
                    throw new ProtocolException("Protocol " + protocol + " unsupported");
                }
                FramedConnection framedConnection = new FramedConnection.Builder(false).socket((Socket)sslSocket).protocol(protocol).listener((FramedConnection.Listener)this).build();
                framedConnection.sendConnectionPreface();
                continue;
            }
            catch (IOException e) {
                logger.log(Level.INFO, "FramedServer connection failure: " + e);
                Util.closeQuietly((Socket)socket);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "FramedServer unexpected failure", e);
                Util.closeQuietly((Socket)socket);
                continue;
            }
            break;
        }
    }

    private SSLSocket doSsl(Socket socket) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        sslSocket.setUseClientMode(false);
        Platform.get().configureTlsExtensions(sslSocket, null, this.framedProtocols);
        sslSocket.startHandshake();
        return sslSocket;
    }

    public void onStream(FramedStream stream) throws IOException {
        try {
            List requestHeaders = stream.getRequestHeaders();
            String path = null;
            int size = requestHeaders.size();
            for (int i = 0; i < size; ++i) {
                if (!((Header)requestHeaders.get((int)i)).name.equals((Object)Header.TARGET_PATH)) continue;
                path = ((Header)requestHeaders.get((int)i)).value.utf8();
                break;
            }
            if (path == null) {
                throw new AssertionError();
            }
            File file = new File(this.baseDirectory + path);
            if (file.isDirectory()) {
                this.serveDirectory(stream, file.listFiles());
            } else if (file.exists()) {
                this.serveFile(stream, file);
            } else {
                this.send404(stream, path);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private void send404(FramedStream stream, String path) throws IOException {
        List<Header> responseHeaders = Arrays.asList(new Header(":status", "404"), new Header(":version", "HTTP/1.1"), new Header("content-type", "text/plain"));
        stream.reply(responseHeaders, true);
        BufferedSink out = Okio.buffer((Sink)stream.getSink());
        out.writeUtf8("Not found: " + path);
        out.close();
    }

    private void serveDirectory(FramedStream stream, File[] files) throws IOException {
        List<Header> responseHeaders = Arrays.asList(new Header(":status", "200"), new Header(":version", "HTTP/1.1"), new Header("content-type", "text/html; charset=UTF-8"));
        stream.reply(responseHeaders, true);
        BufferedSink out = Okio.buffer((Sink)stream.getSink());
        for (File file : files) {
            String target = file.isDirectory() ? file.getName() + "/" : file.getName();
            out.writeUtf8("<a href='" + target + "'>" + target + "</a><br>");
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveFile(FramedStream stream, File file) throws IOException {
        List<Header> responseHeaders = Arrays.asList(new Header(":status", "200"), new Header(":version", "HTTP/1.1"), new Header("content-type", this.contentType(file)));
        stream.reply(responseHeaders, true);
        Source source = Okio.source((File)file);
        try {
            BufferedSink out = Okio.buffer((Sink)stream.getSink());
            out.writeAll(source);
            out.close();
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }

    private String contentType(File file) {
        if (file.getName().endsWith(".css")) {
            return "text/css";
        }
        if (file.getName().endsWith(".gif")) {
            return "image/gif";
        }
        if (file.getName().endsWith(".html")) {
            return "text/html";
        }
        if (file.getName().endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (file.getName().endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (file.getName().endsWith(".js")) {
            return "application/javascript";
        }
        if (file.getName().endsWith(".png")) {
            return "image/png";
        }
        return "text/plain";
    }

    public static void main(String ... args) throws Exception {
        if (args.length != 1 || args[0].startsWith("-")) {
            System.out.println("Usage: FramedServer <base directory>");
            return;
        }
        FramedServer server = new FramedServer(new File(args[0]), SslContextBuilder.localhost().getSocketFactory());
        server.run();
    }
}

