package com.startapp.sdk.adsbase.adlisteners;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.startapp.sdk.adsbase.Ad;

/**
 * Callback for different methods of loading ads.
 *
 */
@Keep
public interface AdEventListener {
    /**
     * Invoked when the ad instance is received.
     *
     * @param ad not null
     */
    @Keep
    void onReceiveAd(@NonNull Ad ad);

    /**
     * Invoked in case of failure. If the <code>ad</code> is not <code>null</code>,
     * then it may contain an error message.
     *
     * @param ad may be null
     * @see Ad#getErrorMessage()
     */
    @Keep
    void onFailedToReceiveAd(@Nullable Ad ad);

}
