/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.motiondetector;

import com.startapp.motiondetector.SignalProcessor;
import com.startapp.motiondetector.Utils;
import com.startapp.motiondetector.Valuable;

public class AmortizedMaximum
implements SignalProcessor,
Valuable {
    private final double weightMaximum;
    private final double weightNewValue;
    private final double periodMillis;
    private final double periodMin;
    private final double periodScale;
    private final double periodZero;
    private double maximumValue;
    private long maximumTime;
    private double amortized;

    public AmortizedMaximum(double weightMaximum, double weightNewValue, double periodMillis, double periodMin, double periodScale) {
        this.weightMaximum = weightMaximum / (weightMaximum + weightNewValue);
        this.weightNewValue = weightNewValue / (weightMaximum + weightNewValue);
        this.periodMillis = periodMillis;
        this.periodMin = periodMin;
        this.periodScale = periodScale;
        this.periodZero = Utils.logisticalFunction(0.0, periodMin, periodScale);
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(double maximumValue) {
        this.maximumValue = maximumValue;
    }

    public long getMaximumTime() {
        return this.maximumTime;
    }

    public void setMaximumTime(long maximumTime) {
        this.maximumTime = maximumTime;
    }

    public static double calcImpact(long currentTimeMillis, long maximumTime, double periodMillis, double periodMin, double periodScale, double periodZero) {
        double period = (double)Math.max(0L, currentTimeMillis - maximumTime) / periodMillis;
        if (periodScale > 0.0) {
            return Utils.logisticalFunction0(period, periodMin, periodScale, periodZero);
        }
        if (periodScale < 0.0) {
            return Utils.logisticalFunction1(period, periodMin, periodScale, periodZero);
        }
        return Utils.logisticalFunction(period, periodMin, periodScale);
    }

    public void add(long currentTimeMillis, double value) {
        double amortizedMaximum = this.maximumValue * AmortizedMaximum.calcImpact(currentTimeMillis, this.maximumTime, this.periodMillis, this.periodMin, this.periodScale, this.periodZero);
        this.amortized = this.weightMaximum * amortizedMaximum + this.weightNewValue * value;
        if (amortizedMaximum < this.amortized) {
            this.maximumValue = this.amortized;
            this.maximumTime = currentTimeMillis;
        }
    }

    @Override
    public double getValue() {
        return this.amortized;
    }

    @Override
    public void reset() {
        this.maximumValue = 0.0;
        this.maximumTime = 0L;
        this.amortized = 0.0;
    }
}

