/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.motiondetector;

import com.startapp.motiondetector.SignalProcessor;
import com.startapp.motiondetector.Valuable;

public class HighPassFilter
implements SignalProcessor,
Valuable {
    private final double oldPart;
    private final double newPart;
    private double result;

    public HighPassFilter(double weight) {
        this.oldPart = weight / (weight + 1.0);
        this.newPart = 1.0 / (weight + 1.0);
    }

    public void add(double value) {
        this.result = this.oldPart * this.result + value * this.newPart;
    }

    @Override
    public double getValue() {
        return this.result;
    }

    @Override
    public void reset() {
        this.result = 0.0;
    }
}

