/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.motiondetector;

import com.startapp.motiondetector.HighPassFilter;
import com.startapp.motiondetector.SignalProcessor;
import com.startapp.motiondetector.Valuable;

public class HighPassFilter3D
implements SignalProcessor,
Valuable {
    private final HighPassFilter x;
    private final HighPassFilter y;
    private final HighPassFilter z;
    private double magnitude;

    public HighPassFilter getX() {
        return this.x;
    }

    public HighPassFilter getY() {
        return this.y;
    }

    public HighPassFilter getZ() {
        return this.z;
    }

    public HighPassFilter3D(HighPassFilter x, HighPassFilter y, HighPassFilter z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void add(double valueX, double valueY, double valueZ) {
        this.x.add(valueX);
        this.y.add(valueY);
        this.z.add(valueZ);
        this.magnitude = Math.sqrt(this.x.getValue() * this.x.getValue() + this.y.getValue() * this.y.getValue() + this.z.getValue() * this.z.getValue());
    }

    @Override
    public void reset() {
        this.x.reset();
        this.y.reset();
        this.z.reset();
        this.magnitude = 0.0;
    }

    @Override
    public double getValue() {
        return this.magnitude;
    }
}

