/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.motiondetector;

import com.startapp.motiondetector.HighPassFilter;
import com.startapp.motiondetector.HighPassFilter3D;
import com.startapp.motiondetector.SignalProcessor;
import com.startapp.motiondetector.Valuable;

public class RestStateRecognizer
implements SignalProcessor {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_REST = 1;
    public static final int STATE_MOTION = 2;
    private final SamplePool pool = new SamplePool();
    private final double alphaJerk;
    private final long delayIntervalNanos;
    private final long decisionMakingIntervalNanos;
    private final long decisionValidnessIntervalNanos;
    private final boolean applyCorrection;
    private Sample oldest;
    private Sample nearestBack;
    private Sample newest;
    private long startTimestampNanos;
    private long validTimestampNanos;
    private long stableTillTimestampNanos;
    private final HighPassFilter3D gravity;
    private final HighPassFilter3D linear;
    private final HighPassFilter3D forward;
    private double scalarLF;
    private double acceleration;
    private double jerk;
    private double accelerationMaxSum;
    private int maxCount;
    private int steadyCount;
    private int samplesCount;
    private int state = 0;
    private long brakingTimeBegin;
    private long brakingTimeEnd;
    private long brakingTimeMin;
    private double brakingAccelerationMin;

    public double getAcceleration() {
        return this.acceleration;
    }

    public double getJerk() {
        return this.jerk;
    }

    public RestStateRecognizer(double decisionIntervalSeconds, boolean applyCorrection) {
        this(10.0, 15.0, 25.0, 15.0, 8.0, decisionIntervalSeconds, 1.0, applyCorrection);
    }

    private RestStateRecognizer(double hpfGravityBase, double hpfLinearBase, double hpfForwardBase, double hpfJerkBase, double delayIntervalSeconds, double decisionMakingIntervalSeconds, double decisionValidnessIntervalSeconds, boolean applyCorrection) {
        this.alphaJerk = hpfJerkBase / (hpfJerkBase + 1.0);
        this.delayIntervalNanos = (long)(delayIntervalSeconds * 1.0E9);
        this.decisionMakingIntervalNanos = (long)(decisionMakingIntervalSeconds * 1.0E9);
        this.decisionValidnessIntervalNanos = (long)(decisionValidnessIntervalSeconds * 1.0E9);
        this.applyCorrection = applyCorrection;
        this.gravity = new HighPassFilter3D(new HighPassFilter(hpfGravityBase), new HighPassFilter(hpfGravityBase), new HighPassFilter(hpfGravityBase));
        this.linear = new HighPassFilter3D(new HighPassFilter(hpfLinearBase), new HighPassFilter(hpfLinearBase), new HighPassFilter(hpfLinearBase));
        this.forward = new HighPassFilter3D(new HighPassFilter(hpfForwardBase), new HighPassFilter(hpfForwardBase), new HighPassFilter(hpfForwardBase));
    }

    public void add(long timestampNanos, double ax, double ay, double az) {
        double jerkCorrection;
        double accelerationCorrection;
        if (this.newest != null && this.newest.timestampNanos >= timestampNanos) {
            return;
        }
        if (this.startTimestampNanos <= 0L) {
            this.startTimestampNanos = timestampNanos;
        }
        this.gravity.add(ax, ay, az);
        double lx = ax - this.gravity.getX().getValue();
        double ly = ay - this.gravity.getY().getValue();
        double lz = az - this.gravity.getZ().getValue();
        this.linear.add(lx, ly, lz);
        double oldForwardX = this.forward.getX().getValue();
        double oldForwardY = this.forward.getY().getValue();
        double oldForwardZ = this.forward.getZ().getValue();
        this.forward.add(lx, ly, -Math.abs(lz));
        if (this.smsq(this.forward.getX().getValue() - oldForwardX, this.forward.getY().getValue() - oldForwardY, this.forward.getZ().getValue() - oldForwardZ) > 0.01) {
            this.validTimestampNanos = timestampNanos + this.delayIntervalNanos;
        }
        this.scalarLF = this.scalarProduct(this.linear.getX(), this.forward.getX(), this.linear.getY(), this.forward.getY(), this.linear.getZ(), this.forward.getZ());
        if (this.applyCorrection && timestampNanos > this.brakingTimeEnd && this.brakingTimeEnd > 0L && this.brakingTimeEnd > this.brakingTimeMin && this.brakingTimeMin > this.brakingTimeBegin) {
            double t = (double)(timestampNanos - this.brakingTimeEnd) / 1.0E9;
            double d = (double)(this.brakingTimeEnd - this.brakingTimeBegin) / 1.0E9;
            double a = 1.0 - Math.exp(this.brakingAccelerationMin / 3.0);
            accelerationCorrection = 1.0 - a * Math.exp(-Math.pow(t / d, 2.0));
            jerkCorrection = Math.pow(accelerationCorrection, 0.25);
        } else {
            accelerationCorrection = 1.0;
            jerkCorrection = 1.0;
        }
        double oldAcceleration = this.acceleration;
        double d = this.acceleration = Double.compare(this.forward.getValue(), 0.0) == 0 ? 0.0 : accelerationCorrection * this.scalarLF / this.forward.getValue();
        if (oldAcceleration < 0.0) {
            if (this.acceleration < 0.0) {
                if (this.brakingAccelerationMin > this.acceleration) {
                    this.brakingAccelerationMin = this.acceleration;
                    this.brakingTimeMin = timestampNanos;
                }
            } else {
                this.brakingTimeEnd = timestampNanos;
            }
        } else if (this.acceleration < 0.0) {
            this.brakingTimeBegin = timestampNanos;
            this.brakingTimeEnd = 0L;
            this.brakingTimeMin = timestampNanos;
            this.brakingAccelerationMin = this.acceleration;
        }
        this.purgeRollingValues(timestampNanos);
        Sample sample = this.pool.acquire();
        sample.timestampNanos = timestampNanos;
        sample.maxStartTime = timestampNanos;
        sample.minStartTime = timestampNanos;
        sample.acceleration = this.acceleration;
        sample.accelerationMax = this.acceleration;
        sample.accelerationMin = this.acceleration;
        sample.maxStartValue = this.acceleration;
        sample.minStartValue = this.acceleration;
        this.nearestBack = this.updateNearest(this.nearestBack != null ? this.nearestBack : this.oldest, timestampNanos - 100000000L);
        if (this.nearestBack != null && this.nearestBack.timestampNanos < timestampNanos) {
            double dt = (double)(timestampNanos - this.nearestBack.timestampNanos) / 1.0E9;
            this.jerk = this.alphaJerk * this.jerk + (1.0 - this.alphaJerk) * (this.acceleration - this.nearestBack.acceleration) / dt;
            this.jerk *= jerkCorrection;
            if (this.jerk > 2.0) {
                sample.spurt = 1;
            } else if (this.jerk > 0.4) {
                sample.racing = 1;
            } else if (this.jerk < -2.0) {
                sample.braking = 1;
            } else if (this.jerk < -0.4) {
                sample.retard = 1;
            } else {
                sample.steady = 1;
            }
        } else {
            sample.steady = 1;
        }
        if (this.newest != null) {
            this.newest.next = sample;
        }
        sample.prev = this.newest;
        this.newest = sample;
        if (this.oldest == null) {
            this.oldest = sample;
        }
        this.updateMinMax();
        this.addSample(sample);
        if (this.isEnoughData()) {
            if (timestampNanos <= this.validTimestampNanos) {
                this.state = 2;
                this.stableTillTimestampNanos = 0L;
            } else if (timestampNanos > this.stableTillTimestampNanos) {
                int newState;
                int n = newState = this.isRest() ? 1 : 2;
                if (newState == 1 || this.state == 1) {
                    this.stableTillTimestampNanos = timestampNanos + this.decisionValidnessIntervalNanos;
                }
                this.state = newState;
            }
        } else {
            this.state = 0;
            this.stableTillTimestampNanos = 0L;
        }
    }

    private double srss(Valuable v1, Valuable v2, Valuable v3) {
        return Math.sqrt(this.smsq(v1.getValue(), v2.getValue(), v3.getValue()));
    }

    private double smsq(double v1, double v2, double v3) {
        return v1 * v1 + v2 * v2 + v3 * v3;
    }

    private double scalarProduct(Valuable a1, Valuable b1, Valuable a2, Valuable b2, Valuable a3, Valuable b3) {
        return a1.getValue() * b1.getValue() + a2.getValue() * b2.getValue() + a3.getValue() * b3.getValue();
    }

    private Sample updateNearest(Sample sample, long timestampNanos) {
        Sample result = null;
        while (sample != null && sample.timestampNanos < timestampNanos) {
            result = sample;
            sample = sample.next;
        }
        return result;
    }

    private void updateMinMax() {
        Sample sample = this.newest;
        if (sample == null) {
            return;
        }
        while (sample != this.nearestBack && sample.prev != null) {
            if (sample.prev.accelerationMax < sample.accelerationMax) {
                sample.prev.accelerationMax = sample.accelerationMax;
            }
            if (sample.prev.accelerationMin > sample.accelerationMin) {
                sample.prev.accelerationMin = sample.accelerationMin;
            }
            sample = sample.prev;
        }
        if (sample == this.nearestBack) {
            if (this.newest.acceleration == sample.next.accelerationMax) {
                this.newest.max = 1;
                this.newest.maxStartTime = this.newest.prev.maxStartTime;
                this.newest.maxStartValue = this.newest.prev.maxStartValue;
            } else {
                this.newest.max = 0;
            }
            if (this.newest.acceleration == sample.next.accelerationMin) {
                this.newest.min = 1;
                this.newest.minStartTime = this.newest.prev.minStartTime;
                this.newest.minStartValue = this.newest.prev.minStartValue;
            } else {
                this.newest.min = 0;
            }
        }
    }

    void purgeRollingValues(long newestTimestamp) {
        long minTimestamp = newestTimestamp - this.decisionMakingIntervalNanos;
        while (this.oldest != null && this.oldest.timestampNanos < minTimestamp && this.oldest.next != null && this.oldest.next.timestampNanos < minTimestamp) {
            Sample removed = this.oldest;
            this.oldest = removed.next;
            this.oldest.prev = null;
            this.removeSample(removed);
            this.pool.release(removed);
        }
    }

    private void addSample(Sample sample) {
        this.accelerationMaxSum += sample.accelerationMax;
        this.maxCount += sample.max;
        this.steadyCount += sample.steady;
        ++this.samplesCount;
    }

    private void removeSample(Sample sample) {
        this.accelerationMaxSum -= sample.accelerationMax;
        this.maxCount -= sample.max;
        this.steadyCount -= sample.steady;
        --this.samplesCount;
    }

    private boolean isEnoughData() {
        return this.samplesCount > 1 && this.oldest != null && this.newest != null && this.oldest.timestampNanos >= this.startTimestampNanos + this.delayIntervalNanos && this.newest.timestampNanos >= this.oldest.timestampNanos + this.decisionMakingIntervalNanos && this.nearestBack != null;
    }

    private boolean isRest() {
        if (this.steadyCount != this.samplesCount) {
            return false;
        }
        return this.maxCount <= 0 || !(this.accelerationMaxSum / (double)this.samplesCount > 0.01);
    }

    public int getState() {
        return this.state;
    }

    @Override
    public void reset() {
        while (this.oldest != null) {
            Sample removed = this.oldest;
            this.oldest = removed.next;
            this.pool.release(removed);
        }
        this.nearestBack = null;
        this.newest = null;
        this.startTimestampNanos = 0L;
        this.validTimestampNanos = 0L;
        this.stableTillTimestampNanos = 0L;
        this.gravity.reset();
        this.linear.reset();
        this.forward.reset();
        this.scalarLF = 0.0;
        this.acceleration = 0.0;
        this.jerk = 0.0;
        this.accelerationMaxSum = 0.0;
        this.maxCount = 0;
        this.steadyCount = 0;
        this.samplesCount = 0;
        this.state = 0;
    }

    static class SamplePool {
        Sample head;

        SamplePool() {
        }

        Sample acquire() {
            Sample acquired = this.head;
            if (acquired == null) {
                acquired = new Sample();
            } else {
                this.head = acquired.next;
                acquired.reset();
            }
            return acquired;
        }

        void release(Sample sample) {
            sample.next = this.head;
            sample.prev = null;
            this.head = sample;
        }
    }

    static class Sample {
        long timestampNanos;
        double acceleration;
        double accelerationMax;
        double accelerationMin;
        int max;
        int min;
        long maxStartTime;
        double maxStartValue;
        long minStartTime;
        double minStartValue;
        int spurt;
        int racing;
        int steady;
        int retard;
        int braking;
        Sample next;
        Sample prev;

        Sample() {
        }

        void reset() {
            this.timestampNanos = 0L;
            this.acceleration = 0.0;
            this.accelerationMax = 0.0;
            this.accelerationMin = 0.0;
            this.max = 0;
            this.min = 0;
            this.maxStartTime = 0L;
            this.maxStartValue = 0.0;
            this.minStartTime = 0L;
            this.minStartValue = 0.0;
            this.spurt = 0;
            this.racing = 0;
            this.steady = 0;
            this.retard = 0;
            this.braking = 0;
            this.next = null;
            this.prev = null;
        }
    }
}

