/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.motiondetector;

import com.startapp.motiondetector.AmortizedMaximum;
import com.startapp.motiondetector.HighPassFilter;
import com.startapp.motiondetector.HighPassFilter3D;
import com.startapp.motiondetector.RestStateRecognizer;
import com.startapp.motiondetector.SignalProcessor;
import com.startapp.motiondetector.Utils;
import com.startapp.motiondetector.VehicleDriverRecognizer;
import com.startapp.motiondetector.VehiclePassengerRecognizer;
import com.startapp.motiondetector.Vibration3DRecognizer;
import com.startapp.motiondetector.VibrationRecognizer;

public class TravelRecognizer
implements SignalProcessor {
    private final HighPassFilter3D gravity;
    private final HighPassFilter3D linear;
    private final HighPassFilter linearM;
    private final Vibration3DRecognizer vibration;
    private final VehiclePassengerRecognizer vehiclePassenger;
    private final HighPassFilter vehiclePassengerHpf;
    private final AmortizedMaximum passengerInstability;
    private final VehicleDriverRecognizer vehicleDriver;
    private final AmortizedMaximum driverInstability;
    private final RestStateRecognizer restState;
    private final AmortizedMaximum travel;
    private long startTimestampNanos;
    private long lastTimestampNanos;

    public void setTravelProbabilityMaximum(double value, long time) {
        this.travel.setMaximumValue(Math.min(Math.max(0.0, value), 1.0));
        this.travel.setMaximumTime(time);
    }

    public TravelRecognizer() {
        this(10.0, 15.0, 25.0, 1000.0, 1.0, 0.1, 100.0, 1.0, 3600000.0, 3.0, -2.0, 100.0, 1.0, 20000.0, 0.0, -4.0);
    }

    public TravelRecognizer(double hpfGravityBase, double hpfLinearBase, double hpfLinearMagnitudeBase, double hpfVehicle, double vibrationDecisionMakingIntervalSeconds, double vibrationMinAmplitude, double amortizedWeightHistory, double amortizedWeightRealtime, double amortizedPeriodMillis, double amortizedPeriodMin, double amortizedPeriodScale, double instabilityWeightHistory, double instabilityWeightRealtime, double instabilityPeriodMillis, double instabilityPeriodMin, double instabilityPeriodScale) {
        this.gravity = new HighPassFilter3D(new HighPassFilter(hpfGravityBase), new HighPassFilter(hpfGravityBase), new HighPassFilter(hpfGravityBase));
        this.linear = new HighPassFilter3D(new HighPassFilter(hpfLinearBase), new HighPassFilter(hpfLinearBase), new HighPassFilter(hpfLinearBase));
        this.linearM = new HighPassFilter(hpfLinearMagnitudeBase);
        this.vibration = new Vibration3DRecognizer(new VibrationRecognizer(vibrationDecisionMakingIntervalSeconds, vibrationMinAmplitude, this.gravity.getX()), new VibrationRecognizer(vibrationDecisionMakingIntervalSeconds, vibrationMinAmplitude, this.gravity.getY()), new VibrationRecognizer(vibrationDecisionMakingIntervalSeconds, vibrationMinAmplitude, this.gravity.getZ()));
        this.vehiclePassenger = new VehiclePassengerRecognizer();
        this.vehiclePassengerHpf = new HighPassFilter(hpfVehicle);
        this.passengerInstability = new AmortizedMaximum(instabilityWeightHistory, instabilityWeightRealtime, instabilityPeriodMillis, instabilityPeriodMin, instabilityPeriodScale);
        this.vehicleDriver = new VehicleDriverRecognizer();
        this.driverInstability = new AmortizedMaximum(instabilityWeightHistory, instabilityWeightRealtime, instabilityPeriodMillis, instabilityPeriodMin, instabilityPeriodScale);
        this.restState = new RestStateRecognizer(5.0, false);
        this.travel = new AmortizedMaximum(amortizedWeightHistory, amortizedWeightRealtime, amortizedPeriodMillis, amortizedPeriodMin, amortizedPeriodScale);
    }

    public double getVibrationAmplitude() {
        return this.vibration.getAmplitude();
    }

    public double getVibrationFrequency() {
        return this.vibration.getFrequency();
    }

    public double getLinearAcceleration() {
        return this.linearM.getValue();
    }

    public double getTravelProbability() {
        return this.travel.getValue();
    }

    public double getTravelProbabilityMaximumValue() {
        return this.travel.getMaximumValue();
    }

    public long getTravelProbabilityMaximumTime() {
        return this.travel.getMaximumTime();
    }

    public void add(long currentTimeMillis, long timestampNanos, double ax, double ay, double az) {
        if (this.lastTimestampNanos >= timestampNanos) {
            return;
        }
        if (this.startTimestampNanos <= 0L) {
            this.startTimestampNanos = timestampNanos;
        }
        double oldGravityX = this.gravity.getX().getValue();
        double oldGravityY = this.gravity.getY().getValue();
        double oldGravityZ = this.gravity.getZ().getValue();
        this.gravity.add(ax, ay, az);
        double gravityDiff = Utils.smsq(this.gravity.getX().getValue() - oldGravityX, this.gravity.getY().getValue() - oldGravityY, this.gravity.getZ().getValue() - oldGravityZ);
        this.passengerInstability.add(currentTimeMillis, Utils.logisticalFunction(gravityDiff, 1.5, 4.0));
        double passengerStability = 1.0 - this.passengerInstability.getValue();
        this.driverInstability.add(currentTimeMillis, Utils.logisticalFunction(gravityDiff, 0.01, 1000.0));
        this.linear.add(ax - this.gravity.getX().getValue(), ay - this.gravity.getY().getValue(), az - this.gravity.getZ().getValue());
        this.linearM.add(this.linear.getValue());
        this.vibration.add(timestampNanos, ax, ay, az);
        double timeSeconds = (double)(timestampNanos - this.startTimestampNanos) / 1.0E9;
        double fadeIn = Utils.logisticalFunction(timeSeconds, 10.0, 1.0);
        this.vehiclePassenger.add(this.vibration.getFrequency(), this.vibration.getAmplitude(), this.linearM.getValue());
        this.vehiclePassengerHpf.add(fadeIn * passengerStability * this.vehiclePassenger.getValue());
        double passenger = this.vehiclePassengerHpf.getValue();
        this.vehicleDriver.add(this.vibration.getFrequency(), this.vibration.getAmplitude(), this.restState.getAcceleration(), this.restState.getJerk());
        this.travel.add(currentTimeMillis, passenger * this.driverInstability.getValue() + fadeIn * this.vehicleDriver.getValue() * (1.0 - this.driverInstability.getValue()));
        this.lastTimestampNanos = timestampNanos;
    }

    @Override
    public void reset() {
        this.startTimestampNanos = 0L;
        this.lastTimestampNanos = 0L;
        this.gravity.reset();
        this.linear.reset();
        this.linearM.reset();
        this.vibration.reset();
        this.vehiclePassenger.reset();
        this.vehiclePassengerHpf.reset();
        this.travel.reset();
    }
}

