/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.motiondetector;

import com.startapp.motiondetector.SignalProcessor;
import com.startapp.motiondetector.Utils;
import com.startapp.motiondetector.Valuable;

public class VehicleDriverRecognizer
implements SignalProcessor,
Valuable {
    private static final double alphaVibration = 0.95;
    private static final double alphaAcceleration = 0.995;
    private static final double alphaJerk = 0.995;
    private static final double alphaResult = 0.9995;
    private static final double weightVibrationFrequency = 2000.0;
    private static final double weightVibrationAmplitude = 1000.0;
    private static final double weightAcceleration = 1000.0;
    private static final double weightJerk = 1000.0;
    private static final double weightSum = 5000.0;
    private static final double zeroVfl = Utils.logisticalFunction(0.0, 8.0, 2.0);
    private static final double zeroVal = Utils.logisticalFunction(0.0, 0.2, 20.0);
    private static final double zeroAl = Utils.logisticalFunction(0.0, 0.2, 6.0);
    private static final double zeroJl = Utils.logisticalFunction(0.0, 0.4, 5.0);
    private double vfl;
    private double val;
    private double al;
    private double jl;
    private double result;

    public void add(double vibrationFrequency, double vibrationAmplitude, double acceleration, double jerk) {
        this.vfl = 0.95 * this.vfl + 0.050000000000000044 * vibrationFrequency;
        this.val = 0.95 * this.val + 0.050000000000000044 * vibrationAmplitude;
        this.al = 0.995 * this.al + 0.0050000000000000044 * Math.abs(acceleration);
        this.jl = 0.995 * this.jl + 0.0050000000000000044 * Math.abs(jerk);
        double r = Utils.logisticalFunction0(this.vfl, 8.0, 2.0, zeroVfl) * 2000.0 / 5000.0 + Utils.logisticalFunction0(this.val, 0.2, 20.0, zeroVal) * 1000.0 / 5000.0 + Utils.logisticalFunction0(this.al, 0.2, 6.0, zeroAl) * 1000.0 / 5000.0 + Utils.logisticalFunction0(this.jl, 0.4, 5.0, zeroJl) * 1000.0 / 5000.0;
        this.result = 0.9995 * this.result + 4.999999999999449E-4 * r;
    }

    @Override
    public double getValue() {
        return this.result;
    }

    @Override
    public void reset() {
        this.vfl = 0.0;
        this.val = 0.0;
        this.al = 0.0;
        this.jl = 0.0;
        this.result = 0.0;
    }
}

