/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.motiondetector;

import com.startapp.motiondetector.SignalProcessor;
import com.startapp.motiondetector.Utils;
import com.startapp.motiondetector.Valuable;

public class VehiclePassengerRecognizer
implements SignalProcessor,
Valuable {
    private static final double alphaVf = 0.0;
    private static final double alphaVa = 0.0;
    private static final double alphaLa = 0.0;
    private static final double weightVf = 100.0;
    private static final double weightVa = 70.0;
    private static final double weightLa = 100.0;
    private static final double weightSum = 270.0;
    private double vf;
    private double va;
    private double la;
    private double probability;

    @Override
    public double getValue() {
        return this.probability;
    }

    @Override
    public void reset() {
        this.vf = 0.0;
        this.va = 0.0;
        this.la = 0.0;
        this.probability = 0.0;
    }

    public void add(double vibrationFrequency, double vibrationAmplitude, double linearAcceleration) {
        this.vf = 0.0 * this.vf + 1.0 * VehiclePassengerRecognizer.vfFunction(vibrationFrequency);
        this.va = 0.0 * this.va + 1.0 * VehiclePassengerRecognizer.vaFunciton(vibrationAmplitude);
        this.la = 0.0 * this.la + 1.0 * VehiclePassengerRecognizer.laFunciton(linearAcceleration);
        this.probability = this.vf * 100.0 / 270.0 + this.va * 70.0 / 270.0 + this.la * 100.0 / 270.0;
    }

    static double laFunciton(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x < 0.5) {
            return Math.pow(2.0 * x, 4.0);
        }
        if (x > 5.0) {
            return Math.exp((5.0 - x) * 4.0);
        }
        return 1.0;
    }

    static double vaFunciton(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x < 0.5) {
            return Math.pow(2.0 * x, 4.0);
        }
        if (x > 2.0) {
            return Math.exp((2.0 - x) * 6.0);
        }
        return 1.0;
    }

    static double vfFunction(double x) {
        return Math.min(Utils.gaussian(x, 2.0, 7.0, 1.0), 1.0);
    }
}

