/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.motiondetector;

import com.startapp.motiondetector.Periodical;
import com.startapp.motiondetector.SignalProcessor;
import com.startapp.motiondetector.VibrationRecognizer;

public class Vibration3DRecognizer
implements SignalProcessor,
Periodical {
    private final VibrationRecognizer x;
    private final VibrationRecognizer y;
    private final VibrationRecognizer z;
    private double frequency;
    private double amplitude;

    public Vibration3DRecognizer(VibrationRecognizer x, VibrationRecognizer y, VibrationRecognizer z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void add(long timestampNanos, double valueX, double valueY, double valueZ) {
        this.x.add(timestampNanos, valueX);
        this.y.add(timestampNanos, valueY);
        this.z.add(timestampNanos, valueZ);
        double vax = this.x.getAmplitude();
        double vay = this.y.getAmplitude();
        double vaz = this.z.getAmplitude();
        double vam = vax + vay + vaz;
        if (vam > 0.0) {
            double vfx = this.x.getFrequency() * vax / vam;
            double vfy = this.y.getFrequency() * vay / vam;
            double vfz = this.z.getFrequency() * vaz / vam;
            this.frequency = vfx + vfy + vfz;
            this.amplitude = vam / 3.0;
        } else {
            this.frequency = 0.0;
            this.amplitude = 0.0;
        }
    }

    @Override
    public double getFrequency() {
        return this.frequency;
    }

    @Override
    public double getAmplitude() {
        return this.amplitude;
    }

    @Override
    public void reset() {
        this.x.reset();
        this.y.reset();
        this.z.reset();
        this.frequency = 0.0;
        this.amplitude = 0.0;
    }
}

