/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.motiondetector;

import com.startapp.motiondetector.Periodical;
import com.startapp.motiondetector.SignalProcessor;
import com.startapp.motiondetector.Valuable;

public class VibrationRecognizer
implements SignalProcessor,
Periodical {
    private final SamplePool pool = new SamplePool();
    private final long decisionMakingIntervalNanos;
    private final double minAmplitude;
    private final Valuable average;
    private double v0;
    private double v1;
    private double v2;
    private long t1;
    private long t2;
    private double localMaxValue;
    private long localMaxTime;
    private long localZeroTime;
    private Sample oldest;
    private Sample newest;
    private int zeros;
    private double frequency;
    private double amplitude;
    private double amplitudeSum;

    public VibrationRecognizer(double decisionMakingIntervalSeconds, double minAmplitude, Valuable average) {
        this.decisionMakingIntervalNanos = (long)(decisionMakingIntervalSeconds * 1.0E9);
        this.minAmplitude = minAmplitude;
        this.average = average;
    }

    @Override
    public double getFrequency() {
        return this.frequency;
    }

    @Override
    public double getAmplitude() {
        return this.amplitude;
    }

    @Override
    public void reset() {
        while (this.oldest != null) {
            Sample removed = this.oldest;
            this.oldest = removed.next;
            this.pool.release(removed);
        }
        this.newest = null;
        this.v0 = 0.0;
        this.v1 = 0.0;
        this.v2 = 0.0;
        this.t1 = 0L;
        this.t2 = 0L;
        this.localMaxValue = 0.0;
        this.localMaxTime = 0L;
        this.localZeroTime = 0L;
        this.zeros = 0;
        this.frequency = 0.0;
        this.amplitude = 0.0;
        this.amplitudeSum = 0.0;
    }

    public void add(long timestampNanos, double value) {
        long interval;
        double a;
        this.v0 = this.v1;
        this.v1 = this.v2;
        this.v2 = value;
        this.t1 = this.t2;
        this.t2 = timestampNanos;
        this.purgeSamples(timestampNanos);
        Sample sample = this.pool.acquire();
        sample.time = this.t2;
        sample.timeZero = this.localZeroTime;
        double averageValue = this.average.getValue();
        if (this.v0 < this.v1 && this.v1 > this.v2 && (a = this.v1 - averageValue) > this.minAmplitude) {
            this.localMaxValue = a;
            this.localMaxTime = this.t1;
        }
        if (this.v1 > averageValue && averageValue > this.v2 && this.localMaxTime > this.localZeroTime) {
            this.localZeroTime = this.t2;
            sample.zero = 1;
            sample.amplitude = this.localMaxValue;
        }
        this.addSample(sample);
        if (this.newest != null) {
            this.newest.next = sample;
        }
        this.newest = sample;
        if (this.oldest == null) {
            this.oldest = sample;
        }
        if ((interval = this.localZeroTime - this.oldest.timeZero) > 0L) {
            double intervalSeconds = (double)interval / 1.0E9;
            this.frequency = (double)this.zeros / intervalSeconds;
        }
        this.amplitude = this.zeros > 0 ? this.amplitudeSum / (double)this.zeros : 0.0;
    }

    private void addSample(Sample sample) {
        this.zeros += sample.zero;
        this.amplitudeSum += sample.amplitude;
    }

    private void removeSample(Sample sample) {
        this.zeros -= sample.zero;
        this.amplitudeSum -= sample.amplitude;
    }

    void purgeSamples(long newestTimestamp) {
        long minTimestamp = newestTimestamp - this.decisionMakingIntervalNanos;
        while (this.oldest != null && this.oldest.time < minTimestamp && this.oldest.next != null && this.oldest.next.time < minTimestamp) {
            Sample removed = this.oldest;
            this.oldest = removed.next;
            this.removeSample(removed);
            this.pool.release(removed);
        }
    }

    static class SamplePool {
        private Sample head;

        SamplePool() {
        }

        Sample acquire() {
            Sample acquired = this.head;
            if (acquired == null) {
                acquired = new Sample();
            } else {
                this.head = acquired.next;
                acquired.reset();
            }
            return acquired;
        }

        void release(Sample sample) {
            sample.next = this.head;
            this.head = sample;
        }
    }

    static class Sample {
        Sample next;
        long time;
        long timeZero;
        int zero;
        double amplitude;

        Sample() {
        }

        void reset() {
            this.next = null;
            this.time = 0L;
            this.timeZero = 0L;
            this.zero = 0;
            this.amplitude = 0.0;
        }
    }
}

