/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.algo;

import com.startapp.simple.bloomfilter.algo.MurmurHash;
import com.startapp.simple.bloomfilter.algo.OpenBitSet;
import java.nio.ByteBuffer;
import java.util.List;

public class BitSetHandling {
    private final int numberOfHashes;
    private final int sizeOfBucket;

    public BitSetHandling(int numberOfHashes, int sizeOfBucket) {
        this.numberOfHashes = numberOfHashes;
        this.sizeOfBucket = sizeOfBucket;
    }

    public OpenBitSet keysToBitSet(List<String> applicationsKeys) {
        OpenBitSet bitSet = new OpenBitSet(this.numberOfHashes * this.sizeOfBucket);
        this.fillBitSetWithKeys(applicationsKeys, bitSet);
        return bitSet;
    }

    public long[] hashBucketsFromApplication(String key) {
        OpenBitSet dummyOpenBitSetForSizing = new OpenBitSet(this.numberOfHashes * this.sizeOfBucket);
        return this.getHashBuckets(ByteBuffer.wrap(key.getBytes()), dummyOpenBitSetForSizing.size());
    }

    void fillBitSetWithKeys(List<String> applicationsKeys, OpenBitSet bitSet) {
        for (String key : applicationsKeys) {
            byte[] bytesOfKey = key.getBytes();
            this.add(ByteBuffer.wrap(bytesOfKey), bitSet);
        }
    }

    boolean isPresent(long[] hashBuckets, OpenBitSet bitSet) {
        if (hashBuckets.length == 0) {
            return false;
        }
        for (long bucketIndex : hashBuckets) {
            if (bitSet.indexInBits(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    boolean isPresent(String key, OpenBitSet bitSet) {
        ByteBuffer buffer = ByteBuffer.wrap(key.getBytes());
        return this.isPresent(buffer, bitSet);
    }

    private boolean isPresent(ByteBuffer key, OpenBitSet bitSet) {
        long[] hashBuckets = this.getHashBuckets(key, bitSet.size());
        return this.isPresent(hashBuckets, bitSet);
    }

    private void add(ByteBuffer key, OpenBitSet bitSet) {
        long[] hashBuckets;
        for (long bucketIndex : hashBuckets = this.getHashBuckets(key, bitSet.size())) {
            bitSet.set(bucketIndex);
        }
    }

    private long[] getHashBuckets(ByteBuffer byteBuffer, long sizeOfBitset) {
        long[] result = new long[this.numberOfHashes];
        long chunkSize = sizeOfBitset / (long)this.numberOfHashes;
        long hash1 = MurmurHash.hash64(byteBuffer, byteBuffer.position(), byteBuffer.remaining(), 0L);
        long hash2 = MurmurHash.hash64(byteBuffer, byteBuffer.position(), byteBuffer.remaining(), hash1);
        for (int i = 0; i < this.numberOfHashes; ++i) {
            result[i] = (long)i * chunkSize + Math.abs((hash1 + (long)i * hash2) % chunkSize);
        }
        return result;
    }
}

