/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.algo;

import com.startapp.simple.bloomfilter.algo.BitSetHandling;
import com.startapp.simple.bloomfilter.algo.BloomContainer;
import com.startapp.simple.bloomfilter.algo.OpenBitSet;
import com.startapp.simple.bloomfilter.codec.StringUtils;
import com.startapp.simple.bloomfilter.version.BloomVersion;
import java.util.List;

public class BloomContainerWithValidBitSet
implements BloomContainer {
    private final BitSetHandling bitSetHandling;
    private final OpenBitSet bitSet;
    private final BloomVersion bloomVersion;

    public BloomContainerWithValidBitSet(BitSetHandling bitSetHandling, OpenBitSet bitSet, BloomVersion bloomVersion) {
        this.bitSetHandling = bitSetHandling;
        this.bitSet = bitSet;
        this.bloomVersion = bloomVersion;
    }

    @Override
    public boolean contains(String key) {
        if (StringUtils.isBlank(key)) {
            return false;
        }
        return this.bitSetHandling.isPresent(key, this.bitSet);
    }

    @Override
    public boolean contains(long[] hashBytes) {
        if (hashBytes == null) {
            return false;
        }
        return this.bitSetHandling.isPresent(hashBytes, this.bitSet);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public BloomVersion getBloomVersion() {
        return this.bloomVersion;
    }

    @Override
    public void addNewKeys(List<String> keys) {
        this.bitSetHandling.fillBitSetWithKeys(keys, this.bitSet);
    }

    @Override
    public OpenBitSet getBitSet() {
        return this.bitSet;
    }
}

