/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.algo;

import java.nio.ByteBuffer;

public class MurmurHash {
    public static long hash64(ByteBuffer key, int offset, int length, long seed) {
        long m64 = -4132994306676758123L;
        int r64 = 47;
        long h64 = seed & 0xFFFFFFFFL ^ m64 * (long)length;
        int lenLongs = length >> 3;
        for (int i = 0; i < lenLongs; ++i) {
            int i_8 = i << 3;
            long k64 = ((long)key.get(offset + i_8 + 0) & 0xFFL) + (((long)key.get(offset + i_8 + 1) & 0xFFL) << 8) + (((long)key.get(offset + i_8 + 2) & 0xFFL) << 16) + (((long)key.get(offset + i_8 + 3) & 0xFFL) << 24) + (((long)key.get(offset + i_8 + 4) & 0xFFL) << 32) + (((long)key.get(offset + i_8 + 5) & 0xFFL) << 40) + (((long)key.get(offset + i_8 + 6) & 0xFFL) << 48) + (((long)key.get(offset + i_8 + 7) & 0xFFL) << 56);
            k64 *= m64;
            k64 ^= k64 >>> r64;
            h64 ^= (k64 *= m64);
            h64 *= m64;
        }
        int rem = length & 7;
        switch (rem) {
            case 0: {
                break;
            }
            case 7: {
                h64 ^= (long)key.get(offset + length - rem + 6) << 48;
            }
            case 6: {
                h64 ^= (long)key.get(offset + length - rem + 5) << 40;
            }
            case 5: {
                h64 ^= (long)key.get(offset + length - rem + 4) << 32;
            }
            case 4: {
                h64 ^= (long)key.get(offset + length - rem + 3) << 24;
            }
            case 3: {
                h64 ^= (long)key.get(offset + length - rem + 2) << 16;
            }
            case 2: {
                h64 ^= (long)key.get(offset + length - rem + 1) << 8;
            }
            case 1: {
                h64 ^= (long)key.get(offset + length - rem);
                h64 *= m64;
            }
        }
        h64 ^= h64 >>> r64;
        h64 *= m64;
        h64 ^= h64 >>> r64;
        return h64;
    }
}

