/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.simple.bloomfilter.algo;

import java.io.Serializable;

public class OpenBitSet
implements Serializable {
    private static final long serialVersionUID = -901334831550831262L;
    private final long[][] bits;
    private int wlen;
    private final int pageCount;
    public static final int PAGE_SIZE = 4096;
    private static final int PAGE_COUNT_LIMIT = 100;

    public OpenBitSet(long numBits) {
        this.wlen = this.bits2words(numBits);
        int lastPageSize = this.wlen % 4096;
        int fullPageCount = this.wlen / 4096;
        this.pageCount = fullPageCount + (lastPageSize == 0 ? 0 : 1);
        if (this.pageCount > 100) {
            throw new RuntimeException("HighPageCountException pageCount = " + this.pageCount);
        }
        this.bits = new long[this.pageCount][];
        for (int i = 0; i < fullPageCount; ++i) {
            this.bits[i] = new long[4096];
        }
        if (lastPageSize != 0) {
            this.bits[this.bits.length - 1] = new long[lastPageSize];
        }
    }

    long size() {
        return (long)this.wlen << 6;
    }

    void set(long index) {
        int wordNum = this.expandingWordNum(index);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] | bitmask;
    }

    boolean indexInBits(long index) {
        int i = (int)(index >> 6);
        if (i >= this.wlen) {
            return false;
        }
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i / 4096][i % 4096] & bitmask) != 0L;
    }

    private int expandingWordNum(long index) {
        int wordNum = (int)(index >> 6);
        if (wordNum >= this.wlen) {
            this.ensureCapacity(index + 1L);
            this.wlen = wordNum + 1;
        }
        return wordNum;
    }

    private void ensureCapacity(long numBits) {
        this.ensureCapacityWords(this.bits2words(numBits));
    }

    private int bits2words(long numBits) {
        return (int)((numBits - 1L >>> 6) + 1L);
    }

    private void ensureCapacityWords(int numWords) {
        assert (numWords <= this.wlen) : "Growing of paged bitset is not supported";
    }

    public int getNumWords() {
        return this.wlen;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public long[] getPage(int pageIdx) {
        return this.bits[pageIdx];
    }
}

